/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.demo;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.qpid.client.AMQConnectionFactory;

public class Subscribe {
    public static final String QUEUE = "'amq.direct'/'testQueue'; { node: { type: queue } }";
    private static final long MESSAGE_TIMEOUT_MILLIS = 15000L;
    private static final int MESSAGE_COUNT = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... argv) throws Exception {
        Preconditions.checkElementIndex((int)0, (int)argv.length, (String)"Must specify broker URL");
        String url = argv[0];
        System.setProperty("qpid.amqp.version", "0-10");
        System.setProperty("qpid.dest_syntax", "ADDR");
        AMQConnectionFactory factory = new AMQConnectionFactory(url);
        Connection connection = factory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        System.out.printf("Waiting up to %s milliseconds to receive %s messages\n", 15000L, 100);
        try {
            Queue destination = session.createQueue(QUEUE);
            MessageConsumer messageConsumer = session.createConsumer((Destination)destination);
            for (int n = 0; n < 100; ++n) {
                TextMessage msg = (TextMessage)messageConsumer.receive(15000L);
                if (msg == null) {
                    System.out.printf("No message received in %s milliseconds, exiting", 15000L);
                    break;
                }
                System.out.printf("Got message %d: '%s'\n", n + 1, msg.getText());
            }
        }
        catch (Exception e) {
            System.err.printf("Error while receiving - %s\n", e.getMessage());
            System.err.printf("Cause: %s\n", Throwables.getStackTraceAsString((Throwable)e));
        }
        finally {
            session.close();
            connection.close();
        }
    }
}

