/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.demo;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.qpid.client.AMQConnectionFactory;

public class Publish {
    public static final String QUEUE = "'amq.direct'/'testQueue'; { node: { type: queue } }";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... argv) throws Exception {
        Preconditions.checkElementIndex((int)0, (int)argv.length, (String)"Must specify broker URL");
        String url = argv[0];
        System.setProperty("qpid.amqp.version", "0-10");
        System.setProperty("qpid.dest_syntax", "ADDR");
        AMQConnectionFactory factory = new AMQConnectionFactory(url);
        Connection connection = factory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        try {
            Queue destination = session.createQueue(QUEUE);
            MessageProducer messageProducer = session.createProducer((Destination)destination);
            for (int n = 0; n < 100; ++n) {
                String body = String.format("test message %03d", n + 1);
                TextMessage message = session.createTextMessage(body);
                messageProducer.send((Message)message);
                System.out.printf("Sent message %s\n", body);
            }
        }
        catch (Exception e) {
            System.err.printf("Error while sending - %s\n", e.getMessage());
            System.err.printf("Cause: %s\n", Throwables.getStackTraceAsString((Throwable)e));
        }
        finally {
            session.close();
            connection.close();
        }
    }
}

