/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.demo;

import brooklyn.catalog.Catalog;
import brooklyn.catalog.CatalogConfig;
import brooklyn.config.ConfigKey;
import brooklyn.config.StringConfigMap;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.basic.AbstractApplication;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.StartableApplication;
import brooklyn.entity.dns.geoscaling.GeoscalingDnsService;
import brooklyn.entity.group.DynamicRegionsFabric;
import brooklyn.entity.proxy.AbstractController;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.webapp.ElasticJavaWebAppService;
import brooklyn.entity.webapp.JavaWebAppService;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.launcher.BrooklynLauncher;
import brooklyn.location.basic.PortRanges;
import brooklyn.util.BrooklynMavenArtifacts;
import brooklyn.util.CommandLineUtil;
import brooklyn.util.ResourceUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Catalog(name="Global Web Fabric", description="Deploys a WAR to multiple clusters, showing how Brooklyn fabrics work", iconUrl="classpath://brooklyn/demo/glossy-3d-blue-web-icon.png")
public class GlobalWebFabricExample
extends AbstractApplication {
    public static final Logger log = LoggerFactory.getLogger(GlobalWebFabricExample.class);
    static final List<String> DEFAULT_LOCATIONS = ImmutableList.of((Object)"aws-ec2:eu-west-1", (Object)"aws-ec2:ap-southeast-1", (Object)"aws-ec2:us-west-1");
    public static final String DEFAULT_WAR_PATH = (String)ResourceUtils.create(GlobalWebFabricExample.class).firstAvailableUrl(new String[]{"classpath://hello-world-webapp.war", BrooklynMavenArtifacts.localUrl((String)"example", (String)"brooklyn-example-hello-world-webapp", (String)"war")}).or((Object)"classpath://hello-world-webapp.war");
    @CatalogConfig(label="WAR (URL)", priority=2.0)
    public static final ConfigKey<String> WAR_PATH = ConfigKeys.newConfigKey((String)"app.war", (String)"URL to the application archive which should be deployed", (Object)DEFAULT_WAR_PATH);
    @CatalogConfig(label="Proxy server HTTP port")
    public static final PortAttributeSensorAndConfigKey PROXY_HTTP_PORT = new PortAttributeSensorAndConfigKey(AbstractController.PROXY_HTTP_PORT, (Object)PortRanges.fromInteger((int)80));

    public void initApp() {
        StringConfigMap config = this.getManagementContext().getConfig();
        GeoscalingDnsService geoDns = (GeoscalingDnsService)this.addChild(((EntitySpec)EntitySpec.create(GeoscalingDnsService.class).displayName("GeoScaling DNS")).configure((CharSequence)"username", Preconditions.checkNotNull((Object)config.getFirst(new String[]{"brooklyn.geoscaling.username"}), (Object)"username")).configure((CharSequence)"password", Preconditions.checkNotNull((Object)config.getFirst(new String[]{"brooklyn.geoscaling.password"}), (Object)"password")).configure((CharSequence)"primaryDomainName", Preconditions.checkNotNull((Object)config.getFirst(new String[]{"brooklyn.geoscaling.primaryDomain"}), (Object)"primaryDomain")).configure((CharSequence)"smartSubdomainName", (Object)"brooklyn"));
        DynamicRegionsFabric webFabric = (DynamicRegionsFabric)this.addChild(((EntitySpec)EntitySpec.create(DynamicRegionsFabric.class).displayName("Web Fabric")).configure(DynamicRegionsFabric.FACTORY, (Object)new ElasticJavaWebAppService.Factory()).configure(JavaWebAppService.ROOT_WAR, (Object)Entities.getRequiredUrlConfig((Entity)this, WAR_PATH)));
        geoDns.setTargetEntityProvider((Group)webFabric);
    }

    public static void main(String[] argv) {
        ArrayList args = Lists.newArrayList((Object[])argv);
        String port = CommandLineUtil.getCommandLineOption((List)args, (String)"--port", (String)"8081+");
        String locations = CommandLineUtil.getCommandLineOption((List)args, (String)"--locations", (String)Joiner.on((String)",").join(DEFAULT_LOCATIONS));
        BrooklynLauncher launcher = BrooklynLauncher.newInstance().application((EntitySpec)EntitySpec.create(StartableApplication.class, GlobalWebFabricExample.class).displayName("Brooklyn Global Web Fabric Example")).webconsolePort(port).locations(Arrays.asList(locations)).start();
        Entities.dumpInfo((Iterable)launcher.getApplications());
    }
}

