/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test.framework;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.test.entity.TestApplication;
import org.apache.brooklyn.location.localhost.LocalhostMachineProvisioningLocation;
import org.apache.brooklyn.test.framework.TestSensor;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.PropagatedRuntimeException;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestSensorTest {
    private static final AttributeSensorAndConfigKey<Boolean, Boolean> BOOLEAN_SENSOR = ConfigKeys.newSensorAndConfigKey(Boolean.class, (String)"boolean-sensor", (String)"Boolean Sensor");
    private static final AttributeSensorAndConfigKey<String, String> STRING_SENSOR = ConfigKeys.newSensorAndConfigKey(String.class, (String)"string-sensor", (String)"String Sensor");
    private static final AttributeSensorAndConfigKey<Integer, Integer> INTEGER_SENSOR = ConfigKeys.newIntegerSensorAndConfigKey((String)"integer-sensor", (String)"Integer Sensor");
    private static final AttributeSensorAndConfigKey<Object, Object> OBJECT_SENSOR = ConfigKeys.newSensorAndConfigKey(Object.class, (String)"object-sensor", (String)"Object Sensor");
    private TestApplication app;
    private ManagementContext managementContext;
    private LocalhostMachineProvisioningLocation loc;
    private String testId;

    @BeforeMethod
    public void setup() {
        this.testId = Identifiers.makeRandomId((int)8);
        this.app = TestApplication.Factory.newManagedInstanceForTests();
        this.managementContext = this.app.getManagementContext();
        this.loc = (LocalhostMachineProvisioningLocation)this.managementContext.getLocationManager().createLocation((LocationSpec)LocationSpec.create(LocalhostMachineProvisioningLocation.class).configure((CharSequence)"name", (Object)this.testId));
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.app != null) {
            Entities.destroyAll((ManagementContext)this.app.getManagementContext());
        }
    }

    @Test
    public void testAssertEqual() {
        int testInteger = 100;
        this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(TestSensor.class).configure((ConfigKey.HasConfigKey)TestSensor.TARGET_ENTITY, (Object)this.app)).configure(TestSensor.SENSOR_NAME, (Object)BOOLEAN_SENSOR.getName())).configure(TestSensor.ASSERTIONS, this.newMapAssertion("equals", true)));
        this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(TestSensor.class).configure((ConfigKey.HasConfigKey)TestSensor.TARGET_ENTITY, (Object)this.app)).configure(TestSensor.SENSOR_NAME, (Object)STRING_SENSOR.getName())).configure(TestSensor.ASSERTIONS, this.newListAssertion("equals", this.testId)));
        this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(TestSensor.class).configure((ConfigKey.HasConfigKey)TestSensor.TARGET_ENTITY, (Object)this.app)).configure(TestSensor.SENSOR_NAME, (Object)INTEGER_SENSOR.getName())).configure(TestSensor.ASSERTIONS, this.newListAssertion("equals", testInteger)));
        this.app.sensors().set(BOOLEAN_SENSOR, (Object)Boolean.TRUE);
        this.app.sensors().set(INTEGER_SENSOR, (Object)testInteger);
        this.app.sensors().set(STRING_SENSOR, (Object)this.testId);
        this.app.start((Collection)ImmutableList.of((Object)this.loc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAssertEqualFailure() {
        boolean booleanAssertFailed = false;
        this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(TestSensor.class).configure((ConfigKey.HasConfigKey)TestSensor.TARGET_ENTITY, (Object)this.app)).configure(TestSensor.SENSOR_NAME, (Object)BOOLEAN_SENSOR.getName())).configure(TestSensor.ASSERTIONS, this.newMapAssertion("equals", true)));
        this.app.sensors().set(BOOLEAN_SENSOR, (Object)Boolean.FALSE);
        try {
            this.app.start((Collection)ImmutableList.of((Object)this.loc));
        }
        catch (PropagatedRuntimeException pre) {
            AssertionError assertionError = (AssertionError)((Object)Exceptions.getFirstThrowableOfType((Throwable)pre, AssertionError.class));
            Assertions.assertThat((Throwable)((Object)assertionError)).isNotNull();
            booleanAssertFailed = true;
        }
        finally {
            Assertions.assertThat((boolean)booleanAssertFailed).isTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAssertEqualOnNullSensor() {
        boolean booleanAssertFailed = false;
        this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(TestSensor.class).configure((ConfigKey.HasConfigKey)TestSensor.TARGET_ENTITY, (Object)this.app)).configure(TestSensor.SENSOR_NAME, (Object)BOOLEAN_SENSOR.getName())).configure(TestSensor.ASSERTIONS, this.newListAssertion("equals", false)));
        try {
            this.app.start((Collection)ImmutableList.of((Object)this.loc));
        }
        catch (PropagatedRuntimeException pre) {
            AssertionError assertionError = (AssertionError)((Object)Exceptions.getFirstThrowableOfType((Throwable)pre, AssertionError.class));
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)((Object)assertionError)).isNotNull()).as("An assertion error should have been thrown", new Object[0]);
            booleanAssertFailed = true;
        }
        finally {
            Assertions.assertThat((boolean)booleanAssertFailed).isTrue().as("Equals assert should have failed as the sensor is NULL", new Object[0]);
        }
    }

    @Test
    public void testAssertNull() {
        this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(TestSensor.class).configure((ConfigKey.HasConfigKey)TestSensor.TARGET_ENTITY, (Object)this.app)).configure(TestSensor.SENSOR_NAME, (Object)BOOLEAN_SENSOR.getName())).configure(TestSensor.ASSERTIONS, this.newMapAssertion("isNull", true)));
        this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(TestSensor.class).configure((ConfigKey.HasConfigKey)TestSensor.TARGET_ENTITY, (Object)this.app)).configure(TestSensor.SENSOR_NAME, (Object)STRING_SENSOR.getName())).configure(TestSensor.ASSERTIONS, this.newListAssertion("notNull", true)));
        this.app.sensors().set(STRING_SENSOR, (Object)this.testId);
        this.app.start((Collection)ImmutableList.of((Object)this.loc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAssertNullFail() {
        boolean sensorTestFail = false;
        this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(TestSensor.class).configure((ConfigKey.HasConfigKey)TestSensor.TARGET_ENTITY, (Object)this.app)).configure(TestSensor.SENSOR_NAME, (Object)STRING_SENSOR.getName())).configure(TestSensor.ASSERTIONS, this.newMapAssertion("isNull", true)));
        this.app.sensors().set(STRING_SENSOR, (Object)this.testId);
        try {
            this.app.start((Collection)ImmutableList.of((Object)this.loc));
        }
        catch (PropagatedRuntimeException pre) {
            AssertionError assertionError = (AssertionError)((Object)Exceptions.getFirstThrowableOfType((Throwable)pre, AssertionError.class));
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)((Object)assertionError)).isNotNull()).as("An assertion error should have been thrown", new Object[0]);
            sensorTestFail = true;
        }
        finally {
            Assertions.assertThat((boolean)sensorTestFail).isTrue().as("isNull assert should have failed as the sensor has been set", new Object[0]);
        }
    }

    @Test
    public void testAssertMatches() {
        long time = System.currentTimeMillis();
        String sensorValue = String.format("%s%s%s", Identifiers.makeRandomId((int)8), time, Identifiers.makeRandomId((int)8));
        this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(TestSensor.class).configure((ConfigKey.HasConfigKey)TestSensor.TARGET_ENTITY, (Object)this.app)).configure(TestSensor.SENSOR_NAME, (Object)STRING_SENSOR.getName())).configure(TestSensor.ASSERTIONS, this.newListAssertion("matches", String.format(".*%s.*", time))));
        this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(TestSensor.class).configure((ConfigKey.HasConfigKey)TestSensor.TARGET_ENTITY, (Object)this.app)).configure(TestSensor.SENSOR_NAME, (Object)BOOLEAN_SENSOR.getName())).configure(TestSensor.ASSERTIONS, this.newMapAssertion("matches", "true")));
        this.app.sensors().set(STRING_SENSOR, (Object)sensorValue);
        this.app.sensors().set(BOOLEAN_SENSOR, (Object)true);
        this.app.start((Collection)ImmutableList.of((Object)this.loc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAssertmatchesFail() {
        boolean sensorTestFail = false;
        String sensorValue = String.format("%s%s%s", Identifiers.makeRandomId((int)8), System.currentTimeMillis(), Identifiers.makeRandomId((int)8));
        this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(TestSensor.class).configure((ConfigKey.HasConfigKey)TestSensor.TARGET_ENTITY, (Object)this.app)).configure(TestSensor.SENSOR_NAME, (Object)STRING_SENSOR.getName())).configure(TestSensor.ASSERTIONS, this.newListAssertion("matches", String.format(".*%s.*", Identifiers.makeRandomId((int)8)))));
        this.app.sensors().set(STRING_SENSOR, (Object)sensorValue);
        try {
            this.app.start((Collection)ImmutableList.of((Object)this.loc));
        }
        catch (PropagatedRuntimeException pre) {
            AssertionError assertionError = (AssertionError)((Object)Exceptions.getFirstThrowableOfType((Throwable)pre, AssertionError.class));
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)((Object)assertionError)).isNotNull()).as("An assertion error should have been thrown", new Object[0]);
            sensorTestFail = true;
        }
        finally {
            Assertions.assertThat((boolean)sensorTestFail).isTrue().as("matches assert should have failed", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAssertmatchesOnNullSensor() {
        boolean sensorTestFail = false;
        this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(TestSensor.class).configure((ConfigKey.HasConfigKey)TestSensor.TARGET_ENTITY, (Object)this.app)).configure(TestSensor.SENSOR_NAME, (Object)STRING_SENSOR.getName())).configure(TestSensor.ASSERTIONS, this.newMapAssertion("matches", String.format(".*%s.*", Identifiers.makeRandomId((int)8)))));
        try {
            this.app.start((Collection)ImmutableList.of((Object)this.loc));
        }
        catch (PropagatedRuntimeException pre) {
            AssertionError assertionError = (AssertionError)((Object)Exceptions.getFirstThrowableOfType((Throwable)pre, AssertionError.class));
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)((Object)assertionError)).isNotNull()).as("An assertion error should have been thrown", new Object[0]);
            sensorTestFail = true;
        }
        finally {
            Assertions.assertThat((boolean)sensorTestFail).isTrue().as("matches assert should have failed", new Object[0]);
        }
    }

    @Test
    public void testAssertMatchesOnNonStringSensor() {
        this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(TestSensor.class).configure((ConfigKey.HasConfigKey)TestSensor.TARGET_ENTITY, (Object)this.app)).configure(TestSensor.SENSOR_NAME, (Object)OBJECT_SENSOR.getName())).configure(TestSensor.ASSERTIONS, this.newListAssertion("matches", ".*TestObject.*id=.*")));
        this.app.sensors().set(OBJECT_SENSOR, (Object)new TestObject());
        this.app.start((Collection)ImmutableList.of((Object)this.loc));
    }

    private List<Map<String, Object>> newListAssertion(String assertionKey, Object assertionValue) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        result.add((Map<String, Object>)ImmutableMap.of((Object)assertionKey, (Object)assertionValue));
        return result;
    }

    private Map<String, Object> newMapAssertion(String assertionKey, Object assertionValue) {
        return ImmutableMap.of((Object)assertionKey, (Object)assertionValue);
    }

    class TestObject {
        private final String id = Identifiers.makeRandomId((int)8);

        public String getId() {
            return this.id;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }
}

