/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test.framework;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.test.entity.TestApplication;
import org.apache.brooklyn.location.localhost.LocalhostMachineProvisioningLocation;
import org.apache.brooklyn.test.framework.TestHttpCall;
import org.apache.brooklyn.test.framework.TestSensor;
import org.apache.brooklyn.test.http.TestHttpRequestHandler;
import org.apache.brooklyn.test.http.TestHttpServer;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.time.Duration;
import org.apache.http.protocol.HttpRequestHandler;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestHttpCallTest {
    private TestHttpServer server;
    private TestApplication app;
    private ManagementContext managementContext;
    private LocalhostMachineProvisioningLocation loc;
    private String testId;

    @BeforeMethod(alwaysRun=true)
    public void setup() {
        this.testId = Identifiers.makeRandomId((int)8);
        this.server = new TestHttpServer().handler("/201", (HttpRequestHandler)new TestHttpRequestHandler().response("Created - " + this.testId).code(201)).handler("/204", (HttpRequestHandler)new TestHttpRequestHandler().code(204)).handler("/index.html", (HttpRequestHandler)new TestHttpRequestHandler().response("<html><body><h1>Im a H1 tag!</h1></body></html>").code(200)).handler("/body.json", (HttpRequestHandler)new TestHttpRequestHandler().response("{\"a\":\"b\",\"c\":\"d\",\"e\":123,\"g\":false}").code(200 + Identifiers.randomInt((int)99))).start();
        this.app = TestApplication.Factory.newManagedInstanceForTests();
        this.managementContext = this.app.getManagementContext();
        this.loc = (LocalhostMachineProvisioningLocation)this.managementContext.getLocationManager().createLocation((LocationSpec)LocationSpec.create(LocalhostMachineProvisioningLocation.class).configure((CharSequence)"name", (Object)this.testId));
    }

    @Test(groups={"Integration"})
    public void testHttpBodyAssertions() {
        this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(TestHttpCall.class).configure(TestHttpCall.TARGET_URL, (Object)(this.server.getUrl() + "/201"))).configure(TestHttpCall.TIMEOUT, (Object)new Duration(10L, TimeUnit.SECONDS))).configure(TestSensor.ASSERTIONS, this.newAssertion("isEqualTo", "Created - " + this.testId)));
        this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(TestHttpCall.class).configure(TestHttpCall.TARGET_URL, (Object)(this.server.getUrl() + "/204"))).configure(TestHttpCall.TIMEOUT, (Object)new Duration(10L, TimeUnit.SECONDS))).configure(TestSensor.ASSERTIONS, this.newAssertion("isEqualTo", "")));
        this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(TestHttpCall.class).configure(TestHttpCall.TARGET_URL, (Object)(this.server.getUrl() + "/index.html"))).configure(TestHttpCall.TIMEOUT, (Object)new Duration(10L, TimeUnit.SECONDS))).configure(TestSensor.ASSERTIONS, this.newAssertion("contains", "Im a H1 tag!")));
        this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(TestHttpCall.class).configure(TestHttpCall.TARGET_URL, (Object)(this.server.getUrl() + "/body.json"))).configure(TestHttpCall.TIMEOUT, (Object)new Duration(10L, TimeUnit.SECONDS))).configure(TestSensor.ASSERTIONS, this.newAssertion("matches", ".*123.*")));
        this.app.start((Collection)ImmutableList.of((Object)this.loc));
    }

    @Test(groups={"Integration"})
    public void testHttpStatusAssertions() {
        this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(TestHttpCall.class).configure(TestHttpCall.TARGET_URL, (Object)(this.server.getUrl() + "/201"))).configure(TestHttpCall.TIMEOUT, (Object)new Duration(10L, TimeUnit.SECONDS))).configure(TestHttpCall.ASSERTION_TARGET, (Object)TestHttpCall.HttpAssertionTarget.status)).configure(TestSensor.ASSERTIONS, this.newAssertion("notNull", Boolean.TRUE)));
        this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(TestHttpCall.class).configure(TestHttpCall.TARGET_URL, (Object)(this.server.getUrl() + "/204"))).configure(TestHttpCall.TIMEOUT, (Object)new Duration(10L, TimeUnit.SECONDS))).configure(TestHttpCall.ASSERTION_TARGET, (Object)TestHttpCall.HttpAssertionTarget.status)).configure(TestSensor.ASSERTIONS, this.newAssertion("isEqualTo", 204)));
        this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(TestHttpCall.class).configure(TestHttpCall.TARGET_URL, (Object)(this.server.getUrl() + "/body.json"))).configure(TestHttpCall.TIMEOUT, (Object)new Duration(10L, TimeUnit.SECONDS))).configure(TestHttpCall.ASSERTION_TARGET, (Object)TestHttpCall.HttpAssertionTarget.status)).configure(TestSensor.ASSERTIONS, this.newAssertion("matches", "2[0-9][0-9]")));
        this.app.start((Collection)ImmutableList.of((Object)this.loc));
    }

    private List<Map<String, Object>> newAssertion(String assertionKey, Object assertionValue) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        result.add((Map<String, Object>)ImmutableMap.of((Object)assertionKey, (Object)assertionValue));
        return result;
    }
}

