/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test.framework;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.brooklyn.test.Asserts;
import org.apache.brooklyn.test.framework.TestFrameworkAssertions;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestFrameworkAssertionsTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestFrameworkAssertionsTest.class);

    @BeforeMethod
    public void setup() {
    }

    @DataProvider
    public Object[][] positiveTestsDP() {
        return new Object[][]{{"some-sensor-value", Arrays.asList(ImmutableMap.of((Object)"isEqualTo", (Object)"some-sensor-value"))}, {"some-sensor-value", Arrays.asList(ImmutableMap.of((Object)"equalTo", (Object)"some-sensor-value"))}, {"some-sensor-value", Arrays.asList(ImmutableMap.of((Object)"equals", (Object)"some-sensor-value"))}, {"some-regex-value-to-match", Arrays.asList(ImmutableMap.of((Object)"matches", (Object)"some.*match", (Object)"isEqualTo", (Object)"some-regex-value-to-match"))}, {null, Arrays.asList(ImmutableMap.of((Object)"isNull", (Object)Boolean.TRUE))}, {"some-non-null-value", Arrays.asList(ImmutableMap.of((Object)"isNull", (Object)Boolean.FALSE))}, {null, Arrays.asList(ImmutableMap.of((Object)"notNull", (Object)Boolean.FALSE))}, {"some-non-null-value", Arrays.asList(ImmutableMap.of((Object)"notNull", (Object)Boolean.TRUE))}, {"<html><body><h1>Im a H1 tag!</h1></body></html>", Arrays.asList(ImmutableMap.of((Object)"contains", (Object)"Im a H1 tag!"))}, {"{\"a\":\"b\",\"c\":\"d\",\"e\":123,\"g\":false}", Arrays.asList(ImmutableMap.of((Object)"contains", (Object)"false"))}, {"", Arrays.asList(ImmutableMap.of((Object)"isEmpty", (Object)Boolean.TRUE))}, {"some-non-null-value", Arrays.asList(ImmutableMap.of((Object)"isEmpty", (Object)Boolean.FALSE))}, {null, Arrays.asList(ImmutableMap.of((Object)"notEmpty", (Object)Boolean.FALSE))}, {"some-non-null-value", Arrays.asList(ImmutableMap.of((Object)"notEmpty", (Object)Boolean.TRUE))}, {"true", Arrays.asList(ImmutableMap.of((Object)"hasTruthValue", (Object)Boolean.TRUE))}, {"false", Arrays.asList(ImmutableMap.of((Object)"hasTruthValue", (Object)Boolean.FALSE))}, {"some-non-null-value", Arrays.asList(ImmutableMap.of((Object)"hasTruthValue", (Object)Boolean.FALSE))}};
    }

    @Test(dataProvider="positiveTestsDP")
    public void positiveTest(final String data, List<Map<String, Object>> assertions) {
        Supplier<String> supplier = new Supplier<String>(){

            public String get() {
                LOG.info("Supplier invoked for data [{}]", (Object)data);
                return data;
            }
        };
        TestFrameworkAssertions.checkAssertions((Map)ImmutableMap.of((Object)"timeout", (Object)new Duration(2L, TimeUnit.SECONDS)), assertions, (String)data, (Supplier)supplier);
    }

    @DataProvider
    public Object[][] negativeTestsDP() {
        String arbitrary = Identifiers.makeRandomId((int)8);
        return new Object[][]{{"some-sensor-value", "equals", arbitrary, Arrays.asList(ImmutableMap.of((Object)"isEqualTo", (Object)arbitrary))}, {"some-sensor-value", "equals", arbitrary, Arrays.asList(ImmutableMap.of((Object)"equalTo", (Object)arbitrary))}, {"some-sensor-value", "equals", arbitrary, Arrays.asList(ImmutableMap.of((Object)"equals", (Object)arbitrary))}, {"some-regex-value-to-match", "matches", "some.*not-match", Arrays.asList(ImmutableMap.of((Object)"matches", (Object)"some.*not-match", (Object)"isEqualTo", (Object)"oink"))}, {null, "notNull", Boolean.TRUE, Arrays.asList(ImmutableMap.of((Object)"notNull", (Object)Boolean.TRUE))}, {"some-not-null-value", "notNull", Boolean.FALSE, Arrays.asList(ImmutableMap.of((Object)"notNull", (Object)Boolean.FALSE))}, {"some-non-null-value", "isNull", Boolean.TRUE, Arrays.asList(ImmutableMap.of((Object)"isNull", (Object)Boolean.TRUE))}, {null, "isNull", Boolean.FALSE, Arrays.asList(ImmutableMap.of((Object)"isNull", (Object)Boolean.FALSE))}, {null, "notEmpty", Boolean.TRUE, Arrays.asList(ImmutableMap.of((Object)"notEmpty", (Object)Boolean.TRUE))}, {"some-not-null-value", "notEmpty", Boolean.FALSE, Arrays.asList(ImmutableMap.of((Object)"notEmpty", (Object)Boolean.FALSE))}, {"some-non-null-value", "isEmpty", Boolean.TRUE, Arrays.asList(ImmutableMap.of((Object)"isEmpty", (Object)Boolean.TRUE))}, {null, "isEmpty", Boolean.FALSE, Arrays.asList(ImmutableMap.of((Object)"isEmpty", (Object)Boolean.FALSE))}, {"<html><body><h1>Im a H1 tag!</h1></body></html>", "contains", "quack", Arrays.asList(ImmutableMap.of((Object)"contains", (Object)"quack"))}, {"{\"a\":\"b\",\"c\":\"d\",\"e\":123,\"g\":false}", "contains", "moo", Arrays.asList(ImmutableMap.of((Object)"contains", (Object)"moo"))}, {"true", "hasTruthValue", Boolean.FALSE, Arrays.asList(ImmutableMap.of((Object)"hasTruthValue", (Object)Boolean.FALSE))}, {"false", "hasTruthValue", Boolean.TRUE, Arrays.asList(ImmutableMap.of((Object)"hasTruthValue", (Object)Boolean.TRUE))}, {"some-not-null-value", "hasTruthValue", Boolean.TRUE, Arrays.asList(ImmutableMap.of((Object)"hasTruthValue", (Object)Boolean.TRUE))}};
    }

    @Test(dataProvider="negativeTestsDP")
    public void negativeTests(final String data, String condition, Object expected, List<Map<String, Object>> assertions) {
        Supplier<String> supplier = new Supplier<String>(){

            public String get() {
                LOG.info("Supplier invoked for data [{}]", (Object)data);
                return data;
            }
        };
        try {
            TestFrameworkAssertions.checkAssertions((Map)ImmutableMap.of((Object)"timeout", (Object)new Duration(2L, TimeUnit.SECONDS)), assertions, (String)data, (Supplier)supplier);
            Asserts.shouldHaveFailedPreviously();
        }
        catch (AssertionError e) {
            Asserts.expectedFailureContains((Throwable)((Object)e), (String)data, (String[])new String[]{condition, expected.toString()});
        }
    }

    @Test
    public void testUnknownAssertion() {
        final String randomId = Identifiers.makeRandomId((int)8);
        HashMap<String, String> assertions = new HashMap<String, String>();
        assertions.put(randomId, randomId);
        Supplier<String> supplier = new Supplier<String>(){

            public String get() {
                LOG.info("Supplier invoked for data [{}]", (Object)randomId);
                return randomId;
            }
        };
        try {
            TestFrameworkAssertions.checkAssertions((Map)ImmutableMap.of((Object)"timeout", (Object)new Duration(2L, TimeUnit.SECONDS)), assertions, (String)"anyTarget", (Supplier)supplier);
            Asserts.shouldHaveFailedPreviously();
        }
        catch (Throwable e) {
            Asserts.expectedFailureOfType((Throwable)e, (Class[])new Class[]{AssertionError.class});
            Asserts.expectedFailureContains((Throwable)e, (String)"unknown condition", (String[])new String[0]);
        }
    }
}

