/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test.framework;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.test.entity.TestApplication;
import org.apache.brooklyn.location.localhost.LocalhostMachineProvisioningLocation;
import org.apache.brooklyn.test.Asserts;
import org.apache.brooklyn.test.framework.TestCase;
import org.apache.brooklyn.test.framework.TestEffector;
import org.apache.brooklyn.test.framework.entity.TestEntity;
import org.apache.brooklyn.util.text.Identifiers;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestEffectorTest {
    private TestApplication app;
    private ManagementContext managementContext;
    private LocalhostMachineProvisioningLocation loc;
    private String testId;

    @BeforeMethod
    public void setup() {
        this.testId = Identifiers.makeRandomId((int)8);
        this.app = TestApplication.Factory.newManagedInstanceForTests();
        this.managementContext = this.app.getManagementContext();
        this.loc = (LocalhostMachineProvisioningLocation)this.managementContext.getLocationManager().createLocation((LocationSpec)LocationSpec.create(LocalhostMachineProvisioningLocation.class).configure((CharSequence)"name", (Object)this.testId));
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.app != null) {
            Entities.destroyAll((ManagementContext)this.app.getManagementContext());
        }
    }

    @Test
    public void testSimpleEffector() {
        TestCase testCase = (TestCase)this.app.createAndManageChild(EntitySpec.create(TestCase.class));
        TestEntity testEntity = (TestEntity)testCase.addChild(EntitySpec.create(TestEntity.class));
        TestEffector testEffector = (TestEffector)testCase.addChild((EntitySpec)((EntitySpec)EntitySpec.create(TestEffector.class).configure((ConfigKey.HasConfigKey)TestEffector.TARGET_ENTITY, (Object)testEntity)).configure(TestEffector.EFFECTOR_NAME, (Object)"simpleEffector"));
        this.app.start((Collection)ImmutableList.of((Object)this.app.newSimulatedLocation()));
        Assertions.assertThat((Boolean)((Boolean)testEntity.sensors().get(TestEntity.SIMPLE_EFFECTOR_INVOKED))).isNotNull();
        Assertions.assertThat((Boolean)((Boolean)testEntity.sensors().get(TestEntity.SIMPLE_EFFECTOR_INVOKED))).isTrue();
        Assertions.assertThat((Object)testEffector.sensors().get((AttributeSensor)TestEffector.EFFECTOR_RESULT)).isNull();
    }

    @Test
    public void testEffectorPositiveAssertions() {
        TestCase testCase = (TestCase)this.app.createAndManageChild(EntitySpec.create(TestCase.class));
        TestEntity testEntity = (TestEntity)testCase.addChild(EntitySpec.create(TestEntity.class));
        String stringToReturn = "Hello World!";
        ImmutableMap effectorParams = ImmutableMap.of((Object)"stringToReturn", (Object)stringToReturn);
        ImmutableList assertions = ImmutableList.of((Object)ImmutableMap.of((Object)"equalTo", (Object)stringToReturn), (Object)ImmutableMap.of((Object)"contains", (Object)"Hello"));
        TestEffector testEffector = (TestEffector)testCase.addChild((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(TestEffector.class).configure((ConfigKey.HasConfigKey)TestEffector.TARGET_ENTITY, (Object)testEntity)).configure(TestEffector.EFFECTOR_NAME, (Object)"effectorReturnsString")).configure(TestEffector.EFFECTOR_PARAMS, (Object)effectorParams)).configure(TestEffector.ASSERTIONS, (Object)assertions));
        this.app.start((Collection)ImmutableList.of((Object)this.app.newSimulatedLocation()));
        Assertions.assertThat((Object)testEffector.sensors().get((AttributeSensor)TestEffector.EFFECTOR_RESULT)).isEqualTo((Object)stringToReturn);
        Assertions.assertThat((Boolean)((Boolean)testEffector.sensors().get(Startable.SERVICE_UP))).isTrue().withFailMessage("Service should be up", new Object[0]);
    }

    @Test
    public void testEffectorNegativeAssertions() {
        TestCase testCase = (TestCase)this.app.createAndManageChild(EntitySpec.create(TestCase.class));
        TestEntity testEntity = (TestEntity)testCase.addChild(EntitySpec.create(TestEntity.class));
        String stringToReturn = "Goodbye World!";
        ImmutableMap effectorParams = ImmutableMap.of((Object)"stringToReturn", (Object)stringToReturn);
        ImmutableList assertions = ImmutableList.of((Object)ImmutableMap.of((Object)"equalTo", (Object)"Not the string I expected"), (Object)ImmutableMap.of((Object)"contains", (Object)"Hello"));
        TestEffector testEffector = (TestEffector)testCase.addChild((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(TestEffector.class).configure((ConfigKey.HasConfigKey)TestEffector.TARGET_ENTITY, (Object)testEntity)).configure(TestEffector.EFFECTOR_NAME, (Object)"effectorReturnsString")).configure(TestEffector.EFFECTOR_PARAMS, (Object)effectorParams)).configure(TestEffector.ASSERTIONS, (Object)assertions));
        try {
            this.app.start((Collection)ImmutableList.of((Object)this.app.newSimulatedLocation()));
            Asserts.shouldHaveFailedPreviously();
        }
        catch (Throwable throwable) {
            Asserts.expectedFailureOfType((Throwable)throwable, (Class[])new Class[]{AssertionError.class});
        }
        Assertions.assertThat((Boolean)((Boolean)testEffector.sensors().get(Startable.SERVICE_UP))).isFalse().withFailMessage("Service should not be up", new Object[0]);
    }

    @Test
    public void testComplexffector() {
        TestCase testCase = (TestCase)this.app.createAndManageChild(EntitySpec.create(TestCase.class));
        TestEntity testEntity = (TestEntity)testCase.addChild(EntitySpec.create(TestEntity.class));
        long expectedLongValue = System.currentTimeMillis();
        boolean expectedBooleanValue = expectedLongValue % 2L == 0L;
        TestEffector testEffector = (TestEffector)testCase.addChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(TestEffector.class).configure((ConfigKey.HasConfigKey)TestEffector.TARGET_ENTITY, (Object)testEntity)).configure(TestEffector.EFFECTOR_NAME, (Object)"complexEffector")).configure(TestEffector.EFFECTOR_PARAMS, (Object)ImmutableMap.of((Object)"stringValue", (Object)this.testId, (Object)"booleanValue", (Object)expectedBooleanValue, (Object)"longValue", (Object)expectedLongValue)));
        this.app.start((Collection)ImmutableList.of((Object)this.app.newSimulatedLocation()));
        Assertions.assertThat((Boolean)((Boolean)testEntity.sensors().get(TestEntity.SIMPLE_EFFECTOR_INVOKED))).isNull();
        Assertions.assertThat((Boolean)((Boolean)testEntity.sensors().get(TestEntity.COMPLEX_EFFECTOR_INVOKED))).isNotNull();
        Assertions.assertThat((Boolean)((Boolean)testEntity.sensors().get(TestEntity.COMPLEX_EFFECTOR_INVOKED))).isTrue();
        Assertions.assertThat((String)((String)testEntity.sensors().get(TestEntity.COMPLEX_EFFECTOR_STRING))).isNotNull();
        Assertions.assertThat((String)((String)testEntity.sensors().get(TestEntity.COMPLEX_EFFECTOR_STRING))).isEqualTo((Object)this.testId);
        Assertions.assertThat((Boolean)((Boolean)testEntity.sensors().get(TestEntity.COMPLEX_EFFECTOR_BOOLEAN))).isNotNull();
        Assertions.assertThat((Boolean)((Boolean)testEntity.sensors().get(TestEntity.COMPLEX_EFFECTOR_BOOLEAN))).isEqualTo(expectedBooleanValue);
        Assertions.assertThat((Long)((Long)testEntity.sensors().get(TestEntity.COMPLEX_EFFECTOR_LONG))).isNotNull();
        Assertions.assertThat((Long)((Long)testEntity.sensors().get(TestEntity.COMPLEX_EFFECTOR_LONG))).isEqualTo(expectedLongValue);
        Assertions.assertThat((Object)testEffector.sensors().get((AttributeSensor)TestEffector.EFFECTOR_RESULT)).isNotNull();
        Assertions.assertThat((Object)testEffector.sensors().get((AttributeSensor)TestEffector.EFFECTOR_RESULT)).isInstanceOf(TestEntity.TestPojo.class);
        TestEntity.TestPojo effectorResult = (TestEntity.TestPojo)testEffector.sensors().get((AttributeSensor)TestEffector.EFFECTOR_RESULT);
        Assertions.assertThat((Boolean)effectorResult.getBooleanValue()).isEqualTo(expectedBooleanValue);
        Assertions.assertThat((String)effectorResult.getStringValue()).isEqualTo((Object)this.testId);
        Assertions.assertThat((Long)effectorResult.getLongValue()).isEqualTo(expectedLongValue);
    }
}

