/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test.framework;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.test.BrooklynAppUnitTestSupport;
import org.apache.brooklyn.core.test.entity.TestApplication;
import org.apache.brooklyn.core.test.entity.TestEntity;
import org.apache.brooklyn.test.Asserts;
import org.apache.brooklyn.test.framework.SimpleShellCommandTest;
import org.apache.brooklyn.test.framework.TargetableTestComponent;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Identifiers;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class SimpleShellCommandIntegrationTest
extends BrooklynAppUnitTestSupport {
    private static final String UP = "up";

    @DataProvider(name="shouldInsistOnJustOneOfCommandAndScript")
    public Object[][] createData1() {
        return new Object[][]{{"pwd", "pwd.sh", Boolean.FALSE}, {null, null, Boolean.FALSE}, {"pwd", null, Boolean.TRUE}, {null, "pwd.sh", Boolean.TRUE}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"Integration"}, dataProvider="shouldInsistOnJustOneOfCommandAndScript")
    public void shouldInsistOnJustOneOfCommandAndScript(String command, String script, boolean valid) throws Exception {
        Path scriptPath = null;
        String scriptUrl = null;
        if (null != script) {
            scriptPath = this.createTempScript("pwd", "pwd");
            scriptUrl = "file:" + scriptPath;
        }
        TestEntity testEntity = (TestEntity)this.app.createAndManageChild(EntitySpec.create(TestEntity.class).location(TestApplication.LOCALHOST_MACHINE_SPEC));
        this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(SimpleShellCommandTest.class).configure((ConfigKey.HasConfigKey)TargetableTestComponent.TARGET_ENTITY, (Object)testEntity)).configure(SimpleShellCommandTest.COMMAND, (Object)command)).configure((ConfigKey.HasConfigKey)SimpleShellCommandTest.DOWNLOAD_URL, (Object)scriptUrl));
        try {
            this.app.start((Collection)ImmutableList.of());
            if (!valid) {
                Asserts.shouldHaveFailedPreviously();
            }
        }
        catch (Exception e) {
            Asserts.expectedFailureContains((Throwable)e, (String)"Must specify exactly one of download.url and command", (String[])new String[0]);
        }
        finally {
            if (null != scriptPath) {
                Files.delete(scriptPath);
            }
        }
    }

    private List<Map<String, Object>> makeAssertions(Map<String, Object> ... maps) {
        ArrayList<Map<String, Object>> assertions = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : maps) {
            assertions.add(map);
        }
        return assertions;
    }

    @Test(groups={"Integration"})
    public void shouldSucceedUsingSuccessfulExitAsDefaultCondition() {
        TestEntity testEntity = (TestEntity)this.app.createAndManageChild(EntitySpec.create(TestEntity.class).location(TestApplication.LOCALHOST_MACHINE_SPEC));
        SimpleShellCommandTest uptime = (SimpleShellCommandTest)this.app.createAndManageChild((EntitySpec)((EntitySpec)EntitySpec.create(SimpleShellCommandTest.class).configure((ConfigKey.HasConfigKey)TargetableTestComponent.TARGET_ENTITY, (Object)testEntity)).configure(SimpleShellCommandTest.COMMAND, (Object)"uptime"));
        this.app.start((Collection)ImmutableList.of());
        Assertions.assertThat((Boolean)((Boolean)uptime.sensors().get(Startable.SERVICE_UP))).isTrue().withFailMessage("Service should be up", new Object[0]);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)ServiceStateLogic.getExpectedState((Entity)uptime)).isEqualTo((Object)Lifecycle.RUNNING)).withFailMessage("Service should be marked running", new Object[0]);
    }

    @Test(groups={"Integration"})
    public void shouldFailUsingSuccessfulExitAsDefaultCondition() {
        TestEntity testEntity = (TestEntity)this.app.createAndManageChild(EntitySpec.create(TestEntity.class).location(TestApplication.LOCALHOST_MACHINE_SPEC));
        SimpleShellCommandTest uptime = (SimpleShellCommandTest)this.app.createAndManageChild((EntitySpec)((EntitySpec)EntitySpec.create(SimpleShellCommandTest.class).configure((ConfigKey.HasConfigKey)TargetableTestComponent.TARGET_ENTITY, (Object)testEntity)).configure(SimpleShellCommandTest.COMMAND, (Object)("ls /tmp/bogus-" + Identifiers.randomLong())));
        try {
            this.app.start((Collection)ImmutableList.of());
        }
        catch (Throwable t) {
            Asserts.expectedFailureContains((Throwable)t, (String)"exit code equals 0", (String[])new String[0]);
        }
        Assertions.assertThat((Boolean)((Boolean)uptime.sensors().get(Startable.SERVICE_UP))).isFalse().withFailMessage("Service should be down", new Object[0]);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)ServiceStateLogic.getExpectedState((Entity)uptime)).isEqualTo((Object)Lifecycle.ON_FIRE)).withFailMessage("Service should be marked on fire", new Object[0]);
    }

    @Test(groups={"Integration"})
    public void shouldInvokeCommand() {
        TestEntity testEntity = (TestEntity)this.app.createAndManageChild(EntitySpec.create(TestEntity.class).location(TestApplication.LOCALHOST_MACHINE_SPEC));
        MutableMap equalsZero = MutableMap.of();
        equalsZero.put("equals", 0);
        MutableMap containsUp = MutableMap.of();
        containsUp.put("contains", UP);
        SimpleShellCommandTest uptime = (SimpleShellCommandTest)this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(SimpleShellCommandTest.class).configure((ConfigKey.HasConfigKey)TargetableTestComponent.TARGET_ENTITY, (Object)testEntity)).configure(SimpleShellCommandTest.COMMAND, (Object)"uptime")).configure(SimpleShellCommandTest.ASSERT_STATUS, this.makeAssertions(new Map[]{equalsZero}))).configure(SimpleShellCommandTest.ASSERT_OUT, this.makeAssertions(new Map[]{containsUp})));
        this.app.start((Collection)ImmutableList.of());
        Assertions.assertThat((Boolean)((Boolean)uptime.sensors().get(Startable.SERVICE_UP))).isTrue().withFailMessage("Service should be up", new Object[0]);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)ServiceStateLogic.getExpectedState((Entity)uptime)).isEqualTo((Object)Lifecycle.RUNNING)).withFailMessage("Service should be marked running", new Object[0]);
    }

    @Test(groups={"Integration"})
    public void shouldNotBeUpIfAssertionsFail() {
        TestEntity testEntity = (TestEntity)this.app.createAndManageChild(EntitySpec.create(TestEntity.class).location(TestApplication.LOCALHOST_MACHINE_SPEC));
        MutableMap equalsOne = MutableMap.of();
        equalsOne.put("equals", 1);
        MutableMap equals255 = MutableMap.of();
        equals255.put("equals", 255);
        SimpleShellCommandTest uptime = (SimpleShellCommandTest)this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(SimpleShellCommandTest.class).configure((ConfigKey.HasConfigKey)TargetableTestComponent.TARGET_ENTITY, (Object)testEntity)).configure(SimpleShellCommandTest.COMMAND, (Object)"uptime")).configure(SimpleShellCommandTest.ASSERT_STATUS, this.makeAssertions(new Map[]{equalsOne, equals255})));
        try {
            this.app.start((Collection)ImmutableList.of());
        }
        catch (Exception e) {
            Asserts.expectedFailureContains((Throwable)e, (String)"exit code equals 1", (String[])new String[]{"exit code equals 255"});
        }
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)ServiceStateLogic.getExpectedState((Entity)uptime)).isEqualTo((Object)Lifecycle.ON_FIRE)).withFailMessage("Service should be marked on fire", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"Integration"})
    public void shouldInvokeScript() throws Exception {
        TestEntity testEntity = (TestEntity)this.app.createAndManageChild(EntitySpec.create(TestEntity.class).location(TestApplication.LOCALHOST_MACHINE_SPEC));
        String text = "hello world";
        Path testScript = this.createTempScript("script", "echo " + text);
        try {
            MutableMap equalsZero = MutableMap.of();
            equalsZero.put("equals", 0);
            MutableMap containsText = MutableMap.of();
            containsText.put("contains", text);
            SimpleShellCommandTest uptime = (SimpleShellCommandTest)this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(SimpleShellCommandTest.class).configure((ConfigKey.HasConfigKey)TargetableTestComponent.TARGET_ENTITY, (Object)testEntity)).configure((ConfigKey.HasConfigKey)SimpleShellCommandTest.DOWNLOAD_URL, (Object)("file:" + testScript))).configure(SimpleShellCommandTest.ASSERT_STATUS, this.makeAssertions(new Map[]{equalsZero}))).configure(SimpleShellCommandTest.ASSERT_OUT, this.makeAssertions(new Map[]{containsText})));
            this.app.start((Collection)ImmutableList.of());
            Assertions.assertThat((Boolean)((Boolean)uptime.sensors().get(Startable.SERVICE_UP))).isTrue().withFailMessage("Service should be up", new Object[0]);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)ServiceStateLogic.getExpectedState((Entity)uptime)).isEqualTo((Object)Lifecycle.RUNNING)).withFailMessage("Service should be marked running", new Object[0]);
        }
        finally {
            Files.delete(testScript);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"Integration"})
    public void shouldExecuteInTheRunDir() throws Exception {
        TestEntity testEntity = (TestEntity)this.app.createAndManageChild(EntitySpec.create(TestEntity.class).location(TestApplication.LOCALHOST_MACHINE_SPEC));
        Path pwdPath = this.createTempScript("pwd", "pwd");
        try {
            MutableMap equalsZero = MutableMap.of();
            equalsZero.put("equals", 0);
            MutableMap containsTmp = MutableMap.of();
            containsTmp.put("contains", "/tmp");
            SimpleShellCommandTest pwd = (SimpleShellCommandTest)this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(SimpleShellCommandTest.class).configure((ConfigKey.HasConfigKey)TargetableTestComponent.TARGET_ENTITY, (Object)testEntity)).configure((ConfigKey.HasConfigKey)SimpleShellCommandTest.DOWNLOAD_URL, (Object)("file:" + pwdPath))).configure(SimpleShellCommandTest.RUN_DIR, (Object)"/tmp")).configure(SimpleShellCommandTest.ASSERT_STATUS, this.makeAssertions(new Map[]{equalsZero}))).configure(SimpleShellCommandTest.ASSERT_OUT, this.makeAssertions(new Map[]{containsTmp})));
            SimpleShellCommandTest alsoPwd = (SimpleShellCommandTest)this.app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(SimpleShellCommandTest.class).configure((ConfigKey.HasConfigKey)TargetableTestComponent.TARGET_ENTITY, (Object)testEntity)).configure(SimpleShellCommandTest.COMMAND, (Object)"pwd")).configure(SimpleShellCommandTest.RUN_DIR, (Object)"/tmp")).configure(SimpleShellCommandTest.ASSERT_STATUS, this.makeAssertions(new Map[]{equalsZero}))).configure(SimpleShellCommandTest.ASSERT_OUT, this.makeAssertions(new Map[]{containsTmp})));
            this.app.start((Collection)ImmutableList.of());
            Assertions.assertThat((Boolean)((Boolean)pwd.sensors().get(Startable.SERVICE_UP))).isTrue().withFailMessage("Service should be up", new Object[0]);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)ServiceStateLogic.getExpectedState((Entity)pwd)).isEqualTo((Object)Lifecycle.RUNNING)).withFailMessage("Service should be marked running", new Object[0]);
            Assertions.assertThat((Boolean)((Boolean)alsoPwd.sensors().get(Startable.SERVICE_UP))).isTrue().withFailMessage("Service should be up", new Object[0]);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)ServiceStateLogic.getExpectedState((Entity)alsoPwd)).isEqualTo((Object)Lifecycle.RUNNING)).withFailMessage("Service should be marked running", new Object[0]);
        }
        finally {
            Files.delete(pwdPath);
        }
    }

    private Path createTempScript(String filename, String contents) {
        try {
            Path tempFile = Files.createTempFile("SimpleShellCommandIntegrationTest-" + filename, ".sh", new FileAttribute[0]);
            Files.write(tempFile, contents.getBytes(), new OpenOption[0]);
            return tempFile;
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }
}

