/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test.framework;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.test.entity.TestApplication;
import org.apache.brooklyn.entity.group.DynamicGroup;
import org.apache.brooklyn.entity.software.base.EmptySoftwareProcess;
import org.apache.brooklyn.location.localhost.LocalhostMachineProvisioningLocation;
import org.apache.brooklyn.test.Asserts;
import org.apache.brooklyn.test.framework.LoopOverGroupMembersTestCase;
import org.apache.brooklyn.test.framework.TestSensor;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.text.Identifiers;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class LoopOverGroupMembersTestCaseTest {
    private TestApplication app;
    private Group testGroup;
    private ManagementContext managementContext;
    private LocalhostMachineProvisioningLocation loc;
    private String testId;
    private final String SENSOR_VAL = "Hello World!";
    private static final AttributeSensorAndConfigKey<String, String> STRING_SENSOR = ConfigKeys.newSensorAndConfigKey(String.class, (String)"string-sensor", (String)"String Sensor");

    @BeforeMethod
    public void setup() {
        this.testId = Identifiers.makeRandomId((int)8);
        this.app = TestApplication.Factory.newManagedInstanceForTests();
        this.managementContext = this.app.getManagementContext();
        this.loc = (LocalhostMachineProvisioningLocation)this.managementContext.getLocationManager().createLocation((LocationSpec)LocationSpec.create(LocalhostMachineProvisioningLocation.class).configure((CharSequence)"name", (Object)this.testId));
        this.testGroup = (Group)this.app.createAndManageChild(EntitySpec.create(DynamicGroup.class));
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.app != null) {
            Entities.destroyAll((ManagementContext)this.app.getManagementContext());
        }
    }

    @Test
    public void testOneChildWhichPasses() {
        EmptySoftwareProcess emptySoftwareProcess = this.addEmptySoftwareProcessToGroup();
        EntitySpec<TestSensor> testSpec = this.createPassingTestSensorSpec();
        LoopOverGroupMembersTestCase loopOverGroupMembersTestCase = (LoopOverGroupMembersTestCase)this.app.createAndManageChild(EntitySpec.create(LoopOverGroupMembersTestCase.class));
        loopOverGroupMembersTestCase.config().set(LoopOverGroupMembersTestCase.TEST_SPEC, testSpec);
        loopOverGroupMembersTestCase.config().set((ConfigKey.HasConfigKey)LoopOverGroupMembersTestCase.TARGET_ENTITY, (Object)this.testGroup);
        this.app.start((Collection)ImmutableList.of((Object)this.app.newSimulatedLocation()));
        Assertions.assertThat((int)loopOverGroupMembersTestCase.getChildren().size()).isEqualTo(1);
        Assertions.assertThat((Boolean)((Boolean)loopOverGroupMembersTestCase.sensors().get(Startable.SERVICE_UP))).isTrue();
        Entity loopChildEntity = (Entity)loopOverGroupMembersTestCase.getChildren().iterator().next();
        Assertions.assertThat((Object)loopChildEntity).isInstanceOf(TestSensor.class);
        Assertions.assertThat((Boolean)((Boolean)loopChildEntity.sensors().get(Startable.SERVICE_UP))).isTrue();
        Assertions.assertThat((Object)loopChildEntity.config().get((ConfigKey.HasConfigKey)LoopOverGroupMembersTestCase.TARGET_ENTITY)).isEqualTo((Object)emptySoftwareProcess);
    }

    @Test
    public void testMultipleChildrenWhichPass() {
        Set<EmptySoftwareProcess> emptySoftwareProcesses = this.addMultipleEmptySoftwareProcessesToGroup(4);
        EntitySpec<TestSensor> testSpec = this.createPassingTestSensorSpec();
        LoopOverGroupMembersTestCase loopOverGroupMembersTestCase = (LoopOverGroupMembersTestCase)this.app.createAndManageChild(EntitySpec.create(LoopOverGroupMembersTestCase.class));
        loopOverGroupMembersTestCase.config().set(LoopOverGroupMembersTestCase.TEST_SPEC, testSpec);
        loopOverGroupMembersTestCase.config().set((ConfigKey.HasConfigKey)LoopOverGroupMembersTestCase.TARGET_ENTITY, (Object)this.testGroup);
        this.app.start((Collection)ImmutableList.of((Object)this.app.newSimulatedLocation()));
        Assertions.assertThat((int)loopOverGroupMembersTestCase.getChildren().size()).isEqualTo(4);
        Assertions.assertThat((Boolean)((Boolean)loopOverGroupMembersTestCase.sensors().get(Startable.SERVICE_UP))).isTrue();
        for (Entity loopChildEntity : loopOverGroupMembersTestCase.getChildren()) {
            Assertions.assertThat((Object)loopChildEntity).isInstanceOf(TestSensor.class);
            Assertions.assertThat((Boolean)((Boolean)loopChildEntity.sensors().get(Startable.SERVICE_UP))).isTrue();
            Assertions.assertThat((boolean)emptySoftwareProcesses.contains(loopChildEntity.config().get((ConfigKey.HasConfigKey)LoopOverGroupMembersTestCase.TARGET_ENTITY))).isTrue();
            emptySoftwareProcesses.remove(loopChildEntity.config().get((ConfigKey.HasConfigKey)LoopOverGroupMembersTestCase.TARGET_ENTITY));
        }
    }

    @Test
    public void testMultipleChildrenWhichAllFail() {
        Set<EmptySoftwareProcess> emptySoftwareProcesses = this.addMultipleEmptySoftwareProcessesToGroup(4);
        EntitySpec<TestSensor> testSpec = this.createFailingTestSensorSpec();
        LoopOverGroupMembersTestCase loopOverGroupMembersTestCase = (LoopOverGroupMembersTestCase)this.app.createAndManageChild(EntitySpec.create(LoopOverGroupMembersTestCase.class));
        loopOverGroupMembersTestCase.config().set(LoopOverGroupMembersTestCase.TEST_SPEC, testSpec);
        loopOverGroupMembersTestCase.config().set((ConfigKey.HasConfigKey)LoopOverGroupMembersTestCase.TARGET_ENTITY, (Object)this.testGroup);
        this.app.start((Collection)ImmutableList.of((Object)this.app.newSimulatedLocation()));
        Assertions.assertThat((int)loopOverGroupMembersTestCase.getChildren().size()).isEqualTo(4);
        Assertions.assertThat((Boolean)((Boolean)loopOverGroupMembersTestCase.sensors().get(Startable.SERVICE_UP))).isFalse();
        for (Entity loopChildEntity : loopOverGroupMembersTestCase.getChildren()) {
            Assertions.assertThat((Object)loopChildEntity).isInstanceOf(TestSensor.class);
            Assertions.assertThat((Boolean)((Boolean)loopChildEntity.sensors().get(Startable.SERVICE_UP))).isFalse();
            Assertions.assertThat((boolean)emptySoftwareProcesses.contains(loopChildEntity.config().get((ConfigKey.HasConfigKey)LoopOverGroupMembersTestCase.TARGET_ENTITY))).isTrue();
            emptySoftwareProcesses.remove(loopChildEntity.config().get((ConfigKey.HasConfigKey)LoopOverGroupMembersTestCase.TARGET_ENTITY));
        }
    }

    @Test
    public void testMultipleChildrenOneOfWhichFails() {
        Set<EmptySoftwareProcess> emptySoftwareProcesses = this.addMultipleEmptySoftwareProcessesToGroup(3);
        EntitySpec<TestSensor> testSpec = this.createPassingTestSensorSpec();
        EmptySoftwareProcess failingProcess = (EmptySoftwareProcess)this.testGroup.addMemberChild(EntitySpec.create(EmptySoftwareProcess.class));
        failingProcess.sensors().set(STRING_SENSOR, (Object)"THIS STRING WILL CAUSE SENSOR TEST TO FAIL");
        LoopOverGroupMembersTestCase loopOverGroupMembersTestCase = (LoopOverGroupMembersTestCase)this.app.createAndManageChild(EntitySpec.create(LoopOverGroupMembersTestCase.class));
        loopOverGroupMembersTestCase.config().set(LoopOverGroupMembersTestCase.TEST_SPEC, testSpec);
        loopOverGroupMembersTestCase.config().set((ConfigKey.HasConfigKey)LoopOverGroupMembersTestCase.TARGET_ENTITY, (Object)this.testGroup);
        this.app.start((Collection)ImmutableList.of((Object)this.app.newSimulatedLocation()));
        Assertions.assertThat((int)loopOverGroupMembersTestCase.getChildren().size()).isEqualTo(4);
        Assertions.assertThat((Boolean)((Boolean)loopOverGroupMembersTestCase.sensors().get(Startable.SERVICE_UP))).isFalse();
        for (Entity loopChildEntity : loopOverGroupMembersTestCase.getChildren()) {
            Assertions.assertThat((Object)loopChildEntity).isInstanceOf(TestSensor.class);
            Entity targetedEntity = (Entity)loopChildEntity.config().get((ConfigKey.HasConfigKey)LoopOverGroupMembersTestCase.TARGET_ENTITY);
            if (targetedEntity.equals(failingProcess)) {
                Assertions.assertThat((Boolean)((Boolean)loopChildEntity.sensors().get(Startable.SERVICE_UP))).isFalse();
                continue;
            }
            if (emptySoftwareProcesses.contains(targetedEntity)) {
                Assertions.assertThat((Boolean)((Boolean)loopChildEntity.sensors().get(Startable.SERVICE_UP))).isTrue();
                emptySoftwareProcesses.remove(targetedEntity);
                continue;
            }
            Asserts.fail((String)"Targeted entity not recognized");
        }
    }

    @Test
    public void testOneChildWhichFails() {
        EmptySoftwareProcess emptySoftwareProcess = this.addEmptySoftwareProcessToGroup();
        EntitySpec<TestSensor> testSpec = this.createFailingTestSensorSpec();
        LoopOverGroupMembersTestCase loopOverGroupMembersTestCase = (LoopOverGroupMembersTestCase)this.app.createAndManageChild(EntitySpec.create(LoopOverGroupMembersTestCase.class));
        loopOverGroupMembersTestCase.config().set(LoopOverGroupMembersTestCase.TEST_SPEC, testSpec);
        loopOverGroupMembersTestCase.config().set((ConfigKey.HasConfigKey)LoopOverGroupMembersTestCase.TARGET_ENTITY, (Object)this.testGroup);
        this.app.start((Collection)ImmutableList.of((Object)this.app.newSimulatedLocation()));
        Assertions.assertThat((int)loopOverGroupMembersTestCase.getChildren().size()).isEqualTo(1);
        Assertions.assertThat((Boolean)((Boolean)loopOverGroupMembersTestCase.sensors().get(Startable.SERVICE_UP))).isFalse();
        Entity loopChildEntity = (Entity)loopOverGroupMembersTestCase.getChildren().iterator().next();
        Assertions.assertThat((Object)loopChildEntity).isInstanceOf(TestSensor.class);
        Assertions.assertThat((Boolean)((Boolean)loopChildEntity.sensors().get(Startable.SERVICE_UP))).isFalse();
        Assertions.assertThat((Object)loopChildEntity.config().get((ConfigKey.HasConfigKey)LoopOverGroupMembersTestCase.TARGET_ENTITY)).isEqualTo((Object)emptySoftwareProcess);
    }

    @Test
    public void testNoTarget() {
        EmptySoftwareProcess emptySoftwareProcess = this.addEmptySoftwareProcessToGroup();
        EntitySpec<TestSensor> testSpec = this.createFailingTestSensorSpec();
        LoopOverGroupMembersTestCase loopOverGroupMembersTestCase = (LoopOverGroupMembersTestCase)this.app.createAndManageChild(EntitySpec.create(LoopOverGroupMembersTestCase.class));
        loopOverGroupMembersTestCase.config().set(LoopOverGroupMembersTestCase.TEST_SPEC, testSpec);
        this.app.start((Collection)ImmutableList.of((Object)this.app.newSimulatedLocation()));
        Assertions.assertThat((int)loopOverGroupMembersTestCase.getChildren().size()).isEqualTo(0);
        Assertions.assertThat((Boolean)((Boolean)loopOverGroupMembersTestCase.sensors().get(Startable.SERVICE_UP))).isFalse();
    }

    @Test
    public void testNotTargetingGroup() {
        EmptySoftwareProcess emptySoftwareProcess = this.addEmptySoftwareProcessToGroup();
        EntitySpec<TestSensor> testSpec = this.createFailingTestSensorSpec();
        LoopOverGroupMembersTestCase loopOverGroupMembersTestCase = (LoopOverGroupMembersTestCase)this.app.createAndManageChild(EntitySpec.create(LoopOverGroupMembersTestCase.class));
        loopOverGroupMembersTestCase.config().set(LoopOverGroupMembersTestCase.TEST_SPEC, testSpec);
        loopOverGroupMembersTestCase.config().set((ConfigKey.HasConfigKey)LoopOverGroupMembersTestCase.TARGET_ENTITY, (Object)this.app);
        this.app.start((Collection)ImmutableList.of((Object)this.app.newSimulatedLocation()));
        Assertions.assertThat((int)loopOverGroupMembersTestCase.getChildren().size()).isEqualTo(0);
        Assertions.assertThat((Boolean)((Boolean)loopOverGroupMembersTestCase.sensors().get(Startable.SERVICE_UP))).isFalse();
    }

    @Test
    public void testNoSpec() {
        EmptySoftwareProcess emptySoftwareProcess = this.addEmptySoftwareProcessToGroup();
        EntitySpec<TestSensor> testSpec = this.createFailingTestSensorSpec();
        LoopOverGroupMembersTestCase loopOverGroupMembersTestCase = (LoopOverGroupMembersTestCase)this.app.createAndManageChild(EntitySpec.create(LoopOverGroupMembersTestCase.class));
        loopOverGroupMembersTestCase.config().set((ConfigKey.HasConfigKey)LoopOverGroupMembersTestCase.TARGET_ENTITY, (Object)this.testGroup);
        this.app.start((Collection)ImmutableList.of((Object)this.app.newSimulatedLocation()));
        Assertions.assertThat((int)loopOverGroupMembersTestCase.getChildren().size()).isEqualTo(0);
        Assertions.assertThat((Boolean)((Boolean)loopOverGroupMembersTestCase.sensors().get(Startable.SERVICE_UP))).isFalse();
    }

    private EntitySpec<TestSensor> createFailingTestSensorSpec() {
        ImmutableList assertions = ImmutableList.of((Object)ImmutableMap.of((Object)"equalTo", (Object)"THIS IS THE WRONG STRING"));
        return (EntitySpec)((EntitySpec)EntitySpec.create(TestSensor.class).configure(TestSensor.SENSOR_NAME, (Object)STRING_SENSOR.getName())).configure(TestSensor.ASSERTIONS, (Object)assertions);
    }

    private EntitySpec<TestSensor> createPassingTestSensorSpec() {
        ImmutableList assertions = ImmutableList.of((Object)ImmutableMap.of((Object)"equalTo", (Object)"Hello World!"));
        return (EntitySpec)((EntitySpec)EntitySpec.create(TestSensor.class).configure(TestSensor.SENSOR_NAME, (Object)STRING_SENSOR.getName())).configure(TestSensor.ASSERTIONS, (Object)assertions);
    }

    private Set<EmptySoftwareProcess> addMultipleEmptySoftwareProcessesToGroup(int number) {
        MutableSet softwareProcesses = MutableSet.of();
        for (int i = 0; i < number; ++i) {
            softwareProcesses.add((Object)this.addEmptySoftwareProcessToGroup());
        }
        return softwareProcesses;
    }

    private EmptySoftwareProcess addEmptySoftwareProcessToGroup() {
        EmptySoftwareProcess emptySoftwareProcess = (EmptySoftwareProcess)this.testGroup.addMemberChild(EntitySpec.create(EmptySoftwareProcess.class));
        emptySoftwareProcess.sensors().set(STRING_SENSOR, (Object)"Hello World!");
        return emptySoftwareProcess;
    }
}

