/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test.framework;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.StartableApplication;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.test.entity.TestApplication;
import org.apache.brooklyn.entity.stock.BasicApplication;
import org.apache.brooklyn.location.localhost.LocalhostMachineProvisioningLocation;
import org.apache.brooklyn.test.Asserts;
import org.apache.brooklyn.test.framework.InfrastructureDeploymentTestCase;
import org.apache.brooklyn.test.framework.entity.TestInfrastructure;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class InfrastructureDeploymentTestCaseTest {
    private TestApplication app;
    private ManagementContext managementContext;
    private LocalhostMachineProvisioningLocation loc;
    private LocalhostMachineProvisioningLocation infrastructureLoc;
    private String LOC_NAME = "location";
    private String INFRASTRUCTURE_LOC_NAME = "Infrastructure location";
    private static final AttributeSensorAndConfigKey<Location, Location> DEPLOYMENT_LOCATION_SENSOR = ConfigKeys.newSensorAndConfigKey((TypeToken)new TypeToken<Location>(){}, (String)"deploymentLocationSensor", (String)"The location to deploy to");

    @BeforeMethod
    public void setup() {
        this.app = TestApplication.Factory.newManagedInstanceForTests();
        this.managementContext = this.app.getManagementContext();
        this.loc = (LocalhostMachineProvisioningLocation)this.managementContext.getLocationManager().createLocation((LocationSpec)LocationSpec.create(LocalhostMachineProvisioningLocation.class).configure((CharSequence)"name", (Object)this.LOC_NAME));
        this.infrastructureLoc = (LocalhostMachineProvisioningLocation)this.managementContext.getLocationManager().createLocation((LocationSpec)LocationSpec.create(LocalhostMachineProvisioningLocation.class).configure((CharSequence)"name", (Object)this.INFRASTRUCTURE_LOC_NAME));
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.app != null) {
            Entities.destroyAll((ManagementContext)this.app.getManagementContext());
        }
    }

    @Test
    public void testVanilla() {
        EntitySpec infrastructureSpec = EntitySpec.create(TestInfrastructure.class);
        infrastructureSpec.configure(DEPLOYMENT_LOCATION_SENSOR, (Object)this.infrastructureLoc);
        ImmutableList testSpecs = ImmutableList.of((Object)EntitySpec.create(BasicApplication.class));
        InfrastructureDeploymentTestCase infrastructureDeploymentTestCase = (InfrastructureDeploymentTestCase)this.app.createAndManageChild(EntitySpec.create(InfrastructureDeploymentTestCase.class));
        infrastructureDeploymentTestCase.config().set(InfrastructureDeploymentTestCase.INFRASTRUCTURE_SPEC, (Object)infrastructureSpec);
        infrastructureDeploymentTestCase.config().set(InfrastructureDeploymentTestCase.ENTITY_SPEC_TO_DEPLOY, (Object)testSpecs);
        infrastructureDeploymentTestCase.config().set(InfrastructureDeploymentTestCase.DEPLOYMENT_LOCATION_SENSOR_NAME, (Object)DEPLOYMENT_LOCATION_SENSOR.getName());
        this.app.start((Collection)ImmutableList.of((Object)this.loc));
        Assertions.assertThat((Boolean)((Boolean)infrastructureDeploymentTestCase.sensors().get(Startable.SERVICE_UP))).isTrue();
        Assertions.assertThat((int)infrastructureDeploymentTestCase.getChildren().size()).isEqualTo(2);
        boolean seenInfrastructure = false;
        boolean seenEntity = false;
        for (Entity entity : infrastructureDeploymentTestCase.getChildren()) {
            Assertions.assertThat((int)entity.getLocations().size()).isEqualTo(1);
            Assertions.assertThat((Boolean)((Boolean)entity.sensors().get(Startable.SERVICE_UP))).isTrue();
            if (entity instanceof TestInfrastructure && !seenInfrastructure) {
                Assertions.assertThat((String)((Location)entity.getLocations().iterator().next()).getDisplayName()).isEqualTo((Object)this.LOC_NAME);
                seenInfrastructure = true;
                continue;
            }
            if (entity instanceof BasicApplication) {
                Assertions.assertThat((String)((Location)entity.getLocations().iterator().next()).getDisplayName()).isEqualTo((Object)this.INFRASTRUCTURE_LOC_NAME);
                seenEntity = true;
                continue;
            }
            Asserts.fail((String)"Unknown child of InfrastructureDeploymentTestCase");
        }
        Assertions.assertThat((boolean)seenInfrastructure).isTrue();
        Assertions.assertThat((boolean)seenEntity).isTrue();
    }

    @Test
    public void testMultipleSpec() {
        EntitySpec infrastructureSpec = EntitySpec.create(TestInfrastructure.class);
        infrastructureSpec.configure(DEPLOYMENT_LOCATION_SENSOR, (Object)this.infrastructureLoc);
        ImmutableList testSpecs = ImmutableList.of((Object)EntitySpec.create(BasicApplication.class), (Object)EntitySpec.create(BasicApplication.class));
        InfrastructureDeploymentTestCase infrastructureDeploymentTestCase = (InfrastructureDeploymentTestCase)this.app.createAndManageChild(EntitySpec.create(InfrastructureDeploymentTestCase.class));
        infrastructureDeploymentTestCase.config().set(InfrastructureDeploymentTestCase.INFRASTRUCTURE_SPEC, (Object)infrastructureSpec);
        infrastructureDeploymentTestCase.config().set(InfrastructureDeploymentTestCase.ENTITY_SPEC_TO_DEPLOY, (Object)testSpecs);
        infrastructureDeploymentTestCase.config().set(InfrastructureDeploymentTestCase.DEPLOYMENT_LOCATION_SENSOR_NAME, (Object)DEPLOYMENT_LOCATION_SENSOR.getName());
        this.app.start((Collection)ImmutableList.of((Object)this.loc));
        Assertions.assertThat((Boolean)((Boolean)infrastructureDeploymentTestCase.sensors().get(Startable.SERVICE_UP))).isTrue();
        Assertions.assertThat((int)infrastructureDeploymentTestCase.getChildren().size()).isEqualTo(3);
        boolean seenInfrastructure = false;
        int entitiesSeen = 0;
        for (Entity entity : infrastructureDeploymentTestCase.getChildren()) {
            Assertions.assertThat((Boolean)((Boolean)entity.sensors().get(Startable.SERVICE_UP))).isTrue();
            Assertions.assertThat((int)entity.getLocations().size()).isEqualTo(1);
            if (entity instanceof TestInfrastructure && !seenInfrastructure) {
                Assertions.assertThat((String)((Location)entity.getLocations().iterator().next()).getDisplayName()).isEqualTo((Object)this.LOC_NAME);
                seenInfrastructure = true;
                continue;
            }
            if (entity instanceof BasicApplication) {
                Assertions.assertThat((String)((Location)entity.getLocations().iterator().next()).getDisplayName()).isEqualTo((Object)this.INFRASTRUCTURE_LOC_NAME);
                ++entitiesSeen;
                continue;
            }
            Asserts.fail((String)"Unknown child of InfrastructureDeploymentTestCase");
        }
        Assertions.assertThat((boolean)seenInfrastructure).isTrue();
        Assertions.assertThat((int)entitiesSeen).isEqualTo(2);
    }

    @Test
    public void testNoInfrastructureSpec() {
        ImmutableList testSpecs = ImmutableList.of((Object)EntitySpec.create(StartableApplication.class));
        InfrastructureDeploymentTestCase infrastructureDeploymentTestCase = (InfrastructureDeploymentTestCase)this.app.createAndManageChild(EntitySpec.create(InfrastructureDeploymentTestCase.class));
        infrastructureDeploymentTestCase.config().set(InfrastructureDeploymentTestCase.ENTITY_SPEC_TO_DEPLOY, (Object)testSpecs);
        infrastructureDeploymentTestCase.config().set(InfrastructureDeploymentTestCase.DEPLOYMENT_LOCATION_SENSOR_NAME, (Object)DEPLOYMENT_LOCATION_SENSOR.getName());
        try {
            this.app.start((Collection)ImmutableList.of((Object)this.app.newSimulatedLocation()));
            Asserts.shouldHaveFailedPreviously();
        }
        catch (Throwable throwable) {
            Asserts.expectedFailureContains((Throwable)throwable, (String)"EntitySpec", (String[])new String[]{"not configured"});
        }
        Assertions.assertThat((Boolean)((Boolean)infrastructureDeploymentTestCase.sensors().get(Startable.SERVICE_UP))).isFalse();
    }

    @Test
    public void testNoEntitySpec() {
        EntitySpec infrastructureSpec = EntitySpec.create(TestInfrastructure.class);
        infrastructureSpec.configure(DEPLOYMENT_LOCATION_SENSOR, (Object)this.infrastructureLoc);
        InfrastructureDeploymentTestCase infrastructureDeploymentTestCase = (InfrastructureDeploymentTestCase)this.app.createAndManageChild(EntitySpec.create(InfrastructureDeploymentTestCase.class));
        infrastructureDeploymentTestCase.config().set(InfrastructureDeploymentTestCase.INFRASTRUCTURE_SPEC, (Object)infrastructureSpec);
        infrastructureDeploymentTestCase.config().set(InfrastructureDeploymentTestCase.DEPLOYMENT_LOCATION_SENSOR_NAME, (Object)DEPLOYMENT_LOCATION_SENSOR.getName());
        try {
            this.app.start((Collection)ImmutableList.of((Object)this.app.newSimulatedLocation()));
            Asserts.shouldHaveFailedPreviously();
        }
        catch (Throwable throwable) {
            Asserts.expectedFailureContains((Throwable)throwable, (String)"entity.specs", (String[])new String[]{"List", "not configured"});
        }
        Assertions.assertThat((Boolean)((Boolean)infrastructureDeploymentTestCase.sensors().get(Startable.SERVICE_UP))).isFalse();
    }

    @Test
    public void testNoDeploymentLocation() {
        EntitySpec infrastructureSpec = EntitySpec.create(TestInfrastructure.class);
        infrastructureSpec.configure(DEPLOYMENT_LOCATION_SENSOR, (Object)this.infrastructureLoc);
        ImmutableList testSpecs = ImmutableList.of((Object)EntitySpec.create(BasicApplication.class));
        InfrastructureDeploymentTestCase infrastructureDeploymentTestCase = (InfrastructureDeploymentTestCase)this.app.createAndManageChild(EntitySpec.create(InfrastructureDeploymentTestCase.class));
        infrastructureDeploymentTestCase.config().set(InfrastructureDeploymentTestCase.INFRASTRUCTURE_SPEC, (Object)infrastructureSpec);
        infrastructureDeploymentTestCase.config().set(InfrastructureDeploymentTestCase.ENTITY_SPEC_TO_DEPLOY, (Object)testSpecs);
        try {
            this.app.start((Collection)ImmutableList.of((Object)this.app.newSimulatedLocation()));
            Asserts.shouldHaveFailedPreviously();
        }
        catch (Throwable throwable) {
            Asserts.expectedFailure((Throwable)throwable);
        }
        Assertions.assertThat((Boolean)((Boolean)infrastructureDeploymentTestCase.sensors().get(Startable.SERVICE_UP))).isFalse();
    }

    @Test
    public void testInfrastrucutreHasNoLocation() {
        EntitySpec infrastructureSpec = EntitySpec.create(TestInfrastructure.class);
        ImmutableList testSpecs = ImmutableList.of((Object)EntitySpec.create(BasicApplication.class));
        InfrastructureDeploymentTestCase infrastructureDeploymentTestCase = (InfrastructureDeploymentTestCase)this.app.createAndManageChild(EntitySpec.create(InfrastructureDeploymentTestCase.class));
        infrastructureDeploymentTestCase.config().set(InfrastructureDeploymentTestCase.INFRASTRUCTURE_SPEC, (Object)infrastructureSpec);
        infrastructureDeploymentTestCase.config().set(InfrastructureDeploymentTestCase.ENTITY_SPEC_TO_DEPLOY, (Object)testSpecs);
        infrastructureDeploymentTestCase.config().set(InfrastructureDeploymentTestCase.DEPLOYMENT_LOCATION_SENSOR_NAME, (Object)DEPLOYMENT_LOCATION_SENSOR.getName());
        try {
            this.app.start((Collection)ImmutableList.of((Object)this.app.newSimulatedLocation()));
            Asserts.shouldHaveFailedPreviously();
        }
        catch (Throwable throwable) {
            Asserts.expectedFailure((Throwable)throwable);
        }
        Assertions.assertThat((Boolean)((Boolean)infrastructureDeploymentTestCase.sensors().get(Startable.SERVICE_UP))).isFalse();
    }
}

