/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.solr;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.drivers.EntityDriver;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.entity.java.JavaSoftwareProcessSshDriver;
import org.apache.brooklyn.entity.java.UsesJmx;
import org.apache.brooklyn.entity.nosql.solr.SolrServer;
import org.apache.brooklyn.entity.nosql.solr.SolrServerDriver;
import org.apache.brooklyn.entity.nosql.solr.SolrServerImpl;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.file.ArchiveUtils;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.stream.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrServerSshDriver
extends JavaSoftwareProcessSshDriver
implements SolrServerDriver {
    private static final Logger log = LoggerFactory.getLogger(SolrServerSshDriver.class);

    public SolrServerSshDriver(SolrServerImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    @Override
    public Integer getSolrPort() {
        return (Integer)this.entity.getAttribute((AttributeSensor)SolrServer.SOLR_PORT);
    }

    @Override
    public String getSolrConfigTemplateUrl() {
        return (String)this.entity.getConfig(SolrServer.SOLR_CONFIG_TEMPLATE_URL);
    }

    public String getMirrorUrl() {
        return (String)this.entity.getConfig(SolrServer.MIRROR_URL);
    }

    public String getPidFile() {
        return Os.mergePaths((String[])new String[]{this.getRunDir(), "solr.pid"});
    }

    public void preInstall() {
        this.resolver = Entities.newDownloader((EntityDriver)this);
        this.setExpandedInstallDir(Os.mergePaths((String[])new String[]{this.getInstallDir(), this.resolver.getUnpackedDirectoryName(String.format("solr-%s", this.getVersion()))}));
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        ImmutableList commands = ImmutableList.builder().addAll((Iterable)BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs)).add((Object)BashCommands.INSTALL_TAR).add((Object)("tar xzfv " + saveAs)).build();
        this.newScript((String)"installing").failOnNonZeroResultCode().body.append((Collection)commands).execute();
    }

    public Set<Integer> getPortsUsed() {
        LinkedHashSet result = Sets.newLinkedHashSet((Iterable)super.getPortsUsed());
        result.addAll(this.getPortMap().values());
        return result;
    }

    private Map<String, Integer> getPortMap() {
        return ImmutableMap.builder().put((Object)"solrPort", (Object)this.getSolrPort()).put((Object)"jmxPort", this.entity.getAttribute((AttributeSensor)UsesJmx.JMX_PORT)).put((Object)"rmiPort", this.entity.getAttribute((AttributeSensor)UsesJmx.RMI_REGISTRY_PORT)).build();
    }

    public void customize() {
        log.debug("Customizing {}", (Object)this.entity);
        Networking.checkPortsValid(this.getPortMap());
        ImmutableList.Builder commands = new ImmutableList.Builder().add((Object)"mkdir contrib").add((Object)"mkdir solr").add((Object)String.format("cp -R %s/example/{etc,contexts,lib,logs,resources,webapps} .", this.getExpandedInstallDir())).add((Object)String.format("cp %s/example/start.jar .", this.getExpandedInstallDir())).add((Object)String.format("cp %s/dist/*.jar lib/", this.getExpandedInstallDir())).add((Object)String.format("cp %s/contrib/*/lib/*.jar contrib/", this.getExpandedInstallDir()));
        this.newScript((String)"customizing").body.append((Collection)commands.build()).execute();
        String configFileContents = this.processTemplate(this.getSolrConfigTemplateUrl());
        String destinationConfigFile = String.format("%s/solr/solr.xml", this.getRunDir());
        this.getMachine().copyTo(Streams.newInputStreamWithContents((String)configFileContents), destinationConfigFile);
        Map coreConfig = (Map)this.entity.getConfig(SolrServer.SOLR_CORE_CONFIG);
        for (String core : coreConfig.keySet()) {
            String url = (String)coreConfig.get(core);
            String solr = Urls.mergePaths((String[])new String[]{this.getRunDir(), "solr"});
            ArchiveUtils.deploy((String)url, (SshMachineLocation)this.getMachine(), (String)solr);
        }
    }

    public void launch() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), (String)"launching").body.append((CharSequence)"nohup java $JAVA_OPTS -jar start.jar > ./logs/console.log 2>&1 &").execute();
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "check-running").execute() == 0;
    }

    public void stop() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "stopping").execute();
    }

    protected String getLogFileLocation() {
        return Urls.mergePaths((String[])new String[]{this.getRunDir(), "solr", "logs", "solr.log"});
    }
}

