/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.solr;

import com.google.common.base.Functions;
import com.google.common.net.HostAndPort;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.location.access.BrooklynAccessUtils;
import org.apache.brooklyn.entity.nosql.solr.SolrServer;
import org.apache.brooklyn.entity.nosql.solr.SolrServerDriver;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.feed.http.HttpFeed;
import org.apache.brooklyn.feed.http.HttpPollConfig;
import org.apache.brooklyn.feed.http.HttpValueFunctions;

public class SolrServerImpl
extends SoftwareProcessImpl
implements SolrServer {
    private volatile HttpFeed httpFeed;

    @Override
    public Integer getSolrPort() {
        return (Integer)this.getAttribute((AttributeSensor)SolrServer.SOLR_PORT);
    }

    public Class<SolrServerDriver> getDriverInterface() {
        return SolrServerDriver.class;
    }

    protected void connectSensors() {
        super.connectSensors();
        HostAndPort hp = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this, (int)this.getSolrPort());
        String solrUri = String.format("http://%s:%d/solr", hp.getHostText(), hp.getPort());
        this.setAttribute(Attributes.MAIN_URI, URI.create(solrUri));
        this.httpFeed = HttpFeed.builder().entity((EntityLocal)this).period(500L, TimeUnit.MILLISECONDS).baseUri(solrUri).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(SERVICE_UP).onSuccess(HttpValueFunctions.responseCodeEquals((int)200))).onFailureOrException(Functions.constant((Object)false))).build();
    }

    public void disconnectSensors() {
        super.disconnectSensors();
        if (this.httpFeed != null) {
            this.httpFeed.stop();
        }
    }
}

