/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.solr;

import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.location.PortRanges;
import org.apache.brooklyn.core.sensor.BasicAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.PortAttributeSensorAndConfigKey;
import org.apache.brooklyn.entity.java.UsesJava;
import org.apache.brooklyn.entity.java.UsesJavaMXBeans;
import org.apache.brooklyn.entity.java.UsesJmx;
import org.apache.brooklyn.entity.nosql.solr.SolrServerImpl;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.time.Duration;

@Catalog(name="Apache Solr Node", description="Solr is the popular, blazing fast open source enterprise search platform from the Apache Lucene project.", iconUrl="classpath:///solr-logo.jpeg")
@ImplementedBy(value=SolrServerImpl.class)
public interface SolrServer
extends SoftwareProcess,
UsesJava,
UsesJmx,
UsesJavaMXBeans {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"4.7.2");
    @SetFromFlag(value="downloadUrl")
    public static final BasicAttributeSensorAndConfigKey<String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey(SoftwareProcess.DOWNLOAD_URL, (Object)"${driver.mirrorUrl}/${version}/solr-${version}.tgz");
    @SetFromFlag(value="mirrorUrl")
    public static final ConfigKey<String> MIRROR_URL = ConfigKeys.newStringConfigKey((String)"solr.install.mirror.url", (String)"URL of mirror", (String)"http://mirrors.ukfast.co.uk/sites/ftp.apache.org/lucene/solr/");
    @SetFromFlag(value="solrPort")
    public static final PortAttributeSensorAndConfigKey SOLR_PORT = new PortAttributeSensorAndConfigKey("solr.http.port", "Solr HTTP communications port", (Object)PortRanges.fromString((String)"8983+"));
    @SetFromFlag(value="solrConfigTemplateUrl")
    public static final ConfigKey<String> SOLR_CONFIG_TEMPLATE_URL = ConfigKeys.newStringConfigKey((String)"solr.config.templateUrl", (String)"Template file (in freemarker format) for the solr.xml config file", (String)"classpath://org/apache/brooklyn/entity/nosql/solr/solr.xml");
    @SetFromFlag(value="coreConfigMap")
    public static final ConfigKey<Map<String, String>> SOLR_CORE_CONFIG = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Map<String, String>>(){}, (String)"solr.core.config", (String)"Map of core names to core configuration archive URL", (Object)Maps.newHashMap());
    public static final ConfigKey<Duration> START_TIMEOUT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)BrooklynConfigKeys.START_TIMEOUT, (Object)Duration.FIVE_MINUTES);

    public Integer getSolrPort();
}

