/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.redis;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.entity.nosql.redis.RedisStore;
import org.apache.brooklyn.entity.nosql.redis.RedisStoreDriver;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.feed.ssh.SshFeed;
import org.apache.brooklyn.feed.ssh.SshPollConfig;
import org.apache.brooklyn.feed.ssh.SshPollValue;
import org.apache.brooklyn.feed.ssh.SshValueFunctions;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisStoreImpl
extends SoftwareProcessImpl
implements RedisStore {
    private static final Logger LOG = LoggerFactory.getLogger(RedisStore.class);
    private transient SshFeed sshFeed;

    protected void connectSensors() {
        super.connectSensors();
        this.connectServiceUpIsRunning();
        Optional location = Iterables.tryFind((Iterable)this.getLocations(), (Predicate)Predicates.instanceOf(SshMachineLocation.class));
        if (!location.isPresent()) {
            throw new IllegalStateException("Could not find SshMachineLocation in list of locations");
        }
        SshMachineLocation machine = (SshMachineLocation)location.get();
        String statsCommand = this.getDriver().getRunDir() + "/bin/redis-cli -p " + this.getRedisPort() + " info stats";
        boolean retrieveUsageMetrics = (Boolean)this.getConfig(RETRIEVE_USAGE_METRICS);
        this.sshFeed = SshFeed.builder().entity((EntityLocal)this).machine(machine).period(5L, TimeUnit.SECONDS).poll((SshPollConfig)((SshPollConfig)((SshPollConfig)new SshPollConfig(UPTIME).command(this.getDriver().getRunDir() + "/bin/redis-cli -p " + this.getRedisPort() + " info server").onFailureOrException(Functions.constant((Object)-1))).onSuccess(RedisStoreImpl.infoFunction("uptime_in_seconds"))).enabled(retrieveUsageMetrics)).poll((SshPollConfig)((SshPollConfig)((SshPollConfig)new SshPollConfig(TOTAL_CONNECTIONS_RECEIVED).command(statsCommand).onFailureOrException(Functions.constant((Object)-1))).onSuccess(RedisStoreImpl.infoFunction("total_connections_received"))).enabled(retrieveUsageMetrics)).poll((SshPollConfig)((SshPollConfig)((SshPollConfig)new SshPollConfig(TOTAL_COMMANDS_PROCESSED).command(statsCommand).onFailureOrException(Functions.constant((Object)-1))).onSuccess(RedisStoreImpl.infoFunction("total_commands_processed"))).enabled(retrieveUsageMetrics)).poll((SshPollConfig)((SshPollConfig)((SshPollConfig)new SshPollConfig(EXPIRED_KEYS).command(statsCommand).onFailureOrException(Functions.constant((Object)-1))).onSuccess(RedisStoreImpl.infoFunction("expired_keys"))).enabled(retrieveUsageMetrics)).poll((SshPollConfig)((SshPollConfig)((SshPollConfig)new SshPollConfig(EVICTED_KEYS).command(statsCommand).onFailureOrException(Functions.constant((Object)-1))).onSuccess(RedisStoreImpl.infoFunction("evicted_keys"))).enabled(retrieveUsageMetrics)).poll((SshPollConfig)((SshPollConfig)((SshPollConfig)new SshPollConfig(KEYSPACE_HITS).command(statsCommand).onFailureOrException(Functions.constant((Object)-1))).onSuccess(RedisStoreImpl.infoFunction("keyspace_hits"))).enabled(retrieveUsageMetrics)).poll((SshPollConfig)((SshPollConfig)((SshPollConfig)new SshPollConfig(KEYSPACE_MISSES).command(statsCommand).onFailureOrException(Functions.constant((Object)-1))).onSuccess(RedisStoreImpl.infoFunction("keyspace_misses"))).enabled(retrieveUsageMetrics)).build();
    }

    private static Function<SshPollValue, Integer> infoFunction(final String field) {
        return Functions.compose((Function)new Function<String, Integer>(){

            public Integer apply(@Nullable String input) {
                Optional line = Iterables.tryFind((Iterable)Splitter.on((char)'\n').split((CharSequence)input), (Predicate)Predicates.containsPattern((String)(field + ":")));
                if (line.isPresent()) {
                    String data = ((String)line.get()).trim();
                    int colon = data.indexOf(":");
                    return Integer.parseInt(data.substring(colon + 1));
                }
                throw new IllegalStateException("Data for field " + field + " not found: " + input);
            }
        }, (Function)SshValueFunctions.stdout());
    }

    public void disconnectSensors() {
        this.disconnectServiceUpIsRunning();
        if (this.sshFeed != null) {
            this.sshFeed.stop();
        }
        super.disconnectSensors();
    }

    public Class<?> getDriverInterface() {
        return RedisStoreDriver.class;
    }

    public RedisStoreDriver getDriver() {
        return (RedisStoreDriver)super.getDriver();
    }

    @Override
    public String getAddress() {
        MachineLocation machine = this.getMachineOrNull();
        return machine != null ? machine.getAddress().getHostAddress() : null;
    }

    @Override
    public Integer getRedisPort() {
        return (Integer)this.getAttribute((AttributeSensor)RedisStore.REDIS_PORT);
    }
}

