/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.redis;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.enricher.stock.Enrichers;
import org.apache.brooklyn.entity.group.DynamicCluster;
import org.apache.brooklyn.entity.nosql.redis.RedisCluster;
import org.apache.brooklyn.entity.nosql.redis.RedisSlave;
import org.apache.brooklyn.entity.nosql.redis.RedisStore;
import org.apache.brooklyn.util.collections.QuorumCheck;
import org.apache.brooklyn.util.exceptions.CompoundRuntimeException;
import org.apache.brooklyn.util.exceptions.Exceptions;

public class RedisClusterImpl
extends AbstractEntity
implements RedisCluster {
    private static final AttributeSensor<RedisStore> MASTER = Sensors.newSensor(RedisStore.class, (String)"redis.master");
    private static final AttributeSensor<DynamicCluster> SLAVES = Sensors.newSensor(DynamicCluster.class, (String)"redis.slaves");

    @Override
    public RedisStore getMaster() {
        return (RedisStore)this.getAttribute(MASTER);
    }

    @Override
    public DynamicCluster getSlaves() {
        return (DynamicCluster)this.getAttribute(SLAVES);
    }

    public void init() {
        super.init();
        RedisStore master = (RedisStore)this.addChild(EntitySpec.create(RedisStore.class));
        this.setAttribute(MASTER, master);
        DynamicCluster slaves = (DynamicCluster)this.addChild(EntitySpec.create(DynamicCluster.class).configure(DynamicCluster.MEMBER_SPEC, (Object)EntitySpec.create(RedisSlave.class).configure(RedisSlave.MASTER, (Object)master)));
        this.setAttribute(SLAVES, slaves);
        this.addEnricher(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating(new Sensor[]{RedisStore.HOSTNAME, RedisStore.ADDRESS, RedisStore.SUBNET_HOSTNAME, RedisStore.SUBNET_ADDRESS, RedisStore.REDIS_PORT}).from((Entity)master)).build());
    }

    protected void initEnrichers() {
        super.initEnrichers();
        ((ServiceStateLogic.ComputeServiceIndicatorsFromChildrenAndMembersSpec)ServiceStateLogic.newEnricherFromChildrenUp().checkChildrenOnly().requireUpChildren(QuorumCheck.QuorumChecks.all()).configure(ServiceStateLogic.ComputeServiceIndicatorsFromChildrenAndMembers.IGNORE_ENTITIES_WITH_THESE_SERVICE_STATES, (Object)ImmutableSet.of())).addTo((Entity)this);
    }

    public void start(Collection<? extends Location> locations) {
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STARTING);
        ServiceStateLogic.ServiceProblemsLogic.clearProblemsIndicator((EntityLocal)this, (Effector)START);
        try {
            this.doStart(locations);
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.RUNNING);
        }
        catch (Exception e) {
            ServiceStateLogic.ServiceProblemsLogic.updateProblemsIndicator((EntityLocal)this, (Effector)START, (Object)("Start failed with error: " + e));
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private void doStart(Collection<? extends Location> locations) {
        RedisStore master = this.getMaster();
        master.invoke(RedisStore.START, (Map)ImmutableMap.of((Object)"locations", (Object)ImmutableList.copyOf(locations))).getUnchecked();
        DynamicCluster slaves = this.getSlaves();
        slaves.invoke(DynamicCluster.START, (Map)ImmutableMap.of((Object)"locations", (Object)ImmutableList.copyOf(locations))).getUnchecked();
    }

    public void stop() {
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STOPPING);
        try {
            this.doStop();
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STOPPED);
        }
        catch (Exception e) {
            ServiceStateLogic.ServiceProblemsLogic.updateProblemsIndicator((EntityLocal)this, (Effector)STOP, (Object)("Stop failed with error: " + e));
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private void doStop() {
        StringBuilder message = new StringBuilder();
        LinkedList exceptions = Lists.newLinkedList();
        try {
            this.getSlaves().invoke(DynamicCluster.STOP, (Map)ImmutableMap.of()).getUnchecked();
        }
        catch (Exception e) {
            message.append("Failed to stop Redis slaves");
            exceptions.add(e);
        }
        try {
            this.getMaster().invoke(RedisStore.STOP, (Map)ImmutableMap.of()).getUnchecked();
        }
        catch (Exception e) {
            message.append(message.length() == 0 ? "Failed to stop Redis master" : " and master");
            exceptions.add(e);
        }
        if (!exceptions.isEmpty()) {
            throw new CompoundRuntimeException(message.toString(), (Iterable)exceptions);
        }
    }

    public void restart() {
        throw new UnsupportedOperationException();
    }
}

