/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.mongodb.sharding;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.entity.group.DynamicClusterImpl;
import org.apache.brooklyn.entity.nosql.mongodb.sharding.MongoDBConfigServer;
import org.apache.brooklyn.entity.nosql.mongodb.sharding.MongoDBConfigServerCluster;

public class MongoDBConfigServerClusterImpl
extends DynamicClusterImpl
implements MongoDBConfigServerCluster {
    protected EntitySpec<?> getMemberSpec() {
        if (super.getMemberSpec() != null) {
            return super.getMemberSpec();
        }
        return EntitySpec.create(MongoDBConfigServer.class);
    }

    public void start(Collection<? extends Location> locs) {
        super.start(locs);
        Iterable memberHostNamesAndPorts = Iterables.transform((Iterable)this.getMembers(), (Function)new Function<Entity, String>(){

            public String apply(Entity entity) {
                return (String)entity.getAttribute(MongoDBConfigServer.SUBNET_HOSTNAME) + ":" + entity.getAttribute((AttributeSensor)MongoDBConfigServer.PORT);
            }
        });
        this.setAttribute(MongoDBConfigServerCluster.CONFIG_SERVER_ADDRESSES, ImmutableList.copyOf((Iterable)memberHostNamesAndPorts));
    }
}

