/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.mongodb;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import java.util.Iterator;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.location.access.BrooklynAccessUtils;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBServer;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.BasicBSONList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaSetConfig {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicaSetConfig.class);
    static final int MAXIMUM_REPLICA_SET_SIZE = 12;
    static final int MAXIMUM_VOTING_MEMBERS = 7;
    private Optional<HostAndPort> primary = Optional.absent();
    private String name;
    private Integer version;
    BasicBSONList members;

    public ReplicaSetConfig(String name) {
        this(name, new BasicBSONList());
    }

    public ReplicaSetConfig(String name, BasicBSONList existingMembers) {
        this.name = name;
        this.members = existingMembers;
        this.version = 1;
    }

    public static ReplicaSetConfig builder(String name) {
        return new ReplicaSetConfig(name);
    }

    public static ReplicaSetConfig fromExistingConfig(BSONObject config) {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkArgument((boolean)config.containsField("_id"), (Object)"_id missing from replica set config");
        Preconditions.checkArgument((boolean)config.containsField("version"), (Object)"version missing from replica set config");
        Preconditions.checkArgument((boolean)config.containsField("members"), (Object)"members missing from replica set config");
        String name = (String)config.get("_id");
        Integer version = (Integer)config.get("version");
        BasicBSONList members = (BasicBSONList)config.get("members");
        version = version + 1;
        return new ReplicaSetConfig(name, members).version(version);
    }

    public ReplicaSetConfig version(Integer version) {
        this.version = version;
        return this;
    }

    public ReplicaSetConfig primary(HostAndPort primary) {
        this.primary = Optional.of((Object)primary);
        return this;
    }

    public ReplicaSetConfig member(MongoDBServer server, Integer id) {
        HostAndPort hap = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)server, (int)((Integer)server.getAttribute((AttributeSensor)MongoDBServer.PORT)));
        return this.member(hap.getHostText(), hap.getPort(), id);
    }

    public ReplicaSetConfig member(HostAndPort address, Integer id) {
        return this.member(address.getHostText(), address.getPort(), id);
    }

    public ReplicaSetConfig member(String hostname, Integer port, Integer id) {
        if (this.members.size() == 12) {
            throw new IllegalStateException(String.format("Replica set {} exceeds maximum size of {} with addition of member at {}:{}", this.name, 12, hostname, port));
        }
        BasicBSONObject member = new BasicBSONObject();
        member.put("_id", (Object)id);
        member.put("host", (Object)String.format("%s:%s", hostname, port));
        this.members.add((Object)member);
        return this;
    }

    public ReplicaSetConfig remove(MongoDBServer server) {
        HostAndPort hap = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)server, (int)((Integer)server.getAttribute((AttributeSensor)MongoDBServer.PORT)));
        return this.remove(hap.getHostText(), hap.getPort());
    }

    public ReplicaSetConfig remove(HostAndPort address) {
        return this.remove(address.getHostText(), address.getPort());
    }

    public ReplicaSetConfig remove(String hostname, Integer port) {
        String host = String.format("%s:%s", hostname, port);
        Iterator it = this.members.iterator();
        while (it.hasNext()) {
            BasicBSONObject basicBSONObject;
            Object next = it.next();
            if (!(next instanceof BasicBSONObject) || !host.equals((basicBSONObject = (BasicBSONObject)next).getString("host"))) continue;
            it.remove();
            break;
        }
        return this;
    }

    public BasicBSONObject build() {
        this.setVotingMembers();
        BasicBSONObject config = new BasicBSONObject();
        config.put("_id", (Object)this.name);
        config.put("version", (Object)this.version);
        config.put("members", (Object)this.members);
        return config;
    }

    private void setVotingMembers() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting voting and non-voting members of replica set: {}", (Object)this.name);
        }
        boolean seenPrimary = false;
        String expectedPrimary = this.primary.isPresent() ? ((HostAndPort)this.primary.get()).getHostText() + ":" + ((HostAndPort)this.primary.get()).getPort() : "";
        int setSize = this.members.size();
        int nonPrimaryVotingMembers = Math.min(setSize % 2 == 0 ? setSize - 1 : setSize, 7);
        if (this.primary.isPresent()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Reserving vote for primary: " + expectedPrimary);
            }
            --nonPrimaryVotingMembers;
        }
        for (Object member : this.members) {
            if (member instanceof BasicBSONObject) {
                BasicBSONObject bsonObject = (BasicBSONObject)BasicBSONObject.class.cast(member);
                String host = bsonObject.getString("host");
                if (this.primary.isPresent() && expectedPrimary.equals(host)) {
                    bsonObject.put("votes", (Object)1);
                    seenPrimary = true;
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Voting member (primary) of set {}: {}", (Object)this.name, (Object)host);
                    continue;
                }
                if (nonPrimaryVotingMembers-- > 0) {
                    bsonObject.put("votes", (Object)1);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Voting member of set {}: {}", (Object)this.name, (Object)host);
                    continue;
                }
                bsonObject.put("votes", (Object)0);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Non-voting member of set {}: {}", (Object)this.name, (Object)host);
                continue;
            }
            LOG.error("Unexpected entry in replica set members list: " + member);
        }
        if (this.primary.isPresent() && !seenPrimary) {
            LOG.warn("Cannot give replica set primary a vote in reconfigured set: primary was indicated as {} but no member with that host and port was seen in the set. The replica set now has an even number of voters.", this.primary);
        }
    }
}

