/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.mongodb;

import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.net.HostAndPort;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.location.access.BrooklynAccessUtils;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBClientSupport;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBDriver;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBReplicaSet;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBServer;
import org.apache.brooklyn.entity.nosql.mongodb.ReplicaSetMemberStatus;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.feed.function.FunctionFeed;
import org.apache.brooklyn.feed.function.FunctionPollConfig;
import org.bson.BasicBSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBServerImpl
extends SoftwareProcessImpl
implements MongoDBServer {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDBServerImpl.class);
    private FunctionFeed serviceStats;
    private FunctionFeed replicaSetStats;
    private MongoDBClientSupport client;

    public Class<?> getDriverInterface() {
        return MongoDBDriver.class;
    }

    protected void connectSensors() {
        super.connectSensors();
        this.connectServiceUpIsRunning();
        int port = (Integer)this.getAttribute((AttributeSensor)MongoDBServer.PORT);
        HostAndPort accessibleAddress = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this, (int)port);
        this.setAttribute(MONGO_SERVER_ENDPOINT, String.format("http://%s:%d", accessibleAddress.getHostText(), accessibleAddress.getPort()));
        int httpConsolePort = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this, (int)((Integer)this.getAttribute((AttributeSensor)HTTP_PORT))).getPort();
        this.setAttribute(HTTP_INTERFACE_URL, String.format("http://%s:%d", accessibleAddress.getHostText(), httpConsolePort));
        try {
            this.client = MongoDBClientSupport.forServer(this);
        }
        catch (UnknownHostException e) {
            LOG.warn("Unable to create client connection to {}, not connecting sensors: {} ", (Object)this, (Object)e.getMessage());
            return;
        }
        this.serviceStats = FunctionFeed.builder().entity((EntityLocal)this).poll((FunctionPollConfig)((FunctionPollConfig)new FunctionPollConfig(STATUS_BSON).period(2L, TimeUnit.SECONDS)).callable((Callable)new Callable<BasicBSONObject>(){

            @Override
            public BasicBSONObject call() throws Exception {
                return (Boolean)MongoDBServerImpl.this.getAttribute(Startable.SERVICE_UP) != false ? MongoDBServerImpl.this.client.getServerStatus() : null;
            }
        }).onException(Functions.constant(null))).build();
        if (this.isReplicaSetMember()) {
            this.replicaSetStats = FunctionFeed.builder().entity((EntityLocal)this).poll((FunctionPollConfig)((FunctionPollConfig)((FunctionPollConfig)new FunctionPollConfig(REPLICA_SET_MEMBER_STATUS).period(2L, TimeUnit.SECONDS)).callable((Callable)new Callable<ReplicaSetMemberStatus>(){

                @Override
                public ReplicaSetMemberStatus call() {
                    BasicBSONObject serverStatus = MongoDBServerImpl.this.client.getReplicaSetStatus();
                    int state = serverStatus.getInt("myState", -1);
                    return ReplicaSetMemberStatus.fromCode(state);
                }
            }).onException(Functions.constant((Object)((Object)ReplicaSetMemberStatus.UNKNOWN)))).suppressDuplicates(true)).build();
        } else {
            this.setAttribute(IS_PRIMARY_FOR_REPLICA_SET, false);
            this.setAttribute(IS_SECONDARY_FOR_REPLICA_SET, false);
        }
        this.subscribe(this, (Sensor)STATUS_BSON, (SensorEventListener)new SensorEventListener<BasicBSONObject>(){

            public void onEvent(SensorEvent<BasicBSONObject> event) {
                BasicBSONObject map = (BasicBSONObject)event.getValue();
                if (map != null && !map.isEmpty()) {
                    MongoDBServerImpl.this.setAttribute(MongoDBServer.UPTIME_SECONDS, map.getDouble("uptime", 0.0));
                    BasicBSONObject opcounters = (BasicBSONObject)map.get("opcounters");
                    MongoDBServerImpl.this.setAttribute(MongoDBServer.OPCOUNTERS_INSERTS, opcounters.getLong("insert", 0L));
                    MongoDBServerImpl.this.setAttribute(MongoDBServer.OPCOUNTERS_QUERIES, opcounters.getLong("query", 0L));
                    MongoDBServerImpl.this.setAttribute(MongoDBServer.OPCOUNTERS_UPDATES, opcounters.getLong("update", 0L));
                    MongoDBServerImpl.this.setAttribute(MongoDBServer.OPCOUNTERS_DELETES, opcounters.getLong("delete", 0L));
                    MongoDBServerImpl.this.setAttribute(MongoDBServer.OPCOUNTERS_GETMORE, opcounters.getLong("getmore", 0L));
                    MongoDBServerImpl.this.setAttribute(MongoDBServer.OPCOUNTERS_COMMAND, opcounters.getLong("command", 0L));
                    BasicBSONObject network = (BasicBSONObject)map.get("network");
                    MongoDBServerImpl.this.setAttribute(MongoDBServer.NETWORK_BYTES_IN, network.getLong("bytesIn", 0L));
                    MongoDBServerImpl.this.setAttribute(MongoDBServer.NETWORK_BYTES_OUT, network.getLong("bytesOut", 0L));
                    MongoDBServerImpl.this.setAttribute(MongoDBServer.NETWORK_NUM_REQUESTS, network.getLong("numRequests", 0L));
                    BasicBSONObject repl = (BasicBSONObject)map.get("repl");
                    if (MongoDBServerImpl.this.isReplicaSetMember() && repl != null) {
                        MongoDBServerImpl.this.setAttribute(MongoDBServer.IS_PRIMARY_FOR_REPLICA_SET, repl.getBoolean("ismaster"));
                        MongoDBServerImpl.this.setAttribute(MongoDBServer.IS_SECONDARY_FOR_REPLICA_SET, repl.getBoolean("secondary"));
                        MongoDBServerImpl.this.setAttribute(MongoDBServer.REPLICA_SET_PRIMARY_ENDPOINT, repl.getString("primary"));
                    }
                }
            }
        });
    }

    protected void disconnectSensors() {
        super.disconnectSensors();
        this.disconnectServiceUpIsRunning();
        if (this.serviceStats != null) {
            this.serviceStats.stop();
        }
        if (this.replicaSetStats != null) {
            this.replicaSetStats.stop();
        }
    }

    @Override
    public MongoDBReplicaSet getReplicaSet() {
        return (MongoDBReplicaSet)this.getConfig(MongoDBServer.REPLICA_SET);
    }

    @Override
    public boolean isReplicaSetMember() {
        return this.getReplicaSet() != null;
    }

    @Override
    public boolean initializeReplicaSet(String replicaSetName, Integer id) {
        return this.client.initializeReplicaSet(replicaSetName, id);
    }

    @Override
    public boolean addMemberToReplicaSet(MongoDBServer secondary, Integer id) {
        if (!((Boolean)this.getAttribute(IS_PRIMARY_FOR_REPLICA_SET)).booleanValue()) {
            LOG.warn("Attempted to add {} to replica set at server that is not primary: {}", (Object)secondary, (Object)this);
            return false;
        }
        return this.client.addMemberToReplicaSet(secondary, id);
    }

    @Override
    public boolean removeMemberFromReplicaSet(MongoDBServer server) {
        if (!((Boolean)this.getAttribute(IS_PRIMARY_FOR_REPLICA_SET)).booleanValue()) {
            LOG.warn("Attempted to remove {} from replica set at server that is not primary: {}", (Object)server, (Object)this);
            return false;
        }
        return this.client.removeMemberFromReplicaSet(server);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("hostname", this.getAttribute(HOSTNAME)).add("port", this.getAttribute((AttributeSensor)PORT)).toString();
    }

    static {
        RendererHints.register((AttributeSensor)HTTP_INTERFACE_URL, (RendererHints.Hint)RendererHints.namedActionWithUrl());
    }
}

