/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.mongodb;

import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.PortAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.nosql.mongodb.AbstractMongoDBServer;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBReplicaSet;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBServerImpl;
import org.apache.brooklyn.entity.nosql.mongodb.ReplicaSetMemberStatus;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.bson.BasicBSONObject;

@Catalog(name="MongoDB Server", description="MongoDB (from \"humongous\") is a scalable, high-performance, open source NoSQL database", iconUrl="classpath:///mongodb-logo.png")
@ImplementedBy(value=MongoDBServerImpl.class)
public interface MongoDBServer
extends AbstractMongoDBServer {
    @SetFromFlag(value="mongodbConfTemplateUrl")
    public static final ConfigKey<String> MONGODB_CONF_TEMPLATE_URL = ConfigKeys.newConfigKeyWithDefault(AbstractMongoDBServer.MONGODB_CONF_TEMPLATE_URL, (Object)"classpath://org/apache/brooklyn/entity/nosql/mongodb/default-mongod.conf");
    public static final PortAttributeSensorAndConfigKey HTTP_PORT = new PortAttributeSensorAndConfigKey("mongodb.server.httpPort", "HTTP port for the server (estimated)", (Object)"28017+");
    @SetFromFlag(value="enableRestInterface")
    public static final ConfigKey<Boolean> ENABLE_REST_INTERFACE = ConfigKeys.newBooleanConfigKey((String)"mongodb.config.enable_rest", (String)"Adds --rest to server startup flags when true", (Boolean)Boolean.FALSE);
    public static final AttributeSensor<String> HTTP_INTERFACE_URL = Sensors.newStringSensor((String)"mongodb.server.http_interface", (String)"URL of the server's HTTP console");
    public static final AttributeSensor<BasicBSONObject> STATUS_BSON = Sensors.builder(BasicBSONObject.class, (String)"mongodb.server.status.bson").description("Server status (BSON/JSON map ojbect)").persistence(AttributeSensor.SensorPersistenceMode.NONE).build();
    public static final AttributeSensor<Double> UPTIME_SECONDS = Sensors.newDoubleSensor((String)"mongodb.server.uptime", (String)"Server uptime in seconds");
    public static final AttributeSensor<Long> OPCOUNTERS_INSERTS = Sensors.newLongSensor((String)"mongodb.server.opcounters.insert", (String)"Server inserts");
    public static final AttributeSensor<Long> OPCOUNTERS_QUERIES = Sensors.newLongSensor((String)"mongodb.server.opcounters.query", (String)"Server queries");
    public static final AttributeSensor<Long> OPCOUNTERS_UPDATES = Sensors.newLongSensor((String)"mongodb.server.opcounters.update", (String)"Server updates");
    public static final AttributeSensor<Long> OPCOUNTERS_DELETES = Sensors.newLongSensor((String)"mongodb.server.opcounters.delete", (String)"Server deletes");
    public static final AttributeSensor<Long> OPCOUNTERS_GETMORE = Sensors.newLongSensor((String)"mongodb.server.opcounters.getmore", (String)"Server getmores");
    public static final AttributeSensor<Long> OPCOUNTERS_COMMAND = Sensors.newLongSensor((String)"mongodb.server.opcounters.command", (String)"Server commands");
    public static final AttributeSensor<Long> NETWORK_BYTES_IN = Sensors.newLongSensor((String)"mongodb.server.network.bytesIn", (String)"Server incoming network traffic (in bytes)");
    public static final AttributeSensor<Long> NETWORK_BYTES_OUT = Sensors.newLongSensor((String)"mongodb.server.network.bytesOut", (String)"Server outgoing network traffic (in bytes)");
    public static final AttributeSensor<Long> NETWORK_NUM_REQUESTS = Sensors.newLongSensor((String)"mongodb.server.network.numRequests", (String)"Server network requests");
    public static final ConfigKey<MongoDBReplicaSet> REPLICA_SET = new BasicConfigKey(MongoDBReplicaSet.class, "mongodb.replicaset", "The replica set to which the server belongs. Users should not set this directly when creating a new replica set.");
    public static final AttributeSensor<ReplicaSetMemberStatus> REPLICA_SET_MEMBER_STATUS = Sensors.newSensor(ReplicaSetMemberStatus.class, (String)"mongodb.server.replicaSet.memberStatus", (String)"The status of this server in the replica set");
    public static final AttributeSensor<Boolean> IS_PRIMARY_FOR_REPLICA_SET = Sensors.newBooleanSensor((String)"mongodb.server.replicaSet.isPrimary", (String)"True if this server is the write master for the replica set");
    public static final AttributeSensor<Boolean> IS_SECONDARY_FOR_REPLICA_SET = Sensors.newBooleanSensor((String)"mongodb.server.replicaSet.isSecondary", (String)"True if this server is a secondary server in the replica set");
    public static final AttributeSensor<String> REPLICA_SET_PRIMARY_ENDPOINT = Sensors.newStringSensor((String)"mongodb.server.replicaSet.primary.endpoint", (String)"The host:port of the server which is acting as primary (master) for the replica set");
    public static final AttributeSensor<String> MONGO_SERVER_ENDPOINT = Sensors.newStringSensor((String)"mongodb.server.endpoint", (String)"The host:port where this server is listening");

    public MongoDBReplicaSet getReplicaSet();

    public boolean isReplicaSetMember();

    public boolean initializeReplicaSet(String var1, Integer var2);

    public boolean addMemberToReplicaSet(MongoDBServer var1, Integer var2);

    public boolean removeMemberFromReplicaSet(MongoDBServer var1);
}

