/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.mongodb;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.enricher.stock.Enrichers;
import org.apache.brooklyn.entity.group.AbstractMembershipTrackingPolicy;
import org.apache.brooklyn.entity.group.DynamicClusterImpl;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBReplicaSet;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBServer;
import org.apache.brooklyn.entity.nosql.mongodb.ReplicaSetMemberStatus;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBReplicaSetImpl
extends DynamicClusterImpl
implements MongoDBReplicaSet {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDBReplicaSetImpl.class);
    private final AtomicInteger nextMemberId = new AtomicInteger(0);
    private MemberTrackingPolicy policy;
    private final AtomicBoolean mustInitialise = new AtomicBoolean(true);
    protected static final List<AttributeSensor<Long>> SENSORS_TO_SUM = Arrays.asList(MongoDBServer.OPCOUNTERS_INSERTS, MongoDBServer.OPCOUNTERS_QUERIES, MongoDBServer.OPCOUNTERS_UPDATES, MongoDBServer.OPCOUNTERS_DELETES, MongoDBServer.OPCOUNTERS_GETMORE, MongoDBServer.OPCOUNTERS_COMMAND, MongoDBServer.NETWORK_BYTES_IN, MongoDBServer.NETWORK_BYTES_OUT, MongoDBServer.NETWORK_NUM_REQUESTS);
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    static final Predicate<Entity> IS_PRIMARY = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity input) {
            return input != null && input instanceof MongoDBServer && ReplicaSetMemberStatus.PRIMARY.equals(input.getAttribute(MongoDBServer.REPLICA_SET_MEMBER_STATUS));
        }
    };
    static final Predicate<Entity> IS_SECONDARY = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity input) {
            return input != null && input instanceof MongoDBServer && ReplicaSetMemberStatus.SECONDARY.equals(input.getAttribute(MongoDBServer.REPLICA_SET_MEMBER_STATUS));
        }
    };
    private static final Function<Collection<Entity>, Entity> NON_PRIMARY_REMOVAL_STRATEGY = new Function<Collection<Entity>, Entity>(){

        public Entity apply(@Nullable Collection<Entity> entities) {
            Preconditions.checkArgument((entities != null && entities.size() > 0 ? 1 : 0) != 0, (Object)"Expect list of MongoDBServers to have at least one entry");
            return (Entity)Iterables.tryFind(entities, (Predicate)Predicates.not(IS_PRIMARY)).or(Iterables.get(entities, (int)0));
        }
    };

    public Function<Collection<Entity>, Entity> getRemovalStrategy() {
        return NON_PRIMARY_REMOVAL_STRATEGY;
    }

    protected EntitySpec<?> getMemberSpec() {
        return (EntitySpec)this.getConfig(MEMBER_SPEC, EntitySpec.create(MongoDBServer.class));
    }

    protected Map<?, ?> getCustomChildFlags() {
        return ImmutableMap.builder().putAll(super.getCustomChildFlags()).put(MongoDBServer.REPLICA_SET, (Object)this.getProxy()).build();
    }

    @Override
    public String getName() {
        return (String)this.getConfig(REPLICA_SET_NAME) + this.getId();
    }

    @Override
    public MongoDBServer getPrimary() {
        return (MongoDBServer)Iterables.tryFind(this.getReplicas(), IS_PRIMARY).orNull();
    }

    @Override
    public Collection<MongoDBServer> getSecondaries() {
        return FluentIterable.from(this.getReplicas()).filter(IS_SECONDARY).toList();
    }

    @Override
    public Collection<MongoDBServer> getReplicas() {
        return FluentIterable.from((Iterable)this.getMembers()).transform((Function)new Function<Entity, MongoDBServer>(){

            public MongoDBServer apply(Entity input) {
                return (MongoDBServer)MongoDBServer.class.cast(input);
            }
        }).toList();
    }

    private void serverAdded(MongoDBServer server) {
        LOG.debug("Server added: {}. SERVICE_UP: {}", (Object)server, server.getAttribute(MongoDBServer.SERVICE_UP));
        if (this.mustInitialise.compareAndSet(true, false)) {
            boolean replicaSetInitialised;
            if (LOG.isInfoEnabled()) {
                LOG.info("First server up in {} is: {}", (Object)this.getName(), (Object)server);
            }
            if (replicaSetInitialised = server.initializeReplicaSet(this.getName(), this.nextMemberId.getAndIncrement())) {
                this.setAttribute(PRIMARY_ENTITY, server);
                this.setAttribute(Startable.SERVICE_UP, true);
            } else {
                ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.ON_FIRE);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling addition of member to {}: {}", (Object)this.getName(), (Object)server);
            }
            this.addSecondaryWhenPrimaryIsNonNull(server);
        }
    }

    private void addSecondaryWhenPrimaryIsNonNull(final MongoDBServer secondary) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                boolean reschedule;
                Boolean isAvailable = (Boolean)secondary.getAttribute(MongoDBServer.SERVICE_UP);
                MongoDBServer primary = MongoDBReplicaSetImpl.this.getPrimary();
                if (Boolean.TRUE.equals(isAvailable) && primary != null) {
                    boolean added = primary.addMemberToReplicaSet(secondary, MongoDBReplicaSetImpl.this.nextMemberId.incrementAndGet());
                    if (added) {
                        LOG.info("{} added to replica set {}", (Object)secondary, (Object)MongoDBReplicaSetImpl.this.getName());
                        reschedule = false;
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} could not be added to replica set via {}; rescheduling", (Object)secondary, (Object)MongoDBReplicaSetImpl.this.getName());
                        }
                        reschedule = true;
                    }
                } else {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Rescheduling addition of member {} to replica set {}: service_up={}, primary={}", new Object[]{secondary, MongoDBReplicaSetImpl.this.getName(), isAvailable, primary});
                    }
                    reschedule = true;
                }
                if (reschedule) {
                    MongoDBReplicaSetImpl.this.executor.schedule(this, 3L, TimeUnit.SECONDS);
                }
            }
        });
    }

    private void serverRemoved(final MongoDBServer member) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scheduling removal of member from {}: {}", (Object)this.getName(), (Object)member);
        }
        if (member.equals(this.getAttribute(PRIMARY_ENTITY))) {
            this.setAttribute(PRIMARY_ENTITY, null);
        }
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                boolean reschedule;
                Boolean isAvailable = (Boolean)member.getAttribute(MongoDBServer.SERVICE_UP);
                MongoDBServer primary = MongoDBReplicaSetImpl.this.getPrimary();
                if (primary != null && !isAvailable.booleanValue()) {
                    boolean removed = primary.removeMemberFromReplicaSet(member);
                    if (removed) {
                        LOG.info("Removed {} from replica set {}", (Object)member, (Object)MongoDBReplicaSetImpl.this.getName());
                        reschedule = false;
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} could not be removed from replica set via {}; rescheduling", (Object)member, (Object)MongoDBReplicaSetImpl.this.getName());
                        }
                        reschedule = true;
                    }
                } else {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Rescheduling removal of member {} from replica set {}: service_up={}, primary={}", new Object[]{member, MongoDBReplicaSetImpl.this.getName(), isAvailable, primary});
                    }
                    reschedule = true;
                }
                if (reschedule) {
                    MongoDBReplicaSetImpl.this.executor.schedule(this, 3L, TimeUnit.SECONDS);
                }
            }
        });
    }

    public void start(Collection<? extends Location> locations) {
        super.start(locations);
        this.policy = (MemberTrackingPolicy)this.addPolicy(((PolicySpec)PolicySpec.create(MemberTrackingPolicy.class).displayName(this.getName() + " membership tracker")).configure((CharSequence)"group", (Object)this));
        for (AttributeSensor<Long> sensor : SENSORS_TO_SUM) {
            this.addEnricher(((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)Enrichers.builder().aggregating(sensor).publishing(sensor).fromMembers()).computingSum()).valueToReportIfNoSensors(null)).defaultValueForUnreportedSensors(null)).build());
        }
        this.addEnricher(((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)Enrichers.builder().aggregating(MongoDBServer.REPLICA_SET_PRIMARY_ENDPOINT).publishing(MongoDBServer.REPLICA_SET_PRIMARY_ENDPOINT).fromMembers()).valueToReportIfNoSensors(null)).computing((Function)new Function<Collection<String>, String>(){

            public String apply(Collection<String> input) {
                if (input == null || input.isEmpty()) {
                    return null;
                }
                MutableSet distinct = MutableSet.of();
                for (String endpoint : input) {
                    if (Strings.isBlank((CharSequence)endpoint)) continue;
                    distinct.add(endpoint);
                }
                if (distinct.size() > 1) {
                    LOG.warn("Mongo replica set " + MongoDBReplicaSetImpl.this + " detetcted multiple masters (transitioning?): " + distinct);
                }
                return input.iterator().next();
            }
        })).build());
        this.addEnricher(((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)Enrichers.builder().aggregating(MongoDBServer.MONGO_SERVER_ENDPOINT).publishing(REPLICA_SET_ENDPOINTS).fromMembers()).valueToReportIfNoSensors(null)).computing((Function)new Function<Collection<String>, List<String>>(){

            public List<String> apply(Collection<String> input) {
                TreeSet<String> endpoints = new TreeSet<String>();
                for (String endpoint : input) {
                    if (Strings.isBlank((CharSequence)endpoint)) continue;
                    endpoints.add(endpoint);
                }
                return MutableList.copyOf(endpoints);
            }
        })).build());
        this.subscribeToMembers((Group)this, (Sensor)MongoDBServer.IS_PRIMARY_FOR_REPLICA_SET, (SensorEventListener)new SensorEventListener<Boolean>(){

            public void onEvent(SensorEvent<Boolean> event) {
                if (Boolean.TRUE == event.getValue()) {
                    MongoDBReplicaSetImpl.this.setAttribute(MongoDBReplicaSet.PRIMARY_ENTITY, (MongoDBServer)event.getSource());
                }
            }
        });
    }

    public void stop() {
        this.executor.shutdownNow();
        super.stop();
        this.setAttribute(Startable.SERVICE_UP, false);
    }

    public void onManagementStopped() {
        super.onManagementStopped();
        this.executor.shutdownNow();
    }

    public static class MemberTrackingPolicy
    extends AbstractMembershipTrackingPolicy {
        protected void onEntityChange(Entity member) {
        }

        protected void onEntityAdded(Entity member) {
            ((MongoDBReplicaSetImpl)this.entity).serverAdded((MongoDBServer)member);
        }

        protected void onEntityRemoved(Entity member) {
            ((MongoDBReplicaSetImpl)this.entity).serverRemoved((MongoDBServer)member);
        }
    }
}

