/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.mongodb;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.drivers.EntityDriver;
import org.apache.brooklyn.api.location.OsDetails;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.entity.nosql.mongodb.AbstractMongoDBServer;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBClientSupport;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBServer;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessSshDriver;
import org.apache.brooklyn.entity.software.base.lifecycle.NaiveScriptRunner;
import org.apache.brooklyn.entity.software.base.lifecycle.ScriptHelper;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMongoDBSshDriver
extends AbstractSoftwareProcessSshDriver {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMongoDBSshDriver.class);

    public AbstractMongoDBSshDriver(EntityLocal entity, SshMachineLocation machine) {
        super(entity, machine);
    }

    public void preInstall() {
        this.resolver = Entities.newDownloader((EntityDriver)this);
        this.setExpandedInstallDir(Os.mergePaths((String[])new String[]{this.getInstallDir(), this.resolver.getUnpackedDirectoryName(this.getBaseName())}));
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        LinkedList<String> commands = new LinkedList<String>();
        commands.addAll(BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs));
        commands.add(BashCommands.INSTALL_TAR);
        commands.add("tar xzfv " + saveAs);
        this.newScript((String)"installing").failOnNonZeroResultCode().body.append(commands).execute();
    }

    public void customize() {
        ImmutableMap ports = ImmutableMap.of((Object)"port", (Object)this.getServerPort());
        Networking.checkPortsValid((Map)ports);
        String command = String.format("mkdir -p %s", this.getDataDirectory());
        this.newScript((String)"customizing").updateTaskAndFailOnNonZeroResultCode().body.append((CharSequence)command).execute();
        String templateUrl = (String)this.entity.getConfig(MongoDBServer.MONGODB_CONF_TEMPLATE_URL);
        if (!Strings.isNullOrEmpty((String)templateUrl)) {
            this.copyTemplate(templateUrl, this.getConfFile());
        }
    }

    public boolean isRunning() {
        try {
            return MongoDBClientSupport.forServer((AbstractMongoDBServer)this.entity).ping();
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            return false;
        }
    }

    public void stop() {
        new ScriptHelper((NaiveScriptRunner)this, (String)"Send SIGINT to MongoDB server").body.append((CharSequence)("kill -2 $(cat " + this.getPidFile() + ")")).execute();
    }

    protected String getBaseName() {
        return this.getOsTag() + "-" + (String)this.entity.getConfig(AbstractMongoDBServer.SUGGESTED_VERSION);
    }

    public String getOsDir() {
        return this.getLocation().getOsDetails().isMac() ? "osx" : "linux";
    }

    public String getOsTag() {
        OsDetails os = this.getLocation().getOsDetails();
        if (os == null) {
            return "mongodb-linux-x86_64";
        }
        if (os.isMac()) {
            return "mongodb-osx-x86_64";
        }
        String arch = os.is64bit() ? "x86_64" : "i686";
        return "mongodb-linux-" + arch;
    }

    public String getDataDirectory() {
        String result = (String)this.entity.getConfig(MongoDBServer.DATA_DIRECTORY);
        if (result != null) {
            return result;
        }
        return this.getRunDir() + "/data";
    }

    protected String getLogFile() {
        return this.getRunDir() + "/log.txt";
    }

    protected String getPidFile() {
        return this.getRunDir() + "/pid";
    }

    protected Integer getServerPort() {
        return (Integer)this.entity.getAttribute((AttributeSensor)MongoDBServer.PORT);
    }

    protected String getConfFile() {
        return this.getRunDir() + "/mongo.conf";
    }

    protected ImmutableList.Builder<String> getArgsBuilderWithDefaults(AbstractMongoDBServer server) {
        Integer port = (Integer)server.getAttribute((AttributeSensor)MongoDBServer.PORT);
        return ImmutableList.builder().add((Object[])new String[]{"--config", this.getConfFile()}).add((Object[])new String[]{"--pidfilepath", this.getPidFile()}).add((Object[])new String[]{"--logpath", this.getLogFile()}).add((Object[])new String[]{"--port", port.toString()}).add((Object)"--fork");
    }

    protected void launch(ImmutableList.Builder<String> argsBuilder) {
        String args = Joiner.on((String)" ").join((Iterable)argsBuilder.build());
        String command = String.format("%s/bin/mongod %s > out.log 2> err.log < /dev/null", this.getExpandedInstallDir(), args);
        LOG.info(command);
        this.newScript((String)"launching").updateTaskAndFailOnNonZeroResultCode().body.append((CharSequence)command).execute();
    }
}

