/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.couchdb;

import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.BasicAttributeSensorAndConfigKey;
import org.apache.brooklyn.entity.nosql.couchdb.CouchDBCluster;
import org.apache.brooklyn.entity.nosql.couchdb.CouchDBNodeImpl;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.webapp.WebAppService;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@Catalog(name="CouchDB Node", description="Apache CouchDB is a database that uses JSON for documents, JavaScript for MapReduce queries, and regular HTTP for an API", iconUrl="classpath:///couchdb-logo.png")
@ImplementedBy(value=CouchDBNodeImpl.class)
public interface CouchDBNode
extends SoftwareProcess,
WebAppService {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"1.2.1");
    @SetFromFlag(value="erlangVersion")
    public static final ConfigKey<String> ERLANG_VERSION = ConfigKeys.newStringConfigKey((String)"erlang.version", (String)"Erlang runtime version", (String)"R15B");
    @SetFromFlag(value="clusterName")
    public static final BasicAttributeSensorAndConfigKey<String> CLUSTER_NAME = CouchDBCluster.CLUSTER_NAME;
    @SetFromFlag(value="couchdbConfigTemplateUrl")
    public static final BasicAttributeSensorAndConfigKey<String> COUCHDB_CONFIG_TEMPLATE_URL = new BasicAttributeSensorAndConfigKey(String.class, "couchdb.config.templateUrl", "Template file (in freemarker format) for the couchdb config file", (Object)"classpath://org/apache/brooklyn/entity/nosql/couchdb/couch.ini");
    @SetFromFlag(value="couchdbUriTemplateUrl")
    public static final BasicAttributeSensorAndConfigKey<String> COUCHDB_URI_TEMPLATE_URL = new BasicAttributeSensorAndConfigKey(String.class, "couchdb.uri.templateUrl", "Template file (in freemarker format) for the couchdb URI file", (Object)"classpath://org/apache/brooklyn/entity/nosql/couchdb/couch.uri");
    @SetFromFlag(value="couchdbConfigFileName")
    public static final BasicAttributeSensorAndConfigKey<String> COUCHDB_CONFIG_FILE_NAME = new BasicAttributeSensorAndConfigKey(String.class, "couchdb.config.fileName", "Name for the copied config file", (Object)"local.ini");

    public Integer getHttpPort();

    public Integer getHttpsPort();
}

