/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.couchbase;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.net.HostAndPort;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.location.access.BrooklynAccessUtils;
import org.apache.brooklyn.core.sensor.DependentConfiguration;
import org.apache.brooklyn.enricher.stock.Enrichers;
import org.apache.brooklyn.entity.group.AbstractMembershipTrackingPolicy;
import org.apache.brooklyn.entity.group.DynamicClusterImpl;
import org.apache.brooklyn.entity.nosql.couchbase.CouchbaseCluster;
import org.apache.brooklyn.entity.nosql.couchbase.CouchbaseNode;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.feed.http.HttpFeed;
import org.apache.brooklyn.feed.http.HttpPollConfig;
import org.apache.brooklyn.feed.http.HttpValueFunctions;
import org.apache.brooklyn.feed.http.JsonFunctions;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.collections.CollectionFunctionals;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.collections.QuorumCheck;
import org.apache.brooklyn.util.core.http.HttpToolResponse;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Functionals;
import org.apache.brooklyn.util.guava.IfFunctions;
import org.apache.brooklyn.util.math.MathPredicates;
import org.apache.brooklyn.util.text.ByteSizeStrings;
import org.apache.brooklyn.util.text.StringFunctions;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchbaseClusterImpl
extends DynamicClusterImpl
implements CouchbaseCluster {
    private static final Logger log = LoggerFactory.getLogger(CouchbaseClusterImpl.class);
    private final Object mutex = new Object[0];
    private final AtomicReference<HttpFeed> resetBucketCreation = new AtomicReference();

    public void init() {
        log.info("Initializing the Couchbase cluster...");
        super.init();
        this.addEnricher(((Enrichers.TransformerBuilder)((Enrichers.TransformerBuilder)Enrichers.builder().transforming(COUCHBASE_CLUSTER_UP_NODES).from((Entity)this)).publishing(COUCHBASE_CLUSTER_UP_NODE_ADDRESSES).computing((Function)new ListOfHostAndPort())).build());
        this.addEnricher(((Enrichers.TransformerBuilder)((Enrichers.TransformerBuilder)Enrichers.builder().transforming(COUCHBASE_CLUSTER_UP_NODE_ADDRESSES).from((Entity)this)).publishing(COUCHBASE_CLUSTER_CONNECTION_URL).computing((Function)IfFunctions.ifPredicate((Predicate)Predicates.compose((Predicate)MathPredicates.lessThan((double)((Integer)this.getConfig(CouchbaseCluster.INITIAL_QUORUM_SIZE)).intValue()), (Function)CollectionFunctionals.sizeFunction((Integer)0))).value((Object)null).defaultApply(Functionals.chain((Function)CollectionFunctionals.limit((int)4), (Function)StringFunctions.joiner((String)","), (Function)StringFunctions.formatter((String)"http://%s/"))))).build());
        ImmutableMap enricherSetup = ImmutableMap.builder().put(CouchbaseNode.OPS, CouchbaseCluster.OPS_PER_NODE).put(CouchbaseNode.COUCH_DOCS_DATA_SIZE, CouchbaseCluster.COUCH_DOCS_DATA_SIZE_PER_NODE).put(CouchbaseNode.COUCH_DOCS_ACTUAL_DISK_SIZE, CouchbaseCluster.COUCH_DOCS_ACTUAL_DISK_SIZE_PER_NODE).put(CouchbaseNode.EP_BG_FETCHED, CouchbaseCluster.EP_BG_FETCHED_PER_NODE).put(CouchbaseNode.MEM_USED, CouchbaseCluster.MEM_USED_PER_NODE).put(CouchbaseNode.COUCH_VIEWS_ACTUAL_DISK_SIZE, CouchbaseCluster.COUCH_VIEWS_ACTUAL_DISK_SIZE_PER_NODE).put(CouchbaseNode.CURR_ITEMS, CouchbaseCluster.CURR_ITEMS_PER_NODE).put(CouchbaseNode.VB_REPLICA_CURR_ITEMS, CouchbaseCluster.VB_REPLICA_CURR_ITEMS_PER_NODE).put(CouchbaseNode.COUCH_VIEWS_DATA_SIZE, CouchbaseCluster.COUCH_VIEWS_DATA_SIZE_PER_NODE).put(CouchbaseNode.GET_HITS, CouchbaseCluster.GET_HITS_PER_NODE).put(CouchbaseNode.CMD_GET, CouchbaseCluster.CMD_GET_PER_NODE).put(CouchbaseNode.CURR_ITEMS_TOT, CouchbaseCluster.CURR_ITEMS_TOT_PER_NODE).build();
        for (AttributeSensor nodeSensor : enricherSetup.keySet()) {
            this.addSummingMemberEnricher((AttributeSensor<? extends Number>)nodeSensor);
            this.addAveragingMemberEnricher((AttributeSensor<? extends Number>)nodeSensor, (AttributeSensor<? extends Number>)((AttributeSensor)enricherSetup.get(nodeSensor)));
        }
        this.addEnricher(((Enrichers.UpdatingMapBuilder)Enrichers.builder().updatingMap(Attributes.SERVICE_NOT_UP_INDICATORS).from(IS_CLUSTER_INITIALIZED).computing((Function)IfFunctions.ifNotEquals((Object)true).value((Object)"The cluster is not yet completely initialized").defaultValue(null).build())).build());
    }

    private void addAveragingMemberEnricher(AttributeSensor<? extends Number> fromSensor, AttributeSensor<? extends Number> toSensor) {
        this.addEnricher(((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)Enrichers.builder().aggregating(fromSensor).publishing(toSensor).fromMembers()).computingAverage()).build());
    }

    private void addSummingMemberEnricher(AttributeSensor<? extends Number> source) {
        this.addEnricher(((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)Enrichers.builder().aggregating(source).publishing(source).fromMembers()).computingSum()).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() {
        this.setAttribute(IS_CLUSTER_INITIALIZED, false);
        super.doStart();
        this.connectSensors();
        this.setAttribute(BUCKET_CREATION_IN_PROGRESS, false);
        Tasks.setBlockingDetails((String)"Pausing while Couchbase stabilizes");
        Time.sleep((Duration)((Duration)this.getConfig(NODES_STARTED_STABILIZATION_DELAY)));
        Optional upNodes = Optional.fromNullable((Object)this.getAttribute(COUCHBASE_CLUSTER_UP_NODES));
        if (upNodes.isPresent() && !((Set)upNodes.get()).isEmpty()) {
            Tasks.setBlockingDetails((String)"Adding servers to Couchbase");
            Entity primaryNode = (Entity)((Set)upNodes.get()).iterator().next();
            ((EntityInternal)primaryNode).setAttribute(CouchbaseNode.IS_PRIMARY_NODE, (Object)true);
            this.setAttribute(COUCHBASE_PRIMARY_NODE, primaryNode);
            MutableSet serversToAdd = MutableSet.copyOf(this.getUpNodes());
            if (serversToAdd.size() >= this.getQuorumSize() && serversToAdd.size() > 1) {
                log.info("Number of SERVICE_UP nodes:{} in cluster:{} reached Quorum:{}, adding the servers", new Object[]{serversToAdd.size(), this.getId(), this.getQuorumSize()});
                this.addServers((Set<Entity>)serversToAdd);
                try {
                    Tasks.setBlockingDetails((String)"Delaying before advertising cluster up");
                    Time.sleep((Duration)((Duration)this.getConfig(DELAY_BEFORE_ADVERTISING_CLUSTER)));
                }
                finally {
                    Tasks.resetBlockingDetails();
                }
                this.getPrimaryNode().rebalance();
            } else {
                if (this.getQuorumSize() > 1) {
                    log.warn(this + " is not quorate; will likely fail later, but proceeding for now");
                }
                for (Entity server : serversToAdd) {
                    ((EntityInternal)server).setAttribute(CouchbaseNode.IS_IN_CLUSTER, (Object)true);
                }
            }
            if (this.getConfig(CREATE_BUCKETS) != null) {
                try {
                    Tasks.setBlockingDetails((String)"Creating buckets in Couchbase");
                    this.createBuckets();
                    DependentConfiguration.waitInTaskForAttributeReady((Entity)this, CouchbaseCluster.BUCKET_CREATION_IN_PROGRESS, (Predicate)Predicates.equalTo((Object)false));
                }
                finally {
                    Tasks.resetBlockingDetails();
                }
            }
            if (this.getConfig(REPLICATION) != null) {
                try {
                    Tasks.setBlockingDetails((String)"Configuring replication rules");
                    List replRules = (List)this.getConfig(REPLICATION);
                    for (Map replRule : replRules) {
                        DynamicTasks.queue((TaskAdaptable)Effectors.invocation((Entity)this.getPrimaryNode(), CouchbaseNode.ADD_REPLICATION_RULE, (Map)replRule));
                    }
                    DynamicTasks.waitForLast();
                }
                finally {
                    Tasks.resetBlockingDetails();
                }
            }
        } else {
            throw new IllegalStateException("No up nodes available after starting");
        }
        this.setAttribute(IS_CLUSTER_INITIALIZED, true);
    }

    public void stop() {
        if (this.resetBucketCreation.get() != null) {
            this.resetBucketCreation.get().stop();
        }
        super.stop();
    }

    protected void connectSensors() {
        this.addPolicy(((PolicySpec)PolicySpec.create(MemberTrackingPolicy.class).displayName("Controller targets tracker")).configure((CharSequence)"group", (Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void onServerPoolMemberChanged(Entity member) {
        if (log.isTraceEnabled()) {
            log.trace("For {}, considering membership of {} which is in locations {}", new Object[]{this, member, member.getLocations()});
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.belongsInServerPool(member)) {
                Optional upNodes = Optional.fromNullable(this.getUpNodes());
                if (upNodes.isPresent()) {
                    if (!((Set)upNodes.get()).contains(member)) {
                        HashSet newNodes = Sets.newHashSet(this.getUpNodes());
                        newNodes.add(member);
                        this.setAttribute(COUCHBASE_CLUSTER_UP_NODES, newNodes);
                        if (this.isClusterInitialized()) {
                            this.addServer(member);
                        }
                    }
                } else {
                    HashSet newNodes = Sets.newHashSet();
                    newNodes.add(member);
                    this.setAttribute(COUCHBASE_CLUSTER_UP_NODES, newNodes);
                    if (this.isClusterInitialized()) {
                        this.addServer(member);
                    }
                }
            } else {
                Set<Entity> upNodes = this.getUpNodes();
                if (upNodes != null && upNodes.contains(member)) {
                    upNodes.remove(member);
                    this.setAttribute(COUCHBASE_CLUSTER_UP_NODES, upNodes);
                    log.info("Removing couchbase node {}: {}; from cluster", new Object[]{this, member});
                }
            }
            if (log.isTraceEnabled()) {
                log.trace("Done {} checkEntity {}", (Object)this, (Object)member);
            }
        }
    }

    protected boolean belongsInServerPool(Entity member) {
        if (!JavaGroovyEquivalents.groovyTruth((Object)member.getAttribute(Startable.SERVICE_UP))) {
            if (log.isTraceEnabled()) {
                log.trace("Members of {}, checking {}, eliminating because not up", (Object)this, (Object)member);
            }
            return false;
        }
        if (!this.getMembers().contains(member)) {
            if (log.isTraceEnabled()) {
                log.trace("Members of {}, checking {}, eliminating because not member", (Object)this, (Object)member);
            }
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace("Members of {}, checking {}, approving", (Object)this, (Object)member);
        }
        return true;
    }

    protected EntitySpec<?> getMemberSpec() {
        EntitySpec result = super.getMemberSpec();
        if (result != null) {
            return result;
        }
        return EntitySpec.create(CouchbaseNode.class);
    }

    @Override
    public int getQuorumSize() {
        Integer quorumSize = (Integer)this.getConfig(CouchbaseCluster.INITIAL_QUORUM_SIZE);
        if (quorumSize != null && quorumSize > 0) {
            return quorumSize;
        }
        return (int)Math.floor((Integer)this.getConfig((ConfigKey)INITIAL_SIZE) / 2) + 1;
    }

    protected int getActualSize() {
        return (Integer)Optional.fromNullable((Object)this.getAttribute(CouchbaseCluster.ACTUAL_CLUSTER_SIZE)).or((Object)-1);
    }

    private Set<Entity> getUpNodes() {
        return (Set)this.getAttribute(COUCHBASE_CLUSTER_UP_NODES);
    }

    private CouchbaseNode getPrimaryNode() {
        return (CouchbaseNode)this.getAttribute(COUCHBASE_PRIMARY_NODE);
    }

    protected void initEnrichers() {
        this.addEnricher(((Enrichers.UpdatingMapBuilder)Enrichers.builder().updatingMap(ServiceStateLogic.SERVICE_NOT_UP_INDICATORS).from(COUCHBASE_CLUSTER_UP_NODES).computing((Function)new Function<Set<Entity>, Object>(){

            public Object apply(Set<Entity> input) {
                if (input == null) {
                    return "Couchbase up nodes not set";
                }
                if (input.isEmpty()) {
                    return "No Couchbase up nodes";
                }
                if (input.size() < CouchbaseClusterImpl.this.getQuorumSize()) {
                    return "Couchbase up nodes not quorate";
                }
                return null;
            }
        })).build());
        if (this.config().getLocalRaw(UP_QUORUM_CHECK).isAbsent()) {
            this.config().set(UP_QUORUM_CHECK, (Object)new CouchbaseQuorumCheck(this));
        }
        super.initEnrichers();
    }

    protected void addServers(Set<Entity> serversToAdd) {
        Preconditions.checkNotNull(serversToAdd);
        for (Entity s : serversToAdd) {
            this.addServerSeveralTimes(s, 12, Duration.TEN_SECONDS);
        }
    }

    protected void addServerSeveralTimes(Entity s, int numRetries, Duration delayOnFailure) {
        try {
            this.addServer(s);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            if (numRetries <= 0) {
                throw Exceptions.propagate((Throwable)e);
            }
            log.warn("Error adding " + s + " to " + this + ", " + numRetries + " retries remaining, will retry after delay (" + e + ")");
            Time.sleep((Duration)delayOnFailure);
            this.addServerSeveralTimes(s, numRetries - 1, delayOnFailure);
        }
    }

    protected void addServer(Entity serverToAdd) {
        Preconditions.checkNotNull((Object)serverToAdd);
        if (serverToAdd.equals(this.getPrimaryNode())) {
            return;
        }
        if (!this.isMemberInCluster(serverToAdd)) {
            HostAndPort webAdmin = HostAndPort.fromParts((String)((String)serverToAdd.getAttribute(SoftwareProcess.SUBNET_HOSTNAME)), (int)((Integer)serverToAdd.getAttribute((AttributeSensor)CouchbaseNode.COUCHBASE_WEB_ADMIN_PORT)));
            String username = (String)serverToAdd.getConfig(CouchbaseNode.COUCHBASE_ADMIN_USERNAME);
            String password = (String)serverToAdd.getConfig(CouchbaseNode.COUCHBASE_ADMIN_PASSWORD);
            if (this.isClusterInitialized()) {
                Entities.invokeEffectorWithArgs((EntityLocal)this, (Entity)this.getPrimaryNode(), CouchbaseNode.SERVER_ADD_AND_REBALANCE, (Object[])new Object[]{webAdmin.toString(), username, password}).getUnchecked();
            } else {
                Entities.invokeEffectorWithArgs((EntityLocal)this, (Entity)this.getPrimaryNode(), CouchbaseNode.SERVER_ADD, (Object[])new Object[]{webAdmin.toString(), username, password}).getUnchecked();
            }
            ((EntityInternal)serverToAdd).setAttribute(CouchbaseNode.IS_IN_CLUSTER, (Object)true);
        }
    }

    public static String getClusterName(Entity node) {
        String name = (String)node.getConfig(CLUSTER_NAME);
        if (!Strings.isBlank((CharSequence)name)) {
            return Strings.makeValidFilename((String)name);
        }
        return CouchbaseClusterImpl.getClusterOrNode(node).getId();
    }

    @Nonnull
    public static Entity getClusterOrNode(Entity node) {
        Iterable clusterNodes = Iterables.filter((Iterable)Entities.ancestors((Entity)node), CouchbaseCluster.class);
        return (Entity)Iterables.getFirst((Iterable)clusterNodes, (Object)node);
    }

    public boolean isClusterInitialized() {
        return (Boolean)Optional.fromNullable((Object)this.getAttribute(IS_CLUSTER_INITIALIZED)).or((Object)false);
    }

    public boolean isMemberInCluster(Entity e) {
        return (Boolean)Optional.fromNullable((Object)e.getAttribute(CouchbaseNode.IS_IN_CLUSTER)).or((Object)false);
    }

    public void createBuckets() {
        List bucketsToCreate = (List)this.getConfig(CREATE_BUCKETS);
        if (bucketsToCreate == null) {
            return;
        }
        CouchbaseNode primaryNode = this.getPrimaryNode();
        for (Map bucketMap : bucketsToCreate) {
            String bucketName = bucketMap.containsKey("bucket") ? (String)bucketMap.get("bucket") : "default";
            String bucketType = bucketMap.containsKey("bucket-type") ? (String)bucketMap.get("bucket-type") : "couchbase";
            Integer bucketPort = bucketMap.containsKey("bucket-port") ? (Integer)bucketMap.get("bucket-port") : 11211;
            Integer bucketRamSize = bucketMap.containsKey("bucket-ramsize") ? (Integer)bucketMap.get("bucket-ramsize") : 100;
            Integer bucketReplica = bucketMap.containsKey("bucket-replica") ? (Integer)bucketMap.get("bucket-replica") : 1;
            this.createBucket((Entity)primaryNode, bucketName, bucketType, bucketPort, bucketRamSize, bucketReplica);
        }
    }

    public void createBucket(final Entity primaryNode, final String bucketName, final String bucketType, final Integer bucketPort, final Integer bucketRamSize, final Integer bucketReplica) {
        DynamicTasks.queueIfPossible((TaskAdaptable)TaskBuilder.builder().displayName("Creating bucket " + bucketName).body((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DependentConfiguration.waitInTaskForAttributeReady((Entity)CouchbaseClusterImpl.this, CouchbaseCluster.BUCKET_CREATION_IN_PROGRESS, (Predicate)Predicates.equalTo((Object)false));
                if (CouchbaseClusterImpl.this.resetBucketCreation.get() != null) {
                    ((HttpFeed)CouchbaseClusterImpl.this.resetBucketCreation.get()).stop();
                }
                CouchbaseClusterImpl.this.setAttribute(CouchbaseCluster.BUCKET_CREATION_IN_PROGRESS, true);
                HostAndPort hostAndPort = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)primaryNode, (int)((Integer)primaryNode.getAttribute((AttributeSensor)CouchbaseNode.COUCHBASE_WEB_ADMIN_PORT)));
                CouchbaseClusterImpl.this.resetBucketCreation.set(HttpFeed.builder().entity((EntityLocal)CouchbaseClusterImpl.this).period(500L, TimeUnit.MILLISECONDS).baseUri(String.format("http://%s/pools/default/buckets/%s", hostAndPort, bucketName)).credentials((String)primaryNode.getConfig(CouchbaseNode.COUCHBASE_ADMIN_USERNAME), (String)primaryNode.getConfig(CouchbaseNode.COUCHBASE_ADMIN_PASSWORD)).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(CouchbaseCluster.BUCKET_CREATION_IN_PROGRESS).onSuccess(Functionals.chain((Function)HttpValueFunctions.jsonContents(), (Function)JsonFunctions.walkN((String)"nodes"), (Function)new Function<JsonElement, Boolean>(){

                    public Boolean apply(JsonElement input) {
                        JsonArray servers = input.getAsJsonArray();
                        if (servers.size() != CouchbaseClusterImpl.this.getMembers().size()) {
                            return true;
                        }
                        for (JsonElement server : servers) {
                            JsonElement api = server.getAsJsonObject().get("couchApiBase");
                            if (api != null && !Strings.isEmpty((CharSequence)String.valueOf(api))) continue;
                            return true;
                        }
                        return false;
                    }
                }))).onFailureOrException((Function)new Function<Object, Boolean>(){

                    public Boolean apply(Object input) {
                        if (input instanceof HttpToolResponse && ((HttpToolResponse)input).getResponseCode() == 404) {
                            return true;
                        }
                        if (input instanceof Throwable) {
                            Exceptions.propagate((Throwable)((Throwable)input));
                        }
                        throw new IllegalStateException("Unexpected response when creating bucket:" + input);
                    }
                })).build());
                Entities.invokeEffectorWithArgs((EntityLocal)CouchbaseClusterImpl.this, (Entity)primaryNode, CouchbaseNode.BUCKET_CREATE, (Object[])new Object[]{bucketName, bucketType, bucketPort, bucketRamSize, bucketReplica});
                DependentConfiguration.waitInTaskForAttributeReady((Entity)CouchbaseClusterImpl.this, CouchbaseCluster.BUCKET_CREATION_IN_PROGRESS, (Predicate)Predicates.equalTo((Object)false));
                if (CouchbaseClusterImpl.this.resetBucketCreation.get() != null) {
                    ((HttpFeed)CouchbaseClusterImpl.this.resetBucketCreation.get()).stop();
                }
                return null;
            }
        }).build()).orSubmitAndBlock();
    }

    static {
        RendererHints.register((AttributeSensor)COUCH_DOCS_DATA_SIZE_PER_NODE, (RendererHints.Hint)RendererHints.displayValue((Function)ByteSizeStrings.metric()));
        RendererHints.register((AttributeSensor)COUCH_DOCS_ACTUAL_DISK_SIZE_PER_NODE, (RendererHints.Hint)RendererHints.displayValue((Function)ByteSizeStrings.metric()));
        RendererHints.register((AttributeSensor)MEM_USED_PER_NODE, (RendererHints.Hint)RendererHints.displayValue((Function)ByteSizeStrings.metric()));
        RendererHints.register((AttributeSensor)COUCH_VIEWS_ACTUAL_DISK_SIZE_PER_NODE, (RendererHints.Hint)RendererHints.displayValue((Function)ByteSizeStrings.metric()));
        RendererHints.register((AttributeSensor)COUCH_VIEWS_DATA_SIZE_PER_NODE, (RendererHints.Hint)RendererHints.displayValue((Function)ByteSizeStrings.metric()));
    }

    static class CouchbaseQuorumCheck
    implements QuorumCheck {
        private final CouchbaseCluster cluster;

        CouchbaseQuorumCheck(CouchbaseCluster cluster) {
            this.cluster = cluster;
        }

        public boolean isQuorate(int sizeHealthy, int totalSize) {
            return sizeHealthy >= this.cluster.getQuorumSize();
        }
    }

    public static class MemberTrackingPolicy
    extends AbstractMembershipTrackingPolicy {
        protected void onEntityChange(Entity member) {
            ((CouchbaseClusterImpl)this.entity).onServerPoolMemberChanged(member);
        }

        protected void onEntityAdded(Entity member) {
            ((CouchbaseClusterImpl)this.entity).onServerPoolMemberChanged(member);
        }

        protected void onEntityRemoved(Entity member) {
            ((CouchbaseClusterImpl)this.entity).onServerPoolMemberChanged(member);
        }
    }

    private static final class ListOfHostAndPort
    implements Function<Set<Entity>, List<String>> {
        private ListOfHostAndPort() {
        }

        public List<String> apply(Set<Entity> input) {
            ArrayList addresses = Lists.newArrayList();
            for (Entity entity : input) {
                addresses.add(String.format("%s", BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)entity, (int)((Integer)entity.getAttribute((AttributeSensor)CouchbaseNode.COUCHBASE_WEB_ADMIN_PORT)))));
            }
            return addresses;
        }
    }
}

