/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.cassandra;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.net.HostAndPort;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.effector.EffectorBody;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityPredicates;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.location.Machines;
import org.apache.brooklyn.enricher.stock.Enrichers;
import org.apache.brooklyn.entity.group.AbstractMembershipTrackingPolicy;
import org.apache.brooklyn.entity.group.DynamicCluster;
import org.apache.brooklyn.entity.group.DynamicClusterImpl;
import org.apache.brooklyn.entity.group.DynamicGroup;
import org.apache.brooklyn.entity.nosql.cassandra.CassandraDatacenter;
import org.apache.brooklyn.entity.nosql.cassandra.CassandraNode;
import org.apache.brooklyn.entity.nosql.cassandra.TokenGenerator;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDatacenterImpl
extends DynamicClusterImpl
implements CassandraDatacenter {
    private static final Logger log = LoggerFactory.getLogger(CassandraDatacenterImpl.class);
    private final Object mutex = new Object[0];
    private final Supplier<Set<Entity>> defaultSeedSupplier = new Supplier<Set<Entity>>(){
        private final Object seedMutex = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<Entity> get() {
            Object object = this.seedMutex;
            synchronized (object) {
                boolean stillWaitingForQuorum;
                boolean hasPublishedSeeds = Boolean.TRUE.equals(CassandraDatacenterImpl.this.getAttribute(CassandraDatacenter.HAS_PUBLISHED_SEEDS));
                int quorumSize = CassandraDatacenterImpl.this.getSeedQuorumSize();
                Set<Entity> potentialSeeds = CassandraDatacenterImpl.this.gatherPotentialSeeds();
                Set<Entity> potentialRunningSeeds = CassandraDatacenterImpl.this.gatherPotentialRunningSeeds();
                boolean bl = stillWaitingForQuorum = !hasPublishedSeeds && potentialSeeds.size() < quorumSize;
                if (stillWaitingForQuorum) {
                    if (log.isDebugEnabled()) {
                        log.debug("Not refreshed seeds of cluster {}, because still waiting for quorum (need {}; have {} potentials)", new Object[]{CassandraDatacenterImpl.class, quorumSize, potentialSeeds.size()});
                    }
                    return ImmutableSet.of();
                }
                if (hasPublishedSeeds) {
                    Set currentSeeds = (Set)CassandraDatacenterImpl.this.getAttribute(CassandraDatacenter.CURRENT_SEEDS);
                    if (CassandraDatacenterImpl.this.getAttribute(DynamicCluster.SERVICE_STATE_ACTUAL) == Lifecycle.STARTING) {
                        if (Sets.intersection((Set)currentSeeds, potentialSeeds).isEmpty()) {
                            log.warn("Cluster {} lost all its seeds while starting! Subsequent failure likely, but changing seeds during startup would risk split-brain: seeds={}", new Object[]{CassandraDatacenterImpl.this, currentSeeds});
                        }
                        return currentSeeds;
                    }
                    if (potentialRunningSeeds.isEmpty()) {
                        log.warn("Cluster {} has no running seeds (yet?); leaving seeds as-is; but risks split-brain if these seeds come back up!", new Object[]{CassandraDatacenterImpl.this});
                        return currentSeeds;
                    }
                    Set<Entity> result = this.trim(quorumSize, potentialRunningSeeds);
                    log.debug("Cluster {} updating seeds: chosen={}; potentialRunning={}", new Object[]{CassandraDatacenterImpl.this, result, potentialRunningSeeds});
                    return result;
                }
                Set<Entity> result = this.trim(quorumSize, potentialSeeds);
                if (log.isDebugEnabled()) {
                    log.debug("Cluster {} has reached seed quorum: seeds={}", new Object[]{CassandraDatacenterImpl.this, result});
                }
                return result;
            }
        }

        private Set<Entity> trim(int num, Set<Entity> contenders) {
            ImmutableSet currentSeeds = CassandraDatacenterImpl.this.getAttribute(CassandraDatacenter.CURRENT_SEEDS) != null ? (Set)CassandraDatacenterImpl.this.getAttribute(CassandraDatacenter.CURRENT_SEEDS) : ImmutableSet.of();
            LinkedHashSet result = Sets.newLinkedHashSet();
            result.addAll(Sets.intersection((Set)currentSeeds, contenders));
            result.addAll(contenders);
            return ImmutableSet.copyOf((Iterable)Iterables.limit((Iterable)result, (int)num));
        }
    };
    protected SeedTracker seedTracker = new SeedTracker();
    protected TokenGenerator tokenGenerator = null;

    public void init() {
        super.init();
        this.subscribeToMembers((Group)this, (Sensor)Attributes.HOSTNAME, (SensorEventListener)new SensorEventListener<String>(){

            public void onEvent(SensorEvent<String> event) {
                CassandraDatacenterImpl.this.seedTracker.onHostnameChanged(event.getSource(), (String)event.getValue());
            }
        });
        this.subscribe((Entity)this, (Sensor)DynamicGroup.MEMBER_REMOVED, (SensorEventListener)new SensorEventListener<Entity>(){

            public void onEvent(SensorEvent<Entity> event) {
                CassandraDatacenterImpl.this.seedTracker.onMemberRemoved((Entity)event.getValue());
            }
        });
        this.subscribeToMembers((Group)this, (Sensor)Attributes.SERVICE_UP, (SensorEventListener)new SensorEventListener<Boolean>(){

            public void onEvent(SensorEvent<Boolean> event) {
                CassandraDatacenterImpl.this.seedTracker.onServiceUpChanged(event.getSource(), (Boolean)event.getValue());
            }
        });
        this.subscribeToMembers((Group)this, (Sensor)Attributes.SERVICE_STATE_ACTUAL, (SensorEventListener)new SensorEventListener<Lifecycle>(){

            public void onEvent(SensorEvent<Lifecycle> event) {
                CassandraDatacenterImpl.this.seedTracker.onServiceUpChanged(event.getSource(), Lifecycle.RUNNING == event.getValue());
            }
        });
        this.subscribeToMembers((Group)this, (Sensor)CassandraNode.DATACENTER_NAME, (SensorEventListener)new SensorEventListener<String>(){

            public void onEvent(SensorEvent<String> event) {
                Multimap datacenterUsage;
                LinkedHashMultimap mutableDatacenterUsage;
                Optional oldDcName;
                Entity member = event.getSource();
                String dcName = (String)event.getValue();
                if (!(dcName == null || (oldDcName = this.getKeyOfVal((Multimap)(mutableDatacenterUsage = (datacenterUsage = (Multimap)CassandraDatacenterImpl.this.getAttribute(CassandraDatacenter.DATACENTER_USAGE)) == null ? LinkedHashMultimap.create() : LinkedHashMultimap.create((Multimap)datacenterUsage)), (Object)member)).isPresent() && dcName.equals(oldDcName.get()))) {
                    mutableDatacenterUsage.values().remove(member);
                    mutableDatacenterUsage.put((Object)dcName, (Object)member);
                    CassandraDatacenterImpl.this.setAttribute(CassandraDatacenter.DATACENTER_USAGE, mutableDatacenterUsage);
                    CassandraDatacenterImpl.this.setAttribute(CassandraDatacenter.DATACENTERS, Sets.newLinkedHashSet((Iterable)mutableDatacenterUsage.keySet()));
                }
            }

            private <K, V> Optional<K> getKeyOfVal(Multimap<K, V> map, V val) {
                for (Map.Entry entry : map.entries()) {
                    if (!Objects.equal(val, entry.getValue())) continue;
                    return Optional.of(entry.getKey());
                }
                return Optional.absent();
            }
        });
        this.subscribe((Entity)this, (Sensor)DynamicGroup.MEMBER_REMOVED, (SensorEventListener)new SensorEventListener<Entity>(){

            public void onEvent(SensorEvent<Entity> event) {
                Entity entity = event.getSource();
                Multimap datacenterUsage = (Multimap)CassandraDatacenterImpl.this.getAttribute(CassandraDatacenter.DATACENTER_USAGE);
                if (datacenterUsage != null && datacenterUsage.containsValue((Object)entity)) {
                    LinkedHashMultimap mutableDatacenterUsage = LinkedHashMultimap.create((Multimap)datacenterUsage);
                    mutableDatacenterUsage.values().remove(entity);
                    CassandraDatacenterImpl.this.setAttribute(CassandraDatacenter.DATACENTER_USAGE, mutableDatacenterUsage);
                    CassandraDatacenterImpl.this.setAttribute(CassandraDatacenter.DATACENTERS, Sets.newLinkedHashSet((Iterable)mutableDatacenterUsage.keySet()));
                }
            }
        });
        this.getMutableEntityType().addEffector(EXECUTE_SCRIPT, (EffectorBody)new EffectorBody<String>(){

            public String call(ConfigBag parameters) {
                return CassandraDatacenterImpl.this.executeScript((String)parameters.getStringKey("commands"));
            }
        });
    }

    protected Supplier<Set<Entity>> getSeedSupplier() {
        Supplier<Set<Entity>> seedSupplier = (Supplier<Set<Entity>>)this.getConfig(SEED_SUPPLIER);
        return seedSupplier == null ? this.defaultSeedSupplier : seedSupplier;
    }

    protected boolean useVnodes() {
        return Boolean.TRUE.equals(this.getConfig(USE_VNODES));
    }

    protected synchronized TokenGenerator getTokenGenerator() {
        if (this.tokenGenerator != null) {
            return this.tokenGenerator;
        }
        try {
            this.tokenGenerator = (TokenGenerator)((Class)this.getConfig(TOKEN_GENERATOR_CLASS)).newInstance();
            BigInteger shift = (BigInteger)this.getConfig(TOKEN_SHIFT);
            if (shift == null) {
                shift = BigDecimal.valueOf(Math.random()).multiply(new BigDecimal(this.tokenGenerator.range())).toBigInteger();
            }
            this.tokenGenerator.setOrigin(shift);
            return this.tokenGenerator;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected int getSeedQuorumSize() {
        Integer quorumSize = (Integer)this.getConfig(INITIAL_QUORUM_SIZE);
        if (quorumSize != null && quorumSize > 0) {
            return quorumSize;
        }
        return Math.min(Math.max((Integer)this.getConfig((ConfigKey)INITIAL_SIZE), 1), 2);
    }

    @Override
    public Set<Entity> gatherPotentialSeeds() {
        return this.seedTracker.gatherPotentialSeeds();
    }

    @Override
    public Set<Entity> gatherPotentialRunningSeeds() {
        return this.seedTracker.gatherPotentialRunningSeeds();
    }

    protected EntitySpec<?> getMemberSpec() {
        return (EntitySpec)this.getConfig(MEMBER_SPEC, EntitySpec.create(CassandraNode.class));
    }

    @Override
    public String getClusterName() {
        return (String)this.getAttribute((AttributeSensor)CLUSTER_NAME);
    }

    public Collection<Entity> grow(int delta) {
        if (!this.useVnodes() && this.getCurrentSize() == 0) {
            this.getTokenGenerator().growingCluster(delta);
        }
        return super.grow(delta);
    }

    protected Entity createNode(@Nullable Location loc, Map<?, ?> flags) {
        MutableMap allflags = MutableMap.copyOf(flags);
        if (!(flags.containsKey(CassandraNode.TOKEN) || flags.containsKey("token") || flags.containsKey(CassandraNode.TOKENS) || flags.containsKey("tokens") || this.useVnodes())) {
            BigInteger token = this.getTokenGenerator().newToken();
            allflags.put(CassandraNode.TOKEN, token);
        }
        if (!flags.containsKey(CassandraNode.NUM_TOKENS_PER_NODE) && !flags.containsKey("numTokensPerNode")) {
            if (this.useVnodes()) {
                Integer numTokensPerNode = (Integer)this.getConfig(NUM_TOKENS_PER_NODE);
                allflags.put(CassandraNode.NUM_TOKENS_PER_NODE, numTokensPerNode);
            } else {
                allflags.put(CassandraNode.NUM_TOKENS_PER_NODE, 1);
            }
        }
        return super.createNode(loc, (Map)allflags);
    }

    protected Entity replaceMember(Entity member, Location memberLoc, Map<?, ?> extraFlags) {
        Set<BigInteger> oldTokens = ((CassandraNode)member).getTokens();
        Set<BigInteger> newTokens = oldTokens != null && oldTokens.size() > 0 ? this.getTokenGenerator().getTokensForReplacementNode(oldTokens) : null;
        return super.replaceMember(member, memberLoc, (Map)MutableMap.copyOf(extraFlags).add(CassandraNode.TOKENS, newTokens));
    }

    public void start(Collection<? extends Location> locations) {
        Machines.warnIfLocalhost(locations, (String)"CassandraCluster does not support multiple nodes on localhost, due to assumptions Cassandra makes about the use of the same port numbers used across the cluster.");
        this.setAttribute((AttributeSensor)CLUSTER_NAME, this.getConfig((ConfigKey.HasConfigKey)CLUSTER_NAME));
        super.start(locations);
        this.connectSensors();
        Time.sleep((Duration)((Duration)this.getConfig(DELAY_BEFORE_ADVERTISING_CLUSTER)));
        String scriptUrl = (String)this.getConfig(CassandraNode.CREATION_SCRIPT_URL);
        if (Strings.isNonEmpty((CharSequence)scriptUrl)) {
            this.executeScript(new ResourceUtils((Object)this).getResourceAsString(scriptUrl));
        }
        this.update();
    }

    protected void connectSensors() {
        this.connectEnrichers();
        this.addPolicy(((PolicySpec)PolicySpec.create(MemberTrackingPolicy.class).displayName("Cassandra Cluster Tracker")).configure((CharSequence)"sensorsToTrack", (Object)ImmutableSet.of((Object)Attributes.SERVICE_UP, (Object)Attributes.HOSTNAME, (Object)CassandraNode.THRIFT_PORT)).configure((CharSequence)"group", (Object)this));
    }

    protected void connectEnrichers() {
        AttributeSensor t;
        ImmutableList summingEnricherSetup = ImmutableList.of((Object)ImmutableList.of(CassandraNode.READ_ACTIVE, (Object)READ_ACTIVE), (Object)ImmutableList.of(CassandraNode.READ_PENDING, (Object)READ_PENDING), (Object)ImmutableList.of(CassandraNode.WRITE_ACTIVE, (Object)WRITE_ACTIVE), (Object)ImmutableList.of(CassandraNode.WRITE_PENDING, (Object)WRITE_PENDING));
        ImmutableList averagingEnricherSetup = ImmutableList.of((Object)ImmutableList.of(CassandraNode.READS_PER_SECOND_LAST, (Object)READS_PER_SECOND_LAST_PER_NODE), (Object)ImmutableList.of(CassandraNode.WRITES_PER_SECOND_LAST, (Object)WRITES_PER_SECOND_LAST_PER_NODE), (Object)ImmutableList.of(CassandraNode.WRITES_PER_SECOND_IN_WINDOW, (Object)WRITES_PER_SECOND_IN_WINDOW_PER_NODE), (Object)ImmutableList.of(CassandraNode.READS_PER_SECOND_IN_WINDOW, (Object)READS_PER_SECOND_IN_WINDOW_PER_NODE), (Object)ImmutableList.of(CassandraNode.THRIFT_PORT_LATENCY, (Object)THRIFT_PORT_LATENCY_PER_NODE), (Object)ImmutableList.of(CassandraNode.THRIFT_PORT_LATENCY_IN_WINDOW, (Object)THRIFT_PORT_LATENCY_IN_WINDOW_PER_NODE), (Object)ImmutableList.of((Object)CassandraNode.PROCESS_CPU_TIME_FRACTION_LAST, (Object)PROCESS_CPU_TIME_FRACTION_LAST_PER_NODE), (Object)ImmutableList.of((Object)CassandraNode.PROCESS_CPU_TIME_FRACTION_IN_WINDOW, (Object)PROCESS_CPU_TIME_FRACTION_IN_WINDOW_PER_NODE));
        for (List es : summingEnricherSetup) {
            t = (AttributeSensor)es.get(0);
            AttributeSensor total = (AttributeSensor)es.get(1);
            this.addEnricher(((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)Enrichers.builder().aggregating(t).publishing(total).fromMembers()).computingSum()).defaultValueForUnreportedSensors(null)).valueToReportIfNoSensors(null)).build());
        }
        for (List es : averagingEnricherSetup) {
            t = (AttributeSensor)es.get(0);
            AttributeSensor average = (AttributeSensor)es.get(1);
            this.addEnricher(((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)Enrichers.builder().aggregating(t).publishing(average).fromMembers()).computingAverage()).defaultValueForUnreportedSensors(null)).valueToReportIfNoSensors(null)).build());
        }
    }

    public void stop() {
        this.disconnectSensors();
        super.stop();
    }

    protected void disconnectSensors() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        Object object = this.mutex;
        synchronized (object) {
            this.seedTracker.refreshSeeds();
            Optional upNode = Iterables.tryFind((Iterable)this.getMembers(), (Predicate)EntityPredicates.attributeEqualTo((AttributeSensor)SERVICE_UP, (Object)Boolean.TRUE));
            if (upNode.isPresent()) {
                this.setAttribute(HOSTNAME, ((Entity)upNode.get()).getAttribute(Attributes.HOSTNAME));
                this.setAttribute(THRIFT_PORT, ((Entity)upNode.get()).getAttribute((AttributeSensor)CassandraNode.THRIFT_PORT));
                List currentNodes = (List)this.getAttribute(CASSANDRA_CLUSTER_NODES);
                ImmutableSet oldNodes = currentNodes != null ? ImmutableSet.copyOf((Collection)currentNodes) : ImmutableSet.of();
                MutableSet newNodes = MutableSet.of();
                for (Entity member : this.getMembers()) {
                    if (!(member instanceof CassandraNode) || !Boolean.TRUE.equals(member.getAttribute(SERVICE_UP))) continue;
                    String hostname = (String)member.getAttribute(Attributes.HOSTNAME);
                    Integer thriftPort = (Integer)member.getAttribute((AttributeSensor)CassandraNode.THRIFT_PORT);
                    if (hostname == null || thriftPort == null) continue;
                    newNodes.add(HostAndPort.fromParts((String)hostname, (int)thriftPort).toString());
                }
                if (Sets.symmetricDifference((Set)oldNodes, (Set)newNodes).size() > 0) {
                    this.setAttribute(CASSANDRA_CLUSTER_NODES, MutableList.copyOf((Iterable)newNodes));
                }
            } else {
                this.setAttribute(HOSTNAME, null);
                this.setAttribute(THRIFT_PORT, null);
                this.setAttribute(CASSANDRA_CLUSTER_NODES, Collections.emptyList());
            }
            ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicatorRequiringNonEmptyList((EntityLocal)this, (AttributeSensor)CASSANDRA_CLUSTER_NODES);
        }
    }

    @Override
    public String executeScript(String commands) {
        Entity someChild = (Entity)Iterables.getFirst((Iterable)this.getMembers(), null);
        if (someChild == null) {
            throw new IllegalStateException("No Cassandra nodes available");
        }
        return (String)Entities.invokeEffector((EntityLocal)this, (Entity)someChild, CassandraNode.EXECUTE_SCRIPT, (Map)MutableMap.of((Object)"commands", (Object)commands)).getUnchecked();
    }

    protected class SeedTracker {
        private final Map<Entity, Boolean> memberUpness = Maps.newLinkedHashMap();

        protected SeedTracker() {
        }

        public void onMemberRemoved(Entity member) {
            Set<Entity> seeds = this.getSeeds();
            boolean maybeRemove = seeds.contains(member);
            this.memberUpness.remove(member);
            if (!maybeRemove) {
                if (log.isTraceEnabled()) {
                    log.trace("Seeds considered stable for cluster {} (node {} removed)", new Object[]{CassandraDatacenterImpl.this, member});
                }
                return;
            }
            this.refreshSeeds();
        }

        public void onHostnameChanged(Entity member, String hostname) {
            boolean maybeRemove;
            Set<Entity> seeds = this.getSeeds();
            int quorum = CassandraDatacenterImpl.this.getSeedQuorumSize();
            boolean isViable = this.isViableSeed(member);
            boolean maybeAdd = isViable && seeds.size() < quorum;
            boolean bl = maybeRemove = seeds.contains(member) && !isViable;
            if (!maybeAdd && !maybeRemove) {
                if (log.isTraceEnabled()) {
                    log.trace("Seeds considered stable for cluster {} (node {} changed hostname {})", new Object[]{CassandraDatacenterImpl.this, member, hostname});
                }
                return;
            }
            this.refreshSeeds();
        }

        public void onServiceUpChanged(Entity member, Boolean serviceUp) {
            boolean maybeRemove;
            Boolean oldVal = this.memberUpness.put(member, serviceUp);
            if (Objects.equal((Object)oldVal, (Object)serviceUp) && log.isTraceEnabled()) {
                log.trace("Ignoring duplicate service-up in " + CassandraDatacenterImpl.this + " for " + member + ", " + serviceUp);
            }
            Set<Entity> seeds = this.getSeeds();
            int quorum = CassandraDatacenterImpl.this.getSeedQuorumSize();
            boolean isViable = this.isViableSeed(member);
            boolean maybeAdd = isViable && seeds.size() < quorum;
            boolean bl = maybeRemove = seeds.contains(member) && !isViable;
            if (log.isDebugEnabled()) {
                log.debug("Considering refresh of seeds for " + CassandraDatacenterImpl.this + " because " + member + " is now " + serviceUp + " (" + isViable + " / " + maybeAdd + " / " + maybeRemove + ")");
            }
            if (!maybeAdd && !maybeRemove) {
                if (log.isTraceEnabled()) {
                    log.trace("Seeds considered stable for cluster {} (node {} changed serviceUp {})", new Object[]{CassandraDatacenterImpl.this, member, serviceUp});
                }
                return;
            }
            this.refreshSeeds();
        }

        protected Set<Entity> getSeeds() {
            Set result = (Set)CassandraDatacenterImpl.this.getAttribute(CassandraDatacenter.CURRENT_SEEDS);
            return result == null ? ImmutableSet.of() : result;
        }

        public void refreshSeeds() {
            Set newseeds;
            Set oldseeds = (Set)CassandraDatacenterImpl.this.getAttribute(CassandraDatacenter.CURRENT_SEEDS);
            if (Objects.equal((Object)oldseeds, (Object)(newseeds = (Set)CassandraDatacenterImpl.this.getSeedSupplier().get()))) {
                if (log.isTraceEnabled()) {
                    log.debug("Seed refresh no-op for cluster {}: still={}", new Object[]{CassandraDatacenterImpl.this, oldseeds});
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Refreshing seeds of cluster {}: now={}; old={}", new Object[]{this, newseeds, oldseeds});
                }
                CassandraDatacenterImpl.this.setAttribute(CassandraDatacenter.CURRENT_SEEDS, newseeds);
                if (newseeds != null && newseeds.size() > 0) {
                    CassandraDatacenterImpl.this.setAttribute(CassandraDatacenter.HAS_PUBLISHED_SEEDS, true);
                }
            }
        }

        public Set<Entity> gatherPotentialSeeds() {
            LinkedHashSet result = Sets.newLinkedHashSet();
            for (Entity member : CassandraDatacenterImpl.this.getMembers()) {
                if (!this.isViableSeed(member)) continue;
                result.add(member);
            }
            if (log.isTraceEnabled()) {
                log.trace("Viable seeds in Cluster {}: {}", new Object[]{result});
            }
            return result;
        }

        public Set<Entity> gatherPotentialRunningSeeds() {
            LinkedHashSet result = Sets.newLinkedHashSet();
            for (Entity member : CassandraDatacenterImpl.this.getMembers()) {
                if (!this.isRunningSeed(member)) continue;
                result.add(member);
            }
            if (log.isTraceEnabled()) {
                log.trace("Viable running seeds in Cluster {}: {}", new Object[]{result});
            }
            return result;
        }

        public boolean isViableSeed(Entity member) {
            boolean result;
            boolean managed = Entities.isManaged((Entity)member);
            String hostname = (String)member.getAttribute(Attributes.HOSTNAME);
            boolean serviceUp = Boolean.TRUE.equals(member.getAttribute(Attributes.SERVICE_UP));
            Lifecycle serviceState = (Lifecycle)member.getAttribute(Attributes.SERVICE_STATE_ACTUAL);
            boolean hasFailed = !managed || serviceState == Lifecycle.ON_FIRE || serviceState == Lifecycle.RUNNING && !serviceUp || serviceState == Lifecycle.STOPPED;
            boolean bl = result = hostname != null && !hasFailed;
            if (log.isTraceEnabled()) {
                log.trace("Node {} in Cluster {}: viableSeed={}; hostname={}; serviceUp={}; serviceState={}; hasFailed={}", new Object[]{member, this, result, hostname, serviceUp, serviceState, hasFailed});
            }
            return result;
        }

        public boolean isRunningSeed(Entity member) {
            boolean result;
            boolean viableSeed = this.isViableSeed(member);
            boolean serviceUp = Boolean.TRUE.equals(member.getAttribute(Attributes.SERVICE_UP));
            Lifecycle serviceState = (Lifecycle)member.getAttribute(Attributes.SERVICE_STATE_ACTUAL);
            boolean bl = result = viableSeed && serviceUp && serviceState == Lifecycle.RUNNING;
            if (log.isTraceEnabled()) {
                log.trace("Node {} in Cluster {}: runningSeed={}; viableSeed={}; serviceUp={}; serviceState={}", new Object[]{member, this, result, viableSeed, serviceUp, serviceState});
            }
            return result;
        }
    }

    public static class MemberTrackingPolicy
    extends AbstractMembershipTrackingPolicy {
        protected void onEntityChange(Entity member) {
            if (log.isDebugEnabled()) {
                log.debug("Node {} updated in Cluster {}", (Object)member, (Object)this);
            }
            ((CassandraDatacenterImpl)this.entity).update();
        }

        protected void onEntityAdded(Entity member) {
            if (log.isDebugEnabled()) {
                log.debug("Node {} added to Cluster {}", (Object)member, (Object)this);
            }
            ((CassandraDatacenterImpl)this.entity).update();
        }

        protected void onEntityRemoved(Entity member) {
            if (log.isDebugEnabled()) {
                log.debug("Node {} removed from Cluster {}", (Object)member, (Object)this);
            }
            ((CassandraDatacenterImpl)this.entity).update();
        }
    }
}

