/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.mongodb.sharding;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.core.entity.EntityPredicates;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.entity.group.AbstractMembershipTrackingPolicy;
import org.apache.brooklyn.entity.group.DynamicClusterImpl;
import org.apache.brooklyn.entity.nosql.mongodb.sharding.MongoDBRouter;
import org.apache.brooklyn.entity.nosql.mongodb.sharding.MongoDBRouterCluster;

public class MongoDBRouterClusterImpl
extends DynamicClusterImpl
implements MongoDBRouterCluster {
    public void init() {
        super.init();
        this.subscriptions().subscribeToChildren((Entity)this, MongoDBRouter.RUNNING, (SensorEventListener)new SensorEventListener<Boolean>(){

            public void onEvent(SensorEvent<Boolean> event) {
                MongoDBRouterClusterImpl.this.setAnyRouter();
            }
        });
    }

    public void start(Collection<? extends Location> locations) {
        super.start(locations);
        this.policies().add((PolicySpec)((PolicySpec)PolicySpec.create(MemberTrackingPolicy.class).displayName("Router cluster membership tracker")).configure((CharSequence)"group", (Object)this));
    }

    protected void setAnyRouter() {
        this.sensors().set(MongoDBRouterCluster.ANY_ROUTER, Iterables.tryFind(this.getRouters(), (Predicate)EntityPredicates.attributeEqualTo((AttributeSensor)Startable.SERVICE_UP, (Object)true)).orNull());
        this.sensors().set(MongoDBRouterCluster.ANY_RUNNING_ROUTER, Iterables.tryFind(this.getRouters(), (Predicate)EntityPredicates.attributeEqualTo(MongoDBRouter.RUNNING, (Object)true)).orNull());
    }

    @Override
    public Collection<MongoDBRouter> getRouters() {
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)this.getMembers(), MongoDBRouter.class));
    }

    protected EntitySpec<?> getMemberSpec() {
        if (super.getMemberSpec() != null) {
            return super.getMemberSpec();
        }
        return EntitySpec.create(MongoDBRouter.class);
    }

    @Override
    public MongoDBRouter getAnyRouter() {
        return (MongoDBRouter)this.getAttribute(MongoDBRouterCluster.ANY_ROUTER);
    }

    @Override
    public MongoDBRouter getAnyRunningRouter() {
        return (MongoDBRouter)this.getAttribute(MongoDBRouterCluster.ANY_RUNNING_ROUTER);
    }

    public static class MemberTrackingPolicy
    extends AbstractMembershipTrackingPolicy {
        protected void onEntityEvent(AbstractMembershipTrackingPolicy.EventType type, Entity member) {
            ((MongoDBRouterClusterImpl)this.entity).setAnyRouter();
        }

        protected void onEntityRemoved(Entity member) {
            ((MongoDBRouterClusterImpl)this.entity).setAnyRouter();
        }

        protected void onEntityChange(Entity member) {
            ((MongoDBRouterClusterImpl)this.entity).setAnyRouter();
        }
    }
}

