/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.cassandra;

import com.google.common.reflect.TypeToken;
import java.math.BigInteger;
import java.util.Set;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.location.PortRanges;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.BasicAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.PortAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.database.DatastoreMixins;
import org.apache.brooklyn.entity.java.UsesJavaMXBeans;
import org.apache.brooklyn.entity.java.UsesJmx;
import org.apache.brooklyn.entity.nosql.cassandra.CassandraDatacenter;
import org.apache.brooklyn.entity.nosql.cassandra.CassandraNodeImpl;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.time.Duration;

@Catalog(name="Apache Cassandra Node", description="Cassandra is a highly scalable, eventually consistent, distributed, structured key-value store which provides a ColumnFamily-based data model richer than typical key/value systems", iconUrl="classpath:///cassandra-logo.jpeg")
@ImplementedBy(value=CassandraNodeImpl.class)
public interface CassandraNode
extends DatastoreMixins.DatastoreCommon,
SoftwareProcess,
UsesJmx,
UsesJavaMXBeans,
DatastoreMixins.HasDatastoreUrl,
DatastoreMixins.CanExecuteScript {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"1.2.16");
    @SetFromFlag(value="archiveNameFormat")
    public static final ConfigKey<String> ARCHIVE_DIRECTORY_NAME_FORMAT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.ARCHIVE_DIRECTORY_NAME_FORMAT, (Object)"apache-cassandra-%s");
    @SetFromFlag(value="downloadUrl")
    public static final AttributeSensorAndConfigKey<String, String> DOWNLOAD_URL = ConfigKeys.newSensorAndConfigKeyWithDefault((AttributeSensorAndConfigKey)SoftwareProcess.DOWNLOAD_URL, (Object)"${driver.mirrorUrl}/${version}/apache-cassandra-${version}-bin.tar.gz");
    @SetFromFlag(value="mirrorUrl")
    public static final ConfigKey<String> MIRROR_URL = ConfigKeys.newStringConfigKey((String)"cassandra.install.mirror.url", (String)"URL of mirror", (String)"http://www.mirrorservice.org/sites/ftp.apache.org/cassandra");
    @SetFromFlag(value="tgzUrl")
    public static final ConfigKey<String> TGZ_URL = ConfigKeys.newStringConfigKey((String)"cassandra.install.tgzUrl", (String)"URL of TGZ download file");
    @SetFromFlag(value="clusterName")
    public static final BasicAttributeSensorAndConfigKey<String> CLUSTER_NAME = CassandraDatacenter.CLUSTER_NAME;
    @SetFromFlag(value="snitchName")
    public static final ConfigKey<String> ENDPOINT_SNITCH_NAME = CassandraDatacenter.ENDPOINT_SNITCH_NAME;
    @SetFromFlag(value="gossipPort")
    public static final PortAttributeSensorAndConfigKey GOSSIP_PORT = ConfigKeys.newPortSensorAndConfigKey((String)"cassandra.gossip.port", (String)"Cassandra Gossip communications port", (Object)PortRanges.fromString((String)"7000+"));
    @SetFromFlag(value="sslGgossipPort")
    public static final PortAttributeSensorAndConfigKey SSL_GOSSIP_PORT = ConfigKeys.newPortSensorAndConfigKey((String)"cassandra.ssl-gossip.port", (String)"Cassandra Gossip SSL communications port", (Object)PortRanges.fromString((String)"7001+"));
    @SetFromFlag(value="thriftPort")
    public static final PortAttributeSensorAndConfigKey THRIFT_PORT = ConfigKeys.newPortSensorAndConfigKey((String)"cassandra.thrift.port", (String)"Cassandra Thrift RPC port", (Object)PortRanges.fromString((String)"9160+"));
    @SetFromFlag(value="nativePort")
    public static final PortAttributeSensorAndConfigKey NATIVE_TRANSPORT_PORT = ConfigKeys.newPortSensorAndConfigKey((String)"cassandra.native.port", (String)"Cassandra Native Transport port", (Object)PortRanges.fromString((String)"9042+"));
    @SetFromFlag(value="rmiRegistryPort")
    public static final PortAttributeSensorAndConfigKey RMI_REGISTRY_PORT = ConfigKeys.newPortSensorAndConfigKeyWithDefault((PortAttributeSensorAndConfigKey)UsesJmx.RMI_REGISTRY_PORT, (Object)PortRanges.fromInteger((int)7199));
    public static final ConfigKey<UsesJmx.JmxAgentModes> JMX_AGENT_MODE = ConfigKeys.newConfigKeyWithDefault((ConfigKey)UsesJmx.JMX_AGENT_MODE, (Object)UsesJmx.JmxAgentModes.JMXMP_AND_RMI);
    @SetFromFlag(value="customSnitchJarUrl")
    public static final ConfigKey<String> CUSTOM_SNITCH_JAR_URL = ConfigKeys.newStringConfigKey((String)"cassandra.config.customSnitchUrl", (String)"URL for a jar file to be uploaded (e.g. \"classpath://org/apache/brooklyn/entity/nosql/cassandra/cassandra-multicloud-snitch.jar\"); defaults to null which means nothing to upload", null);
    @SetFromFlag(value="cassandraConfigTemplateUrl")
    public static final ConfigKey<String> CASSANDRA_CONFIG_TEMPLATE_URL = ConfigKeys.newStringConfigKey((String)"cassandra.config.templateUrl", (String)"A URL (in freemarker format) for a cassandra.yaml config file (in freemarker format)", (String)"classpath://org/apache/brooklyn/entity/nosql/cassandra/cassandra-${entity.majorMinorVersion}.yaml");
    @SetFromFlag(value="cassandraConfigFileName")
    public static final ConfigKey<String> CASSANDRA_CONFIG_FILE_NAME = ConfigKeys.newStringConfigKey((String)"cassandra.config.fileName", (String)"Name for the copied config file", (String)"cassandra.yaml");
    @SetFromFlag(value="cassandraRackdcConfigTemplateUrl")
    public static final ConfigKey<String> CASSANDRA_RACKDC_CONFIG_TEMPLATE_URL = ConfigKeys.newStringConfigKey((String)"cassandra.config.rackdc.templateUrl", (String)"Template file (in freemarker format) for the cassandra-rackdc.properties config file", (String)"classpath://org/apache/brooklyn/entity/nosql/cassandra/cassandra-rackdc.properties");
    @SetFromFlag(value="cassandraRackdcConfigFileName")
    public static final ConfigKey<String> CASSANDRA_RACKDC_CONFIG_FILE_NAME = ConfigKeys.newStringConfigKey((String)"cassandra.config.rackdc.fileName", (String)"Name for the copied rackdc config file (used for configuring replication, when a suitable snitch is used)", (String)"cassandra-rackdc.properties");
    @SetFromFlag(value="datacenterName")
    public static final AttributeSensorAndConfigKey<String, String> DATACENTER_NAME = ConfigKeys.newStringSensorAndConfigKey((String)"cassandra.replication.datacenterName", (String)"Datacenter name (used for configuring replication, when a suitable snitch is used)");
    @SetFromFlag(value="rackName")
    public static final AttributeSensorAndConfigKey<String, String> RACK_NAME = ConfigKeys.newStringSensorAndConfigKey((String)"cassandra.replication.rackName", (String)"Rack name (used for configuring replication, when a suitable snitch is used)");
    public static final ConfigKey<Integer> NUM_TOKENS_PER_NODE = ConfigKeys.newIntegerConfigKey((String)"cassandra.numTokensPerNode", (String)"Number of tokens per node; if using vnodes, should set this to a value like 256", (Integer)1);
    @SetFromFlag(value="tokens")
    public static final AttributeSensorAndConfigKey<Set<BigInteger>, Set<BigInteger>> TOKENS = ConfigKeys.newSensorAndConfigKey((TypeToken)new TypeToken<Set<BigInteger>>(){}, (String)"cassandra.tokens", (String)"Cassandra Tokens");
    @SetFromFlag(value="useThriftMonitoring")
    public static final ConfigKey<Boolean> USE_THRIFT_MONITORING = ConfigKeys.newConfigKey((String)"thriftMonitoring.enabled", (String)"Thrift-port monitoring enabled", (Object)Boolean.TRUE);
    public static final AttributeSensor<Integer> PEERS = Sensors.newIntegerSensor((String)"cassandra.peers", (String)"Number of peers in cluster");
    public static final AttributeSensor<Integer> LIVE_NODE_COUNT = Sensors.newIntegerSensor((String)"cassandra.liveNodeCount", (String)"Number of live nodes in cluster");
    public static final AttributeSensor<Long> READ_PENDING = Sensors.newLongSensor((String)"cassandra.read.pending", (String)"Current pending ReadStage tasks");
    public static final AttributeSensor<Integer> READ_ACTIVE = Sensors.newIntegerSensor((String)"cassandra.read.active", (String)"Current active ReadStage tasks");
    public static final AttributeSensor<Long> READ_COMPLETED = Sensors.newLongSensor((String)"cassandra.read.completed", (String)"Total completed ReadStage tasks");
    public static final AttributeSensor<Long> WRITE_PENDING = Sensors.newLongSensor((String)"cassandra.write.pending", (String)"Current pending MutationStage tasks");
    public static final AttributeSensor<Integer> WRITE_ACTIVE = Sensors.newIntegerSensor((String)"cassandra.write.active", (String)"Current active MutationStage tasks");
    public static final AttributeSensor<Long> WRITE_COMPLETED = Sensors.newLongSensor((String)"cassandra.write.completed", (String)"Total completed MutationStage tasks");
    public static final AttributeSensor<Boolean> SERVICE_UP_JMX = Sensors.newBooleanSensor((String)"cassandra.service.jmx.up", (String)"Whether JMX is up for this service");
    public static final AttributeSensor<Long> THRIFT_PORT_LATENCY = Sensors.newLongSensor((String)"cassandra.thrift.latency", (String)"Latency for thrift port connection (ms) or null if down");
    public static final AttributeSensor<Double> READS_PER_SECOND_LAST = Sensors.newDoubleSensor((String)"cassandra.reads.perSec.last", (String)"Reads/sec (last datapoint)");
    public static final AttributeSensor<Double> WRITES_PER_SECOND_LAST = Sensors.newDoubleSensor((String)"cassandra.write.perSec.last", (String)"Writes/sec (last datapoint)");
    public static final AttributeSensor<Double> THRIFT_PORT_LATENCY_IN_WINDOW = Sensors.newDoubleSensor((String)"cassandra.thrift.latency.windowed", (String)"Latency for thrift port (ms, averaged over time window)");
    public static final AttributeSensor<Double> READS_PER_SECOND_IN_WINDOW = Sensors.newDoubleSensor((String)"cassandra.reads.perSec.windowed", (String)"Reads/sec (over time window)");
    public static final AttributeSensor<Double> WRITES_PER_SECOND_IN_WINDOW = Sensors.newDoubleSensor((String)"cassandra.writes.perSec.windowed", (String)"Writes/sec (over time window)");
    public static final ConfigKey<Set<Entity>> INITIAL_SEEDS = ConfigKeys.newConfigKey(Set.class, (String)"cassandra.cluster.seeds.initial", (String)"List of cluster nodes to seed this node");
    public static final ConfigKey<Duration> START_TIMEOUT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)BrooklynConfigKeys.START_TIMEOUT, (Object)Duration.FIVE_MINUTES);
    public static final ConfigKey<String> LISTEN_ADDRESS_SENSOR = ConfigKeys.newStringConfigKey((String)"cassandra.listenAddressSensor", (String)"sensor name from which to take the listen address; default (null) is a smart lookup");
    public static final ConfigKey<String> BROADCAST_ADDRESS_SENSOR = ConfigKeys.newStringConfigKey((String)"cassandra.broadcastAddressSensor", (String)"sensor name from which to take the broadcast address; default (null) is a smart lookup");
    public static final ConfigKey<String> RPC_ADDRESS_SENSOR = ConfigKeys.newStringConfigKey((String)"cassandra.rpcAddressSensor", (String)"sensor name from which to take the RPC address; default (null) is 0.0.0.0");
    public static final Effector<String> EXECUTE_SCRIPT = CassandraDatacenter.EXECUTE_SCRIPT;

    public String getMajorMinorVersion();

    public Integer getGossipPort();

    public Integer getSslGossipPort();

    public Integer getThriftPort();

    public Integer getNativeTransportPort();

    public String getClusterName();

    public String getListenAddress();

    public String getBroadcastAddress();

    public String getRpcAddress();

    public String getSeeds();

    public String getPrivateIp();

    public String getPublicIp();

    public int getNumTokensPerNode();

    public Set<BigInteger> getTokens();

    public String getTokensAsString();

    public void setToken(String var1);

    public String executeScript(String var1);
}

