/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.cassandra;

import com.google.common.base.Function;
import com.google.common.collect.Multimap;
import com.google.common.reflect.TypeToken;
import java.util.Set;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.annotation.Effector;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.MethodEffector;
import org.apache.brooklyn.entity.group.DynamicFabric;
import org.apache.brooklyn.entity.nosql.cassandra.CassandraDatacenter;
import org.apache.brooklyn.entity.nosql.cassandra.CassandraFabricImpl;

@Catalog(name="Apache Cassandra Database Fabric", description="Cassandra is a highly scalable, eventually consistent, distributed, structured key-value store which provides a ColumnFamily-based data model richer than typical key/value systems", iconUrl="classpath:///cassandra-logo.jpeg")
@ImplementedBy(value=CassandraFabricImpl.class)
public interface CassandraFabric
extends DynamicFabric {
    public static final ConfigKey<Integer> INITIAL_QUORUM_SIZE = ConfigKeys.newIntegerConfigKey((String)"fabric.initial.quorumSize", (String)"Initial fabric quorum size - number of initial nodes that must have been successfully started to report success (if less than 0, then use a value based on INITIAL_SIZE of clusters)", (Integer)-1);
    public static final ConfigKey<Function<Location, String>> DATA_CENTER_NAMER = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Function<Location, String>>(){}, (String)"cassandra.fabric.datacenter.namer", (String)"Function used to provide the cassandra.replication.datacenterName for a given location");
    public static final int DEFAULT_SEED_QUORUM = 5;
    public static final AttributeSensor<Multimap<String, Entity>> DATACENTER_USAGE = CassandraDatacenter.DATACENTER_USAGE;
    public static final AttributeSensor<Set<String>> DATACENTERS = CassandraDatacenter.DATACENTERS;
    public static final AttributeSensor<Set<Entity>> CURRENT_SEEDS = CassandraDatacenter.CURRENT_SEEDS;
    public static final AttributeSensor<Boolean> HAS_PUBLISHED_SEEDS = CassandraDatacenter.HAS_PUBLISHED_SEEDS;
    public static final AttributeSensor<String> HOSTNAME = CassandraDatacenter.HOSTNAME;
    public static final AttributeSensor<Integer> THRIFT_PORT = CassandraDatacenter.THRIFT_PORT;
    public static final MethodEffector<Void> UPDATE = new MethodEffector(CassandraFabric.class, "update");

    @Effector(description="Updates the cluster members")
    public void update();
}

