/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.util.json;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import java.io.NotSerializableException;
import java.net.URI;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.core.test.entity.LocalManagementContextForTests;
import org.apache.brooklyn.core.test.entity.TestApplication;
import org.apache.brooklyn.core.test.entity.TestEntity;
import org.apache.brooklyn.rest.BrooklynRestApiLauncher;
import org.apache.brooklyn.rest.util.json.BrooklynJacksonSerializerTest;
import org.apache.brooklyn.util.http.HttpTool;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BrooklynJacksonSerializerIntegrationTest {
    private static final Logger log = LoggerFactory.getLogger(BrooklynJacksonSerializerIntegrationTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"Integration"})
    public void testWithAcceptsPlainText() throws Exception {
        LocalManagementContext mgmt = LocalManagementContextForTests.newInstance();
        Server server = null;
        try {
            server = BrooklynRestApiLauncher.launcher().managementContext((ManagementContext)mgmt).start();
            HttpClient client = HttpTool.httpClientBuilder().build();
            TestApplication app = TestApplication.Factory.newManagedInstanceForTests((ManagementContext)mgmt);
            String serverAddress = "http://localhost:" + ((NetworkConnector)server.getConnectors()[0]).getLocalPort();
            String appUrl = serverAddress + "/v1/applications/" + app.getId();
            String entityUrl = appUrl + "/entities/" + app.getId();
            URI configUri = new URIBuilder(entityUrl + "/config/" + TestEntity.CONF_OBJECT.getName()).addParameter("raw", "true").build();
            app.config().set((ConfigKey)TestEntity.CONF_OBJECT, (Object)mgmt);
            String content = this.get(client, configUri, (Map<String, String>)ImmutableMap.of((Object)"Accept", (Object)"text/plain"));
            log.info("CONFIG MGMT is:\n" + content);
            Assert.assertEquals((String)content, (String)mgmt.toString(), (String)("content=" + content));
        }
        finally {
            try {
                if (server != null) {
                    server.stop();
                }
            }
            catch (Exception e) {
                log.warn("failed to stop server: " + e);
            }
            Entities.destroyAll((ManagementContext)mgmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"Integration"})
    public void testWithLauncherSerializingListsContainingEntitiesAndOtherComplexStuff() throws Exception {
        LocalManagementContext mgmt = LocalManagementContextForTests.newInstance();
        Server server = null;
        try {
            server = BrooklynRestApiLauncher.launcher().managementContext((ManagementContext)mgmt).start();
            HttpClient client = HttpTool.httpClientBuilder().build();
            TestApplication app = TestApplication.Factory.newManagedInstanceForTests((ManagementContext)mgmt);
            String serverAddress = "http://localhost:" + ((NetworkConnector)server.getConnectors()[0]).getLocalPort();
            String appUrl = serverAddress + "/v1/applications/" + app.getId();
            String entityUrl = appUrl + "/entities/" + app.getId();
            URI configUri = new URIBuilder(entityUrl + "/config/" + TestEntity.CONF_OBJECT.getName()).addParameter("raw", "true").build();
            app.config().set((ConfigKey)TestEntity.CONF_OBJECT, (Object)mgmt);
            String content = this.get(client, configUri, (Map<String, String>)ImmutableMap.of((Object)"Accept", (Object)"application/json"));
            log.info("CONFIG MGMT is:\n" + content);
            Map values = (Map)new Gson().fromJson(content, Map.class);
            Assert.assertEquals((Object)values, (Object)ImmutableMap.of((Object)"type", (Object)LocalManagementContextForTests.class.getCanonicalName()), (String)("values=" + values));
            content = this.get(client, entityUrl, (Map<String, String>)ImmutableMap.of((Object)"Accept", (Object)"application/json"));
            log.info("ENTITY is: \n" + content);
            values = (Map)new Gson().fromJson(content, Map.class);
            Assert.assertTrue((values.size() >= 3 ? 1 : 0) != 0, (String)("Map is too small: " + values));
            Assert.assertTrue((values.size() <= 6 ? 1 : 0) != 0, (String)("Map is too big: " + values));
            Assert.assertEquals(values.get("type"), (Object)TestApplication.class.getCanonicalName(), (String)("values=" + values));
            Assert.assertNotNull(values.get("links"), (String)("Map should have contained links: values=" + values));
            app.config().set((ConfigKey)TestEntity.CONF_OBJECT, (Object)app);
            content = this.get(client, configUri, (Map<String, String>)ImmutableMap.of((Object)"Accept", (Object)"application/json"));
            log.info("CONFIG ENTITY is:\n" + content);
            values = (Map)new Gson().fromJson(content, Map.class);
            Assert.assertEquals((Object)values, (Object)ImmutableMap.of((Object)"type", (Object)Entity.class.getCanonicalName(), (Object)"id", (Object)app.getId()), (String)("values=" + values));
            BrooklynJacksonSerializerTest.SelfRefNonSerializableClass angry = new BrooklynJacksonSerializerTest.SelfRefNonSerializableClass();
            app.config().set((ConfigKey)TestEntity.CONF_OBJECT, (Object)angry);
            content = this.get(client, configUri, (Map<String, String>)ImmutableMap.of((Object)"Accept", (Object)"application/json"));
            log.info("CONFIG ANGRY is:\n" + content);
            this.assertErrorObjectMatchingToString(content, angry);
            app.config().set((ConfigKey)TestEntity.CONF_OBJECT, (Object)server);
            content = this.get(client, configUri, (Map<String, String>)ImmutableMap.of((Object)"Accept", (Object)"application/json"));
            log.info("CONFIG SERVER is:\n" + content);
            this.assertErrorObjectMatchingToString(content, server);
            Assert.assertTrue((boolean)content.contains(NotSerializableException.class.getCanonicalName()), (String)"server should have contained things which are not serializable");
            Assert.assertTrue((content.length() < 1024 ? 1 : 0) != 0, (String)("content should not have been very long; instead was: " + content.length()));
        }
        finally {
            try {
                if (server != null) {
                    server.stop();
                }
            }
            catch (Exception e) {
                log.warn("failed to stop server: " + e);
            }
            Entities.destroyAll((ManagementContext)mgmt);
        }
    }

    private void assertErrorObjectMatchingToString(String content, Object expected) {
        Object value = new Gson().fromJson(content, Object.class);
        Assert.assertTrue((boolean)(value instanceof Map), (String)("Expected map, got: " + value));
        Assert.assertEquals(((Map)value).get("toString"), (Object)expected.toString());
    }

    private String get(HttpClient client, String uri, Map<String, String> headers) {
        return this.get(client, URI.create(uri), headers);
    }

    private String get(HttpClient client, URI uri, Map<String, String> headers) {
        return HttpTool.httpGet((HttpClient)client, (URI)uri, headers).getContentAsString();
    }
}

