/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.util;

import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.rest.util.ShutdownHandler;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerStoppingShutdownHandler
implements ShutdownHandler {
    private static final Logger log = LoggerFactory.getLogger(ServerStoppingShutdownHandler.class);
    private final ManagementContext mgmt;
    private Server server;

    public ServerStoppingShutdownHandler(ManagementContext mgmt) {
        this.mgmt = mgmt;
    }

    public void onShutdownRequest() {
        log.info("Shutting down server (when running in rest-api dev mode, using background thread)");
        new Thread(new Runnable(){

            @Override
            public void run() {
                Time.sleep((Duration)Duration.millis((Number)250));
                log.debug("Shutting down server in background thread, closing " + ServerStoppingShutdownHandler.this.server + " and " + ServerStoppingShutdownHandler.this.mgmt);
                if (ServerStoppingShutdownHandler.this.server != null) {
                    try {
                        ServerStoppingShutdownHandler.this.server.stop();
                        ServerStoppingShutdownHandler.this.server.join();
                    }
                    catch (Exception e) {
                        log.debug("Stopping server gave an error (not usually a concern): " + e);
                    }
                }
                if (ServerStoppingShutdownHandler.this.mgmt instanceof ManagementContextInternal) {
                    ((ManagementContextInternal)ServerStoppingShutdownHandler.this.mgmt).terminate();
                }
            }
        }).start();
    }

    public void setServer(Server server) {
        this.server = server;
    }
}

