/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.resources;

import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.rest.BrooklynRestApiLauncher;
import org.apache.brooklyn.rest.BrooklynRestApiLauncherTestFixture;
import org.apache.brooklyn.rest.security.provider.TestSecurityProvider;
import org.apache.brooklyn.util.http.HttpAsserts;
import org.apache.brooklyn.util.http.HttpTool;
import org.apache.brooklyn.util.http.HttpToolResponse;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.eclipse.jetty.server.Server;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ServerResourceIntegrationTest
extends BrooklynRestApiLauncherTestFixture {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"Integration"})
    public void testSecurityProviderUpdatesWhenPropertiesReloaded() {
        BrooklynProperties brooklynProperties = BrooklynProperties.Factory.newEmpty();
        brooklynProperties.put((Object)"brooklyn.webconsole.security.users", (Object)"admin");
        brooklynProperties.put((Object)"brooklyn.webconsole.security.user.admin.password", (Object)"mypassword");
        UsernamePasswordCredentials defaultCredential = new UsernamePasswordCredentials("admin", "mypassword");
        LocalManagementContext mgmt = new LocalManagementContext(brooklynProperties);
        try {
            Server server = this.useServerForTest(BrooklynRestApiLauncher.launcher().managementContext((ManagementContext)mgmt).withoutJsgui().securityProvider(TestSecurityProvider.class).start());
            String baseUri = ServerResourceIntegrationTest.getBaseUriRest(server);
            URI uri = URI.create(this.getBaseUriRest() + "server/properties/reload");
            Map args = Collections.emptyMap();
            HttpToolResponse response = HttpTool.httpPost((HttpClient)HttpTool.httpClientBuilder().uri(baseUri).build(), (URI)uri, args, args);
            Assert.assertEquals((int)response.getResponseCode(), (int)401);
            response = HttpTool.httpPost((HttpClient)HttpTool.httpClientBuilder().uri(baseUri).credentials((Credentials)defaultCredential).build(), (URI)uri, args, args);
            Assert.assertEquals((int)response.getResponseCode(), (int)401);
            response = HttpTool.httpPost((HttpClient)HttpTool.httpClientBuilder().uri(baseUri).credentials((Credentials)TestSecurityProvider.CREDENTIAL).build(), (URI)uri, args, args);
            HttpAsserts.assertHealthyStatusCode((int)response.getResponseCode());
            response = HttpTool.httpPost((HttpClient)HttpTool.httpClientBuilder().uri(baseUri).credentials((Credentials)defaultCredential).build(), (URI)uri, args, args);
            HttpAsserts.assertHealthyStatusCode((int)response.getResponseCode());
            response = HttpTool.httpPost((HttpClient)HttpTool.httpClientBuilder().uri(baseUri).credentials((Credentials)TestSecurityProvider.CREDENTIAL).build(), (URI)uri, args, args);
            Assert.assertEquals((int)response.getResponseCode(), (int)401);
        }
        finally {
            ((ManagementContextInternal)mgmt).terminate();
        }
    }

    @Test(groups={"Integration"})
    public void testGetUser() throws Exception {
        Server server = this.useServerForTest(BrooklynRestApiLauncher.launcher().securityProvider(TestSecurityProvider.class).withoutJsgui().start());
        Assert.assertEquals((String)this.getServerUser(server), (String)"test");
    }

    private String getServerUser(Server server) throws Exception {
        HttpClient client = HttpTool.httpClientBuilder().uri(ServerResourceIntegrationTest.getBaseUriRest(server)).credentials((Credentials)TestSecurityProvider.CREDENTIAL).build();
        HttpToolResponse response = HttpTool.httpGet((HttpClient)client, (URI)URI.create(ServerResourceIntegrationTest.getBaseUriRest(server) + "server/user"), (Map)ImmutableMap.of());
        HttpAsserts.assertHealthyStatusCode((int)response.getResponseCode());
        return response.getContentAsString();
    }
}

