/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.entitlement;

import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementClass;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementContext;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.test.entity.TestEntity;
import org.apache.brooklyn.rest.entitlement.AbstractRestApiEntitlementsTest;
import org.apache.brooklyn.rest.entitlement.StaticDelegatingEntitlementManager;
import org.apache.brooklyn.test.Asserts;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class SensorApiEntitlementsTest
extends AbstractRestApiEntitlementsTest {
    @Test(groups={"Integration"})
    public void testGet() throws Exception {
        this.entity.sensors().set(TestEntity.NAME, (Object)"myval");
        String sensorName = TestEntity.NAME.getName();
        String path = "/v1/applications/" + this.app.getId() + "/entities/" + this.entity.getId() + "/sensors/" + sensorName;
        String val = "\"myval\"";
        Assert.assertEquals((String)this.httpGet("myRoot", path), (String)val);
        Assert.assertEquals((String)this.httpGet("myReadonly", path), (String)val);
        this.assert404("myMinimal", path);
        this.assert404("unrecognisedUser", path);
        StaticDelegatingEntitlementManager.setDelegate(new SeeSelectiveSensor((Entity)this.entity, sensorName));
        Assert.assertEquals((String)this.httpGet("myCustom", path), (String)val);
        StaticDelegatingEntitlementManager.setDelegate(new SeeSelectiveSensor((Entity)this.entity, "differentConfName"));
        this.assertForbidden("myCustom", path);
    }

    @Test(groups={"Integration"})
    public void testCurrentState() throws Exception {
        this.entity.sensors().set(TestEntity.NAME, (Object)"myval");
        String path = "/v1/applications/" + this.app.getId() + "/entities/" + this.entity.getId() + "/sensors/current-state";
        String sensorName = TestEntity.NAME.getName();
        String regex = ".*" + sensorName + ".*myval.*";
        Asserts.assertStringMatchesRegex((String)this.httpGet("myRoot", path), (String)regex, (String[])new String[0]);
        Asserts.assertStringMatchesRegex((String)this.httpGet("myReadonly", path), (String)regex, (String[])new String[0]);
        this.assert404("myMinimal", path);
        this.assert404("unrecognisedUser", path);
        StaticDelegatingEntitlementManager.setDelegate(new SeeSelectiveSensor((Entity)this.entity, sensorName));
        Asserts.assertStringMatchesRegex((String)this.httpGet("myCustom", path), (String)regex, (String[])new String[0]);
        StaticDelegatingEntitlementManager.setDelegate(new SeeSelectiveSensor((Entity)this.entity, "differentSensorName"));
        String resp = this.httpGet("myCustom", path);
        Assert.assertFalse((boolean)resp.matches(regex), (String)("resp=" + resp));
    }

    public static class SeeSelectiveSensor
    implements EntitlementManager {
        private final Entity entity;
        private final String regex;

        public SeeSelectiveSensor(Entity entity, String regex) {
            this.entity = entity;
            this.regex = regex;
        }

        public <T> boolean isEntitled(EntitlementContext context, EntitlementClass<T> entitlementClass, T entitlementClassArgument) {
            String type = entitlementClass.entitlementClassIdentifier();
            if (Entitlements.SEE_SENSOR.entitlementClassIdentifier().equals(type)) {
                Entitlements.EntityAndItem entityAndItem = (Entitlements.EntityAndItem)entitlementClassArgument;
                return this.entity.equals(entityAndItem.getEntity()) && ((String)entityAndItem.getItem()).matches(this.regex);
            }
            return true;
        }
    }
}

