/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.entitlement;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.ExecutionManager;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementClass;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementContext;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.test.entity.TestApplication;
import org.apache.brooklyn.entity.machine.MachineEntity;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessStreamsTest;
import org.apache.brooklyn.rest.entitlement.AbstractRestApiEntitlementsTest;
import org.apache.brooklyn.rest.entitlement.StaticDelegatingEntitlementManager;
import org.apache.brooklyn.util.core.task.TaskPredicates;
import org.apache.brooklyn.util.text.StringPredicates;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class ActivityApiEntitlementsTest
extends AbstractRestApiEntitlementsTest {
    protected MachineEntity machineEntity;
    protected Task<?> subTask;
    protected Map<String, String> streams;

    @Override
    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        super.setUp();
        this.machineEntity = (MachineEntity)this.app.addChild(((EntitySpec)EntitySpec.create(MachineEntity.class).configure(BrooklynConfigKeys.SKIP_ON_BOX_BASE_DIR_RESOLUTION, (Object)true)).location(TestApplication.LOCALHOST_PROVISIONER_SPEC));
        this.machineEntity.start((Collection)ImmutableList.of());
        this.machineEntity.execCommand("echo myval");
        Set tasks = BrooklynTaskTags.getTasksInEntityContext((ExecutionManager)this.mgmt.getExecutionManager(), (Entity)this.machineEntity);
        String taskNameRegex = "ssh: echo myval";
        this.streams = Maps.newLinkedHashMap();
        this.subTask = (Task)AbstractSoftwareProcessStreamsTest.findTaskOrSubTask((Iterable)tasks, (Predicate)TaskPredicates.displayNameSatisfies((Predicate)StringPredicates.matchesRegex((String)taskNameRegex))).get();
        for (String streamId : ImmutableList.of((Object)"stdin", (Object)"stdout", (Object)"stderr")) {
            this.streams.put(streamId, AbstractSoftwareProcessStreamsTest.getStreamOrFail(this.subTask, (String)streamId));
        }
    }

    @Test(groups={"Integration"})
    public void testGetTask() throws Exception {
        String path = "/v1/activities/" + this.subTask.getId();
        this.assertPermitted("myRoot", path);
        this.assertPermitted("myReadonly", path);
        this.assertForbidden("myMinimal", path);
        this.assertForbidden("unrecognisedUser", path);
    }

    @Test(groups={"Integration"})
    public void testGetStream() throws Exception {
        String pathPrefix = "/v1/activities/" + this.subTask.getId() + "/stream/";
        for (Map.Entry<String, String> entry : this.streams.entrySet()) {
            String streamId = entry.getKey();
            String expectedStream = entry.getValue();
            Assert.assertEquals((String)this.httpGet("myRoot", pathPrefix + streamId), (String)expectedStream);
            Assert.assertEquals((String)this.httpGet("myReadonly", pathPrefix + streamId), (String)expectedStream);
            this.assertForbidden("myMinimal", pathPrefix + streamId);
            this.assertForbidden("unrecognisedUser", pathPrefix + streamId);
            StaticDelegatingEntitlementManager.setDelegate(new SeeSelectiveStreams(streamId));
            Assert.assertEquals((String)this.httpGet("myCustom", pathPrefix + streamId), (String)expectedStream);
            StaticDelegatingEntitlementManager.setDelegate(new SeeSelectiveStreams("differentStreamId"));
            this.assertForbidden("myCustom", pathPrefix + streamId);
        }
    }

    public static class SeeSelectiveStreams
    implements EntitlementManager {
        private final String regex;

        public SeeSelectiveStreams(String regex) {
            this.regex = regex;
        }

        public <T> boolean isEntitled(EntitlementContext context, EntitlementClass<T> entitlementClass, T entitlementClassArgument) {
            String type = entitlementClass.entitlementClassIdentifier();
            if (Entitlements.SEE_ACTIVITY_STREAMS.entitlementClassIdentifier().equals(type)) {
                Entitlements.TaskAndItem pair = (Entitlements.TaskAndItem)entitlementClassArgument;
                return ((String)pair.getItem()).matches(this.regex);
            }
            return true;
        }
    }
}

