/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.entitlement;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.mgmt.entitlement.PerUserEntitlementManager;
import org.apache.brooklyn.core.test.entity.LocalManagementContextForTests;
import org.apache.brooklyn.core.test.entity.TestApplication;
import org.apache.brooklyn.core.test.entity.TestEntity;
import org.apache.brooklyn.rest.BrooklynRestApiLauncher;
import org.apache.brooklyn.rest.BrooklynRestApiLauncherTestFixture;
import org.apache.brooklyn.rest.entitlement.AuthenticateAnyoneSecurityProvider;
import org.apache.brooklyn.rest.entitlement.StaticDelegatingEntitlementManager;
import org.apache.brooklyn.util.http.HttpAsserts;
import org.apache.brooklyn.util.http.HttpTool;
import org.apache.brooklyn.util.http.HttpToolResponse;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public abstract class AbstractRestApiEntitlementsTest
extends BrooklynRestApiLauncherTestFixture {
    protected ManagementContext mgmt;
    protected TestApplication app;
    protected TestEntity entity;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        BrooklynProperties props = BrooklynProperties.Factory.newEmpty();
        props.put((Object)Entitlements.GLOBAL_ENTITLEMENT_MANAGER.getName(), (Object)PerUserEntitlementManager.class.getName());
        props.put((Object)"brooklyn.entitlements.perUser.myRoot", (Object)"root");
        props.put((Object)"brooklyn.entitlements.perUser.myReadonly", (Object)"readonly");
        props.put((Object)"brooklyn.entitlements.perUser.myMinimal", (Object)"minimal");
        props.put((Object)"brooklyn.entitlements.perUser.myCustom", (Object)StaticDelegatingEntitlementManager.class.getName());
        this.mgmt = LocalManagementContextForTests.builder((boolean)true).useProperties(props).build();
        this.app = (TestApplication)this.mgmt.getEntityManager().createEntity((EntitySpec)EntitySpec.create(TestApplication.class).child(EntitySpec.create(TestEntity.class)).configure(TestEntity.CONF_NAME, (Object)"myname"));
        this.entity = (TestEntity)Iterables.getOnlyElement((Iterable)this.app.getChildren());
        this.useServerForTest(BrooklynRestApiLauncher.launcher().managementContext(this.mgmt).forceUseOfDefaultCatalogWithJavaClassPath(true).securityProvider(AuthenticateAnyoneSecurityProvider.class).start());
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.mgmt != null) {
            Entities.destroyAll((ManagementContext)this.mgmt);
        }
    }

    protected HttpClient newClient(String user) throws Exception {
        return HttpTool.httpClientBuilder().uri(this.getBaseUriRest()).credentials((Credentials)new UsernamePasswordCredentials(user, "ignoredPassword")).build();
    }

    protected String httpGet(String user, String path) throws Exception {
        HttpToolResponse response = HttpTool.httpGet((HttpClient)this.newClient(user), (URI)URI.create(this.getBaseUriRest()).resolve(path), (Map)ImmutableMap.of());
        Assert.assertTrue((boolean)HttpAsserts.isHealthyStatusCode((int)response.getResponseCode()), (String)("code=" + response.getResponseCode() + "; reason=" + response.getReasonPhrase()));
        return response.getContentAsString();
    }

    protected String assertPermitted(String user, String path) throws Exception {
        return this.httpGet(user, path);
    }

    protected void assertForbidden(String user, String path) throws Exception {
        HttpToolResponse response = HttpTool.httpGet((HttpClient)this.newClient(user), (URI)URI.create(this.getBaseUriRest()).resolve(path), (Map)ImmutableMap.of());
        Assert.assertEquals((int)response.getResponseCode(), (int)403, (String)("code=" + response.getResponseCode() + "; reason=" + response.getReasonPhrase() + "; content=" + response.getContentAsString()));
    }

    protected void assert404(String user, String path) throws Exception {
        HttpToolResponse response = HttpTool.httpGet((HttpClient)this.newClient(user), (URI)URI.create(this.getBaseUriRest()).resolve(path), (Map)ImmutableMap.of());
        Assert.assertEquals((int)response.getResponseCode(), (int)404, (String)("code=" + response.getResponseCode() + "; reason=" + response.getReasonPhrase() + "; content=" + response.getContentAsString()));
    }
}

