/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.EntityManager;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.ha.HighAvailabilityMode;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeState;
import org.apache.brooklyn.camp.brooklyn.BrooklynCampPlatformLauncherNoServer;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.core.mgmt.rebind.RebindTestUtils;
import org.apache.brooklyn.entity.stock.BasicApplication;
import org.apache.brooklyn.rest.BrooklynRestApiLauncher;
import org.apache.brooklyn.rest.BrooklynRestApiLauncherTestFixture;
import org.apache.brooklyn.rest.security.provider.AnyoneSecurityProvider;
import org.apache.brooklyn.test.Asserts;
import org.apache.brooklyn.util.http.HttpTool;
import org.apache.brooklyn.util.http.HttpToolResponse;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.time.Duration;
import org.apache.http.client.HttpClient;
import org.eclipse.jetty.server.Server;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class HaMasterCheckFilterTest
extends BrooklynRestApiLauncherTestFixture {
    private static final Duration TIMEOUT = Duration.THIRTY_SECONDS;
    private File mementoDir;
    private ManagementContext writeMgmt;
    private ManagementContext readMgmt;
    private String appId;
    private Server server;
    private HttpClient client;

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.server.stop();
        Entities.destroyAll((ManagementContext)this.writeMgmt);
        Entities.destroyAll((ManagementContext)this.readMgmt);
        Os.deleteRecursively((File)this.mementoDir);
    }

    @Test(groups={"Integration"})
    public void testEntitiesExistOnDisabledHA() throws Exception {
        this.initHaCluster(HighAvailabilityMode.DISABLED, HighAvailabilityMode.DISABLED);
        this.assertReadIsMaster();
        this.assertEntityExists(new ReturnCodeNotRetry());
    }

    @Test(groups={"Integration"})
    public void testEntitiesExistOnMasterPromotion() throws Exception {
        this.initHaCluster(HighAvailabilityMode.AUTO, HighAvailabilityMode.AUTO);
        this.assertEntityNotFound(new ReturnCodeNotRetry());
        this.stopWriteNode();
        this.assertEntityExists(new ReturnCodeNotRetryAndNodeIsMaster());
        this.assertReadIsMaster();
    }

    @Test(groups={"Integration"})
    public void testEntitiesExistOnHotStandbyAndPromotion() throws Exception {
        this.initHaCluster(HighAvailabilityMode.AUTO, HighAvailabilityMode.HOT_STANDBY);
        this.assertEntityExists(new ReturnCodeNotRetry());
        this.stopWriteNode();
        this.assertEntityExists(new ReturnCodeNotRetryAndNodeIsMaster());
        this.assertReadIsMaster();
    }

    @Test(groups={"Integration"})
    public void testEntitiesExistOnHotBackup() throws Exception {
        this.initHaCluster(HighAvailabilityMode.AUTO, HighAvailabilityMode.HOT_BACKUP);
        Asserts.continually((Supplier)new ReturnCodeSupplier(), (Predicate)Predicates.or((Predicate)Predicates.equalTo((Object)200), (Predicate)Predicates.equalTo((Object)403)), (Duration)Duration.THIRTY_SECONDS, null, null);
    }

    private HttpClient getClient(Server server) {
        HttpClient client = HttpTool.httpClientBuilder().uri(HaMasterCheckFilterTest.getBaseUriRest(server)).build();
        return client;
    }

    private int getAppResponseCode() {
        HttpToolResponse response = HttpTool.httpGet((HttpClient)this.client, (URI)URI.create(this.getBaseUriRest() + "applications/" + this.appId), (Map)ImmutableMap.of());
        return response.getResponseCode();
    }

    private String createApp(ManagementContext mgmt) {
        EntityManager entityMgr = mgmt.getEntityManager();
        Entity app = entityMgr.createEntity(EntitySpec.create(BasicApplication.class));
        entityMgr.manage(app);
        return app.getId();
    }

    private ManagementContext createManagementContext(File mementoDir, HighAvailabilityMode mode) {
        LocalManagementContext mgmt = RebindTestUtils.managementContextBuilder((File)mementoDir, (ClassLoader)this.getClass().getClassLoader()).persistPeriodMillis(1L).forLive(false).emptyCatalog(true).buildUnstarted();
        if (mode == HighAvailabilityMode.DISABLED) {
            mgmt.getHighAvailabilityManager().disabled();
        } else {
            mgmt.getHighAvailabilityManager().start(mode);
        }
        new BrooklynCampPlatformLauncherNoServer().useManagementContext((ManagementContext)mgmt).launch();
        return mgmt;
    }

    private void initHaCluster(HighAvailabilityMode writeMode, HighAvailabilityMode readMode) throws InterruptedException, TimeoutException {
        this.mementoDir = Os.newTempDir(this.getClass());
        this.writeMgmt = this.createManagementContext(this.mementoDir, writeMode);
        this.appId = this.createApp(this.writeMgmt);
        this.writeMgmt.getRebindManager().waitForPendingComplete(TIMEOUT, true);
        this.readMgmt = readMode == HighAvailabilityMode.DISABLED ? this.writeMgmt : this.createManagementContext(this.mementoDir, readMode);
        this.server = this.useServerForTest(BrooklynRestApiLauncher.launcher().managementContext(this.readMgmt).securityProvider(AnyoneSecurityProvider.class).forceUseOfDefaultCatalogWithJavaClassPath(true).withoutJsgui().disableHighAvailability(false).start());
        this.client = this.getClient(this.server);
    }

    private void assertEntityExists(Callable<Integer> c) {
        Assert.assertEquals((int)((Integer)Asserts.succeedsEventually(c)), (int)200);
    }

    private void assertEntityNotFound(Callable<Integer> c) {
        Assert.assertEquals((int)((Integer)Asserts.succeedsEventually(c)), (int)404);
    }

    private void assertReadIsMaster() {
        Assert.assertEquals((Object)this.readMgmt.getHighAvailabilityManager().getNodeState(), (Object)ManagementNodeState.MASTER);
    }

    private void stopWriteNode() {
        this.writeMgmt.getHighAvailabilityManager().stop();
    }

    private class ReturnCodeSupplier
    implements Supplier<Integer> {
        private ReturnCodeSupplier() {
        }

        public Integer get() {
            return HaMasterCheckFilterTest.this.getAppResponseCode();
        }
    }

    private class ReturnCodeNotRetryAndNodeIsMaster
    extends ReturnCodeNotRetry {
        private ReturnCodeNotRetryAndNodeIsMaster() {
        }

        @Override
        public Integer call() {
            ManagementNodeState state = HaMasterCheckFilterTest.this.readMgmt.getHighAvailabilityManager().getNodeState();
            if (state != ManagementNodeState.MASTER) {
                throw new RuntimeException("Not master yet " + state);
            }
            return super.call();
        }
    }

    private class ReturnCodeNotRetry
    implements Callable<Integer> {
        private ReturnCodeNotRetry() {
        }

        @Override
        public Integer call() {
            int retCode = HaMasterCheckFilterTest.this.getAppResponseCode();
            if (retCode == 403) {
                throw new RuntimeException("Not ready, retry. Response - " + retCode);
            }
            return retCode;
        }
    }
}

