/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest;

import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.core.server.BrooklynServerConfig;
import org.apache.brooklyn.core.server.BrooklynServiceAttributes;
import org.apache.brooklyn.rest.BrooklynRestApiLauncher;
import org.apache.brooklyn.rest.BrooklynWebConfig;
import org.apache.brooklyn.rest.security.provider.AnyoneSecurityProvider;
import org.apache.brooklyn.util.core.osgi.Compat;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.reflections.util.ClasspathHelper;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;

public abstract class BrooklynRestApiLauncherTestFixture {
    Server server = null;

    @AfterMethod(alwaysRun=true)
    public void stopServer() throws Exception {
        if (this.server != null) {
            ManagementContext mgmt = BrooklynRestApiLauncherTestFixture.getManagementContextFromJettyServerAttributes(this.server);
            this.server.stop();
            if (mgmt != null) {
                Entities.destroyAll((ManagementContext)mgmt);
            }
            this.server = null;
        }
    }

    protected Server newServer() {
        try {
            Server server = BrooklynRestApiLauncher.launcher().forceUseOfDefaultCatalogWithJavaClassPath(true).securityProvider(AnyoneSecurityProvider.class).start();
            return server;
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    protected Server useServerForTest(Server server) {
        if (this.server != null) {
            Assert.fail((String)("Test only meant for single server; already have " + this.server + " when checking " + server));
        } else {
            this.server = server;
        }
        return server;
    }

    public static String getBaseUri(Server server) {
        return BrooklynRestApiLauncherTestFixture.getBaseUriHostAndPost(server);
    }

    protected String getBaseUriHostAndPost() {
        return BrooklynRestApiLauncherTestFixture.getBaseUriHostAndPost(this.server);
    }

    public static String getBaseUriHostAndPost(Server server) {
        return "http://localhost:" + ((NetworkConnector)server.getConnectors()[0]).getLocalPort();
    }

    protected String getBaseUriRest() {
        return BrooklynRestApiLauncherTestFixture.getBaseUriRest(this.server);
    }

    public static String getBaseUriRest(Server server) {
        return BrooklynRestApiLauncherTestFixture.getBaseUriHostAndPost(server) + "/v1/";
    }

    public static void forceUseOfDefaultCatalogWithJavaClassPath(Server server) {
        ManagementContext mgmt = BrooklynRestApiLauncherTestFixture.getManagementContextFromJettyServerAttributes(server);
        BrooklynRestApiLauncherTestFixture.forceUseOfDefaultCatalogWithJavaClassPath(mgmt);
    }

    public static void forceUseOfDefaultCatalogWithJavaClassPath(ManagementContext manager) {
        ((BrooklynProperties)manager.getConfig()).put(BrooklynServerConfig.BROOKLYN_CATALOG_URL, (Object)"classpath://brooklyn/scanning.catalog.bom");
        ((LocalManagementContext)manager).setBaseClassPathForScanning((Iterable)ClasspathHelper.forJavaClassPath());
    }

    public static void enableAnyoneLogin(Server server) {
        ManagementContext mgmt = BrooklynRestApiLauncherTestFixture.getManagementContextFromJettyServerAttributes(server);
        BrooklynRestApiLauncherTestFixture.enableAnyoneLogin(mgmt);
    }

    public static void enableAnyoneLogin(ManagementContext mgmt) {
        ((BrooklynProperties)mgmt.getConfig()).put(BrooklynWebConfig.SECURITY_PROVIDER_CLASSNAME, (Object)AnyoneSecurityProvider.class.getName());
    }

    public static ManagementContext getManagementContextFromJettyServerAttributes(Server server) {
        return BrooklynRestApiLauncherTestFixture.getManagementContext((ContextHandler)server.getHandler());
    }

    public static ManagementContext getManagementContext(ContextHandler jettyServerHandler) {
        ManagementContext managementContext = Compat.getInstance().getManagementContext();
        if (managementContext == null && jettyServerHandler != null) {
            managementContext = (ManagementContext)jettyServerHandler.getAttribute(BrooklynServiceAttributes.BROOKLYN_MANAGEMENT_CONTEXT);
        }
        return managementContext;
    }
}

