/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest;

import java.util.concurrent.Callable;
import org.apache.brooklyn.entity.brooklynnode.BrooklynNode;
import org.apache.brooklyn.rest.BrooklynRestApiLauncher;
import org.apache.brooklyn.rest.BrooklynRestApiLauncherTestFixture;
import org.apache.brooklyn.rest.security.provider.AnyoneSecurityProvider;
import org.apache.brooklyn.test.Asserts;
import org.apache.brooklyn.util.http.HttpAsserts;
import org.apache.brooklyn.util.http.HttpTool;
import org.eclipse.jetty.server.Server;
import org.testng.annotations.Test;

public class BrooklynRestApiLauncherTest
extends BrooklynRestApiLauncherTestFixture {
    @Test
    public void testServletStart() throws Exception {
        BrooklynRestApiLauncherTest.checkRestCatalogEntities(this.useServerForTest(this.baseLauncher().mode(BrooklynRestApiLauncher.StartMode.SERVLET).start()));
    }

    @Test
    public void testWebAppStart() throws Exception {
        BrooklynRestApiLauncherTest.checkRestCatalogEntities(this.useServerForTest(this.baseLauncher().mode(BrooklynRestApiLauncher.StartMode.WEB_XML).start()));
    }

    private BrooklynRestApiLauncher baseLauncher() {
        return BrooklynRestApiLauncher.launcher().securityProvider(AnyoneSecurityProvider.class).forceUseOfDefaultCatalogWithJavaClassPath(true);
    }

    private static void checkRestCatalogEntities(Server server) throws Exception {
        final String rootUrl = BrooklynRestApiLauncherTest.getBaseUriRest(server);
        int code = (Integer)Asserts.succeedsEventually((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int code = HttpTool.getHttpStatusCode((String)(rootUrl + "catalog/entities"));
                if (code == 403) {
                    throw new RuntimeException("Retry request");
                }
                return code;
            }
        });
        HttpAsserts.assertHealthyStatusCode((int)code);
        HttpAsserts.assertContentContainsText((String)(rootUrl + "catalog/entities"), (String)BrooklynNode.class.getSimpleName(), (String[])new String[0]);
    }
}

