/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest;

import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.List;
import javax.servlet.Filter;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.camp.brooklyn.BrooklynCampPlatformLauncherAbstract;
import org.apache.brooklyn.camp.brooklyn.BrooklynCampPlatformLauncherNoServer;
import org.apache.brooklyn.config.ConfigMap;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.core.server.BrooklynServerConfig;
import org.apache.brooklyn.core.server.BrooklynServiceAttributes;
import org.apache.brooklyn.rest.BrooklynWebConfig;
import org.apache.brooklyn.rest.RestApiSetup;
import org.apache.brooklyn.rest.filter.BrooklynPropertiesSecurityFilter;
import org.apache.brooklyn.rest.filter.HaMasterCheckFilter;
import org.apache.brooklyn.rest.filter.LoggingFilter;
import org.apache.brooklyn.rest.filter.RequestTaggingFilter;
import org.apache.brooklyn.rest.security.provider.AnyoneSecurityProvider;
import org.apache.brooklyn.rest.security.provider.SecurityProvider;
import org.apache.brooklyn.rest.util.ManagementContextProvider;
import org.apache.brooklyn.rest.util.ServerStoppingShutdownHandler;
import org.apache.brooklyn.rest.util.ShutdownHandler;
import org.apache.brooklyn.rest.util.ShutdownHandlerProvider;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.text.WildcardGlobs;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.webapp.WebAppContext;
import org.reflections.util.ClasspathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynRestApiLauncher {
    private static final Logger log = LoggerFactory.getLogger(BrooklynRestApiLauncher.class);
    static final int FAVOURITE_PORT = 8081;
    public static final String SCANNING_CATALOG_BOM_URL = "classpath://brooklyn/scanning.catalog.bom";
    public static final List<Class<? extends Filter>> DEFAULT_FILTERS = ImmutableList.of(RequestTaggingFilter.class, BrooklynPropertiesSecurityFilter.class, LoggingFilter.class, HaMasterCheckFilter.class);
    private boolean forceUseOfDefaultCatalogWithJavaClassPath = false;
    private Class<? extends SecurityProvider> securityProvider;
    private List<Class<? extends Filter>> filters = DEFAULT_FILTERS;
    private StartMode mode = StartMode.SERVLET;
    private ManagementContext mgmt;
    private ContextHandler customContext;
    private boolean deployJsgui = true;
    private boolean disableHighAvailability = true;
    private ServerStoppingShutdownHandler shutdownListener;

    protected BrooklynRestApiLauncher() {
    }

    public BrooklynRestApiLauncher managementContext(ManagementContext mgmt) {
        this.mgmt = mgmt;
        return this;
    }

    public BrooklynRestApiLauncher forceUseOfDefaultCatalogWithJavaClassPath(boolean forceUseOfDefaultCatalogWithJavaClassPath) {
        this.forceUseOfDefaultCatalogWithJavaClassPath = forceUseOfDefaultCatalogWithJavaClassPath;
        return this;
    }

    public BrooklynRestApiLauncher securityProvider(Class<? extends SecurityProvider> securityProvider) {
        this.securityProvider = securityProvider;
        return this;
    }

    public BrooklynRestApiLauncher filters(Class<? extends Filter> ... filters) {
        this.filters = Lists.newArrayList((Object[])filters);
        return this;
    }

    public BrooklynRestApiLauncher mode(StartMode mode) {
        this.mode = (StartMode)((Object)Preconditions.checkNotNull((Object)((Object)mode), (Object)"mode"));
        return this;
    }

    public BrooklynRestApiLauncher customContext(ContextHandler customContext) {
        this.customContext = (ContextHandler)Preconditions.checkNotNull((Object)customContext, (Object)"customContext");
        return this;
    }

    public BrooklynRestApiLauncher withJsgui() {
        this.deployJsgui = true;
        return this;
    }

    public BrooklynRestApiLauncher withoutJsgui() {
        this.deployJsgui = false;
        return this;
    }

    public BrooklynRestApiLauncher disableHighAvailability(boolean value) {
        this.disableHighAvailability = value;
        return this;
    }

    public Server start() {
        String summary;
        ContextHandler context;
        if (this.mgmt == null) {
            this.mgmt = new LocalManagementContext();
        }
        BrooklynCampPlatformLauncherAbstract platform = new BrooklynCampPlatformLauncherNoServer().useManagementContext(this.mgmt).launch();
        ((LocalManagementContext)this.mgmt).noteStartupComplete();
        log.debug("started " + platform);
        if (this.customContext == null) {
            switch (this.mode) {
                case WEB_XML: {
                    context = this.webXmlContextHandler(this.mgmt);
                    summary = "from WAR at " + ((WebAppContext)context).getWar();
                    break;
                }
                default: {
                    context = this.servletContextHandler(this.mgmt);
                    summary = "programmatic Jersey ServletContainer servlet";
                    break;
                }
            }
        } else {
            context = this.customContext;
            String string = summary = context instanceof WebAppContext ? "from WAR at " + ((WebAppContext)context).getWar() : "from custom context";
        }
        if (this.securityProvider != null) {
            ((BrooklynProperties)this.mgmt.getConfig()).put(BrooklynWebConfig.SECURITY_PROVIDER_CLASSNAME, (Object)this.securityProvider.getName());
        }
        if (this.forceUseOfDefaultCatalogWithJavaClassPath) {
            ((BrooklynProperties)this.mgmt.getConfig()).put(BrooklynServerConfig.BROOKLYN_CATALOG_URL, (Object)SCANNING_CATALOG_BOM_URL);
            ((LocalManagementContext)this.mgmt).setBaseClassPathForScanning((Iterable)ClasspathHelper.forJavaClassPath());
        } else {
            ((BrooklynProperties)this.mgmt.getConfig()).put(BrooklynServerConfig.BROOKLYN_CATALOG_URL, (Object)"classpath://brooklyn/empty.catalog.bom");
        }
        Server server = BrooklynRestApiLauncher.startServer(this.mgmt, context, summary, this.disableHighAvailability);
        if (this.shutdownListener != null) {
            this.shutdownListener.setServer(server);
        }
        return server;
    }

    private ContextHandler servletContextHandler(ManagementContext managementContext) {
        WebAppContext context = new WebAppContext();
        context.setAttribute(BrooklynServiceAttributes.BROOKLYN_MANAGEMENT_CONTEXT, (Object)managementContext);
        this.installWar(context);
        RestApiSetup.installRest((ServletContextHandler)context, (Object[])new Object[]{new ManagementContextProvider(managementContext), new ShutdownHandlerProvider((ShutdownHandler)this.shutdownListener)});
        RestApiSetup.installServletFilters((ServletContextHandler)context, this.filters);
        context.setContextPath("/");
        return context;
    }

    private void installWar(WebAppContext context) {
        context.setWar(this.deployJsgui && BrooklynRestApiLauncher.findJsguiWebappInSource().isPresent() ? (String)BrooklynRestApiLauncher.findJsguiWebappInSource().get() : (ResourceUtils.create((Object)this).doesUrlExist("classpath://brooklyn.war") ? Os.writeToTempFile((InputStream)ResourceUtils.create((Object)this).getResourceFromUrl("classpath://brooklyn.war"), (String)"brooklyn", (String)"war").getAbsolutePath() : BrooklynRestApiLauncher.createTempWebDirWithIndexHtml("Brooklyn REST API <p> (gui not available)")));
    }

    private ContextHandler webXmlContextHandler(ManagementContext mgmt) {
        WebAppContext context;
        RestApiSetup.initSwagger();
        if (BrooklynRestApiLauncher.findMatchingFile("src/main/webapp") != null) {
            context = new WebAppContext("src/main/webapp", "/");
            context.setExtraClasspath("./target/classes");
        } else if (BrooklynRestApiLauncher.findRestApiWar() != null) {
            context = new WebAppContext(BrooklynRestApiLauncher.findRestApiWar(), "/");
        } else {
            throw new IllegalStateException("Cannot find WAR for REST API. Expected in target/*.war, Maven repo, or in source directories.");
        }
        context.setAttribute(BrooklynServiceAttributes.BROOKLYN_MANAGEMENT_CONTEXT, (Object)mgmt);
        return context;
    }

    @Deprecated
    public static Server startServer(ManagementContext mgmt, ContextHandler context, String summary, boolean disableHighAvailability) {
        boolean secure;
        boolean bl = secure = mgmt != null && !BrooklynWebConfig.hasNoSecurityOptions((ConfigMap)mgmt.getConfig());
        if (secure) {
            log.debug("Detected security configured, launching server on all network interfaces");
        } else {
            log.debug("Detected no security configured, launching server on loopback (localhost) network interface only");
            if (mgmt != null) {
                log.debug("Detected no security configured, running on loopback; disabling authentication");
                ((BrooklynProperties)mgmt.getConfig()).put(BrooklynWebConfig.SECURITY_PROVIDER_CLASSNAME, (Object)AnyoneSecurityProvider.class.getName());
            }
        }
        if (mgmt != null && disableHighAvailability) {
            mgmt.getHighAvailabilityManager().disabled();
        }
        InetSocketAddress bindLocation = new InetSocketAddress(secure ? Networking.ANY_NIC : Networking.LOOPBACK, Networking.nextAvailablePort((int)8081));
        return BrooklynRestApiLauncher.startServer(context, summary, bindLocation);
    }

    @Deprecated
    public static Server startServer(ContextHandler context, String summary, InetSocketAddress bindLocation) {
        Server server = new Server(bindLocation);
        server.setHandler((Handler)context);
        try {
            server.start();
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
        log.info("Brooklyn REST server started (" + summary + ") on");
        log.info("  http://localhost:" + ((NetworkConnector)server.getConnectors()[0]).getLocalPort() + "/");
        return server;
    }

    public static BrooklynRestApiLauncher launcher() {
        return new BrooklynRestApiLauncher();
    }

    public static void main(String[] args) throws Exception {
        BrooklynRestApiLauncher.startRestResourcesViaServlet();
        log.info("Press Ctrl-C to quit.");
    }

    public static Server startRestResourcesViaServlet() throws Exception {
        return new BrooklynRestApiLauncher().mode(StartMode.SERVLET).start();
    }

    public static Server startRestResourcesViaWebXml() throws Exception {
        return new BrooklynRestApiLauncher().mode(StartMode.WEB_XML).start();
    }

    @Deprecated
    public static Server startServer(ContextHandler context, String summary) {
        return BrooklynRestApiLauncher.startServer(context, summary, new InetSocketAddress(Networking.ANY_NIC, Networking.nextAvailablePort((int)8081)));
    }

    @Beta
    public static Maybe<String> findJsguiWebappInSource() {
        return BrooklynRestApiLauncher.findFirstMatchingFile("../../brooklyn-ui/src/main/webapp", "../../../brooklyn-ui/src/main/webapp", "../brooklyn-ui/src/main/webapp", "./brooklyn-ui/src/main/webapp", "../../brooklyn-ui/target/*.war", "../../..brooklyn-ui/target/*.war", "../brooklyn-ui/target/*.war", "./brooklyn-ui/target/*.war");
    }

    private static String findRestApiWar() {
        return (String)BrooklynRestApiLauncher.findMatchingFile("../rest/target/*.war").orNull();
    }

    public static Maybe<String> findFirstMatchingFile(String ... filenames) {
        for (String f : filenames) {
            Maybe<String> result = BrooklynRestApiLauncher.findMatchingFile(f);
            if (!result.isPresent()) continue;
            return result;
        }
        return Maybe.absent();
    }

    @Beta
    public static Maybe<String> findMatchingFile(String filename) {
        final File f = new File(filename);
        if (f.exists()) {
            return Maybe.of((Object)filename);
        }
        File dir = f.getParentFile();
        File result = null;
        if (dir.exists()) {
            File[] matchingFiles;
            for (File mf : matchingFiles = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return WildcardGlobs.isGlobMatched((String)f.getName(), (String)name);
                }
            })) {
                if (result != null && mf.lastModified() <= result.lastModified()) continue;
                result = mf;
            }
        }
        if (result == null) {
            return Maybe.absent();
        }
        return Maybe.of((Object)result.getAbsolutePath());
    }

    private static String createTempWebDirWithIndexHtml(String indexHtmlContent) {
        File dir = Files.createTempDir();
        dir.deleteOnExit();
        try {
            Files.write((CharSequence)indexHtmlContent, (File)new File(dir, "index.html"), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            Exceptions.propagate((Throwable)e);
        }
        return dir.getAbsolutePath();
    }

    static enum StartMode {
        SERVLET,
        WEB_XML;

    }
}

