/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.rest.BrooklynRestApiLauncher;
import org.apache.brooklyn.rest.BrooklynRestApiLauncherTestFixture;
import org.apache.brooklyn.rest.security.provider.AnyoneSecurityProvider;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.http.HttpTool;
import org.apache.brooklyn.util.http.HttpToolResponse;
import org.apache.brooklyn.util.time.Time;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BrooklynPropertiesSecurityFilterTest
extends BrooklynRestApiLauncherTestFixture {
    private static final Logger LOG = LoggerFactory.getLogger(BrooklynPropertiesSecurityFilterTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"Integration", "Broken"})
    public void testInteractionOfSecurityFilterAndFormMapProvider() throws Exception {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            Server server = this.useServerForTest(BrooklynRestApiLauncher.launcher().securityProvider(AnyoneSecurityProvider.class).forceUseOfDefaultCatalogWithJavaClassPath(true).withoutJsgui().start());
            String appId = this.startAppAtNode(server);
            String entityId = this.getTestEntityInApp(server, appId);
            HttpClient client = HttpTool.httpClientBuilder().uri(this.getBaseUriRest()).build();
            ArrayList nvps = Lists.newArrayList((Object[])new BasicNameValuePair[]{new BasicNameValuePair("arg", "bar")});
            String effector = String.format("/applications/%s/entities/%s/effectors/identityEffector", appId, entityId);
            HttpToolResponse response = HttpTool.httpPost((HttpClient)client, (URI)URI.create(this.getBaseUriRest() + effector), (Map)ImmutableMap.of((Object)"Content-Type", (Object)ContentType.APPLICATION_FORM_URLENCODED.getMimeType()), (byte[])URLEncodedUtils.format((Iterable)nvps, (Charset)Charsets.UTF_8).getBytes());
            LOG.info("Effector response: {}", (Object)response.getContentAsString());
            Assert.assertTrue((boolean)HttpTool.isStatusCodeHealthy((int)response.getResponseCode()), (String)("response code=" + response.getResponseCode()));
        }
        finally {
            LOG.info("testInteractionOfSecurityFilterAndFormMapProvider complete in " + Time.makeTimeStringRounded((Stopwatch)stopwatch));
        }
    }

    private String startAppAtNode(Server server) throws Exception {
        String blueprint = "name: TestApp\nlocation: localhost\nservices:\n- type: org.apache.brooklyn.test.entity.TestEntity";
        HttpClient client = HttpTool.httpClientBuilder().uri(BrooklynPropertiesSecurityFilterTest.getBaseUriRest(server)).build();
        HttpToolResponse response = HttpTool.httpPost((HttpClient)client, (URI)URI.create(this.getBaseUriRest() + "applications"), (Map)ImmutableMap.of((Object)"Content-Type", (Object)"application/x-yaml"), (byte[])blueprint.getBytes());
        Assert.assertTrue((boolean)HttpTool.isStatusCodeHealthy((int)response.getResponseCode()), (String)("error creating app. response code=" + response.getResponseCode()));
        Map body = (Map)new ObjectMapper().readValue(response.getContent(), HashMap.class);
        return (String)body.get("entityId");
    }

    private String getTestEntityInApp(Server server, String appId) throws Exception {
        HttpClient client = HttpTool.httpClientBuilder().uri(BrooklynPropertiesSecurityFilterTest.getBaseUriRest(server)).build();
        List entities = (List)new ObjectMapper().readValue(HttpTool.httpGet((HttpClient)client, (URI)URI.create(BrooklynPropertiesSecurityFilterTest.getBaseUriRest(server) + "applications/" + appId + "/entities"), (Map)MutableMap.of()).getContent(), List.class);
        LOG.info((String)((Map)entities.get(0)).get("id"));
        return (String)((Map)entities.get(0)).get("id");
    }
}

