/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.util.json;

import brooklyn.rest.util.json.BidiSerialization;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.javalang.Reflections;
import java.io.IOException;
import java.io.NotSerializableException;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonStreamContext;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.ser.impl.UnknownSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorAndToStringUnknownTypeSerializer
extends UnknownSerializer {
    private static final Logger log = LoggerFactory.getLogger(ErrorAndToStringUnknownTypeSerializer.class);
    private static Set<String> WARNED_CLASSES = Collections.synchronizedSet(MutableSet.of());

    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (BidiSerialization.isStrictSerialization()) {
            throw new JsonMappingException("Cannot serialize object containing " + value.getClass().getName() + " when strict serialization requested");
        }
        this.serializeFromError(jgen.getOutputContext(), null, value, jgen, provider);
    }

    public void serializeFromError(JsonStreamContext ctxt, @Nullable Exception error, Object value, JsonGenerator jgen, SerializerProvider configurableSerializerProvider) throws JsonGenerationException, IOException {
        boolean createObject;
        if (log.isDebugEnabled()) {
            log.debug("Recovering from json serialization error, serializing " + value + ": " + error);
        }
        if (BidiSerialization.isStrictSerialization()) {
            throw new JsonMappingException("Cannot serialize " + (ctxt != null && !ctxt.inRoot() ? "object containing " : "") + value.getClass().getName() + " when strict serialization requested");
        }
        if (WARNED_CLASSES.add(value.getClass().getCanonicalName())) {
            log.warn("Standard serialization not possible for " + value.getClass() + " (" + value + ")", (Throwable)error);
        }
        JsonStreamContext newCtxt = jgen.getOutputContext();
        jgen.flush();
        boolean bl = createObject = !newCtxt.inObject() || newCtxt.getCurrentName() != null;
        if (createObject) {
            jgen.writeStartObject();
        }
        if (!this.allowEmpty(value.getClass())) {
            jgen.writeFieldName("error");
            jgen.writeBoolean(true);
            jgen.writeFieldName("errorType");
            jgen.writeString(NotSerializableException.class.getCanonicalName());
            jgen.writeFieldName("type");
            jgen.writeString(value.getClass().getCanonicalName());
            jgen.writeFieldName("toString");
            jgen.writeString(value.toString());
            if (error != null) {
                jgen.writeFieldName("causedByError");
                jgen.writeString(error.toString());
            }
        }
        if (createObject) {
            jgen.writeEndObject();
        }
        while (newCtxt != null && !newCtxt.equals(ctxt)) {
            if (jgen.getOutputContext().inArray()) {
                jgen.writeEndArray();
                continue;
            }
            if (!jgen.getOutputContext().inObject()) break;
            jgen.writeEndObject();
        }
    }

    protected boolean allowEmpty(Class<? extends Object> clazz) {
        return clazz.getAnnotation(JsonSerialize.class) != null && Reflections.hasNoNonObjectFields(clazz);
    }
}

