/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.util;

import brooklyn.catalog.internal.CatalogUtils;
import brooklyn.rest.domain.ApiError;
import brooklyn.rest.util.json.BrooklynJacksonJsonProvider;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.net.Urls;
import brooklyn.util.text.StringEscapes;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebResourceUtils {
    private static final Logger log = LoggerFactory.getLogger(WebResourceUtils.class);
    public static final Map<String, MediaType> IMAGE_FORMAT_MIME_TYPES = ImmutableMap.builder().put((Object)"jpg", (Object)MediaType.JPEG).put((Object)"jpeg", (Object)MediaType.JPEG).put((Object)"png", (Object)MediaType.PNG).put((Object)"gif", (Object)MediaType.GIF).put((Object)"svg", (Object)MediaType.SVG_UTF_8).build();

    public static WebApplicationException throwWebApplicationException(Response.Status status, String format, Object ... args) {
        String msg = String.format(format, args);
        if (log.isDebugEnabled()) {
            log.debug("responding {} {} ({})", new Object[]{status.getStatusCode(), status.getReasonPhrase(), msg});
        }
        ApiError apiError = ApiError.builder().message(msg).errorCode(status).build();
        throw new WebApplicationException(new Throwable(apiError.toString()), apiError.asJsonResponse());
    }

    public static WebApplicationException serverError(String format, Object ... args) {
        return WebResourceUtils.throwWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, format, args);
    }

    public static WebApplicationException badRequest(String format, Object ... args) {
        return WebResourceUtils.throwWebApplicationException(Response.Status.BAD_REQUEST, format, args);
    }

    public static WebApplicationException unauthorized(String format, Object ... args) {
        return WebResourceUtils.throwWebApplicationException(Response.Status.UNAUTHORIZED, format, args);
    }

    public static WebApplicationException forbidden(String format, Object ... args) {
        return WebResourceUtils.throwWebApplicationException(Response.Status.FORBIDDEN, format, args);
    }

    public static WebApplicationException notFound(String format, Object ... args) {
        return WebResourceUtils.throwWebApplicationException(Response.Status.NOT_FOUND, format, args);
    }

    public static WebApplicationException preconditionFailed(String format, Object ... args) {
        return WebResourceUtils.throwWebApplicationException(Response.Status.PRECONDITION_FAILED, format, args);
    }

    public static javax.ws.rs.core.MediaType getImageMediaTypeFromExtension(String extension) {
        MediaType mime = IMAGE_FORMAT_MIME_TYPES.get(extension.toLowerCase());
        if (mime == null) {
            return null;
        }
        try {
            return javax.ws.rs.core.MediaType.valueOf((String)mime.toString());
        }
        catch (Exception e) {
            log.warn("Unparseable MIME type " + mime + "; ignoring (" + e + ")");
            Exceptions.propagateIfFatal((Throwable)e);
            return null;
        }
    }

    public static Object getValueForDisplay(Object value, boolean preferJson, boolean isJerseyReturnValue) {
        return WebResourceUtils.getValueForDisplay(null, value, preferJson, isJerseyReturnValue);
    }

    public static Object getValueForDisplay(ObjectMapper mapper, Object value, boolean preferJson, boolean isJerseyReturnValue) {
        if (preferJson) {
            if (value == null) {
                return null;
            }
            Object result = value;
            result = value;
            if (isJerseyReturnValue && result instanceof String) {
                result = StringEscapes.JavaStringEscapes.wrapJavaString((String)((String)result));
            }
            return result;
        }
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public static String getPathFromVersionedId(String versionedId) {
        if (CatalogUtils.looksLikeVersionedId((String)versionedId)) {
            String symbolicName = CatalogUtils.getIdFromVersionedId((String)versionedId);
            String version = CatalogUtils.getVersionFromVersionedId((String)versionedId);
            return Urls.encode((String)symbolicName) + "/" + Urls.encode((String)version);
        }
        return Urls.encode((String)versionedId);
    }

    public static void applyJsonResponse(ServletContext servletContext, Response source, HttpServletResponse target) throws IOException {
        target.setStatus(source.getStatus());
        target.setContentType("application/json");
        target.setCharacterEncoding("UTF-8");
        target.getWriter().write(BrooklynJacksonJsonProvider.findAnyObjectMapper(servletContext, null).writeValueAsString(source.getEntity()));
    }
}

