/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.util;

import brooklyn.management.entitlement.Entitlements;
import brooklyn.rest.domain.ApiError;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.exceptions.UserFacingException;
import brooklyn.util.flags.ClassCoercionException;
import brooklyn.util.text.Strings;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.error.YAMLException;

@Provider
public class DefaultExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExceptionMapper.class);
    static Set<Class<?>> warnedUnknownExceptions = MutableSet.of();

    public Response toResponse(Throwable throwable1) {
        ApiError.Builder rb;
        Throwable throwable2;
        LOG.debug("REST request running as {} threw: {}", (Object)Entitlements.getEntitlementContext(), (Object)Exceptions.collapse((Throwable)throwable1));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Full details of " + Entitlements.getEntitlementContext() + " " + throwable1, throwable1);
        }
        if ((throwable2 = Exceptions.getFirstInteresting((Throwable)throwable1)) instanceof WebApplicationException) {
            WebApplicationException wae = (WebApplicationException)throwable2;
            return wae.getResponse();
        }
        if (throwable2 instanceof UserFacingException) {
            return ApiError.of((String)throwable2.getMessage()).asBadRequestResponseJson();
        }
        if (throwable2 instanceof ClassCoercionException || throwable2 instanceof IllegalArgumentException) {
            return ApiError.of((Throwable)throwable2).asBadRequestResponseJson();
        }
        if (throwable2 instanceof YAMLException) {
            return ApiError.builder().message(throwable2.getMessage()).prefixMessage("Invalid YAML").build().asBadRequestResponseJson();
        }
        if (!Exceptions.isPrefixBoring((Throwable)throwable2) && warnedUnknownExceptions.add(throwable2.getClass())) {
            LOG.warn("REST call generated exception type " + throwable2.getClass() + " unrecognized in " + this.getClass() + " (subsequent occurrences will be logged debug only): " + throwable2, throwable2);
        }
        if (Strings.isBlank((CharSequence)(rb = ApiError.builderFromThrowable((Throwable)Exceptions.collapse((Throwable)throwable2))).getMessage())) {
            rb.message("Internal error. Contact server administrator to consult logs for more details.");
        }
        return rb.build().asResponse(Response.Status.INTERNAL_SERVER_ERROR, MediaType.APPLICATION_JSON_TYPE);
    }
}

