/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.transform;

import brooklyn.config.render.RendererHints;
import brooklyn.entity.Entity;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.rest.domain.SensorSummary;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.net.URLParamEncoder;
import brooklyn.util.text.Strings;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorTransformer {
    private static final Logger log = LoggerFactory.getLogger(SensorTransformer.class);

    public static SensorSummary sensorSummaryForCatalog(Sensor<?> sensor) {
        return new SensorSummary(sensor.getName(), sensor.getTypeName(), sensor.getDescription(), null);
    }

    public static SensorSummary sensorSummary(Entity entity, Sensor<?> sensor) {
        String applicationUri = "/v1/applications/" + entity.getApplicationId();
        String entityUri = applicationUri + "/entities/" + entity.getId();
        String selfUri = entityUri + "/sensors/" + URLParamEncoder.encode((String)sensor.getName());
        MutableMap.Builder lb = MutableMap.builder().put((Object)"self", (Object)URI.create(selfUri)).put((Object)"application", (Object)URI.create(applicationUri)).put((Object)"entity", (Object)URI.create(entityUri)).put((Object)"action:json", (Object)URI.create(selfUri));
        if (sensor instanceof AttributeSensor) {
            Iterable hints = Iterables.filter((Iterable)RendererHints.getHintsFor((AttributeSensor)((AttributeSensor)sensor)), RendererHints.NamedAction.class);
            for (RendererHints.NamedAction na : hints) {
                SensorTransformer.addNamedAction((MutableMap.Builder<String, URI>)lb, na, entity, sensor);
            }
        }
        return new SensorSummary(sensor.getName(), sensor.getTypeName(), sensor.getDescription(), (Map)lb.build());
    }

    private static <T> void addNamedAction(MutableMap.Builder<String, URI> lb, RendererHints.NamedAction na, Entity entity, Sensor<T> sensor) {
        SensorTransformer.addNamedAction(lb, na, entity.getAttribute((AttributeSensor)sensor), sensor, entity);
    }

    static <T> void addNamedAction(MutableMap.Builder<String, URI> lb, RendererHints.NamedAction na, T value, Object context, Entity contextEntity) {
        if (na instanceof RendererHints.NamedActionWithUrl) {
            try {
                String v = ((RendererHints.NamedActionWithUrl)na).getUrlFromValue(value);
                if (Strings.isNonBlank((CharSequence)v)) {
                    String action = na.getActionName().toLowerCase();
                    lb.putIfAbsent((Object)("action:" + action), (Object)URI.create(v));
                }
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                log.warn("Unable to make action " + na + " from " + context + " on " + contextEntity + ": " + e, (Throwable)e);
            }
        }
    }
}

