/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.transform;

import brooklyn.entity.basic.Sanitizer;
import brooklyn.location.Location;
import brooklyn.location.LocationDefinition;
import brooklyn.location.basic.BasicLocationDefinition;
import brooklyn.location.basic.LocationConfigKeys;
import brooklyn.location.basic.LocationInternal;
import brooklyn.management.ManagementContext;
import brooklyn.rest.domain.LocationSpec;
import brooklyn.rest.domain.LocationSummary;
import brooklyn.rest.util.WebResourceUtils;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.guava.Maybe;
import brooklyn.util.text.Strings;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationTransformer {
    private static final Logger log = LoggerFactory.getLogger(LocationDetailLevel.class);

    @Deprecated
    public static LocationSummary newInstance(String id, LocationSpec locationSpec) {
        return LocationTransformer.newInstance(null, id, locationSpec, LocationDetailLevel.LOCAL_EXCLUDING_SECRET);
    }

    public static LocationSummary newInstance(ManagementContext mgmt, String id, LocationSpec locationSpec, LocationDetailLevel level) {
        Map config = locationSpec.getConfig();
        if (mgmt != null && (level == LocationDetailLevel.FULL_EXCLUDING_SECRET || level == LocationDetailLevel.FULL_INCLUDING_SECRET)) {
            BasicLocationDefinition ld = new BasicLocationDefinition(id, locationSpec.getName(), locationSpec.getSpec(), locationSpec.getConfig());
            Location ll = (Location)mgmt.getLocationRegistry().resolve((LocationDefinition)ld, Boolean.valueOf(false), null).orNull();
            if (ll != null) {
                config = ((LocationInternal)ll).config().getBag().getAllConfig();
            }
        } else if (level == LocationDetailLevel.LOCAL_EXCLUDING_SECRET && !config.containsKey(LocationConfigKeys.DISPLAY_NAME.getName()) && mgmt != null) {
            Map configExtra;
            BasicLocationDefinition ld = new BasicLocationDefinition(id, locationSpec.getName(), locationSpec.getSpec(), locationSpec.getConfig());
            Location ll = (Location)mgmt.getLocationRegistry().resolve((LocationDefinition)ld, Boolean.valueOf(false), null).orNull();
            if (ll != null && (configExtra = ((LocationInternal)ll).config().getBag().getAllConfig()).containsKey(LocationConfigKeys.DISPLAY_NAME.getName())) {
                ConfigBag configNew = ConfigBag.newInstance((Map)config);
                configNew.configure(LocationConfigKeys.DISPLAY_NAME, (Object)((String)configExtra.get(LocationConfigKeys.DISPLAY_NAME.getName())));
                config = configNew.getAllConfig();
            }
        }
        return new LocationSummary(id, locationSpec.getName(), locationSpec.getSpec(), null, LocationTransformer.copyConfig(config, level), (Map)ImmutableMap.of((Object)"self", (Object)URI.create("/v1/locations/" + id)));
    }

    @Deprecated
    public static LocationSummary newInstance(LocationDefinition l) {
        return LocationTransformer.newInstance(null, l, LocationDetailLevel.LOCAL_EXCLUDING_SECRET);
    }

    public static LocationSummary newInstance(ManagementContext mgmt, LocationDefinition l, LocationDetailLevel level) {
        Map configExtra;
        Location ll;
        Map config = l.getConfig();
        if (mgmt != null && (level == LocationDetailLevel.FULL_EXCLUDING_SECRET || level == LocationDetailLevel.FULL_INCLUDING_SECRET)) {
            Location ll2 = (Location)mgmt.getLocationRegistry().resolve(l, Boolean.valueOf(false), null).orNull();
            if (ll2 != null) {
                config = ((LocationInternal)ll2).config().getBag().getAllConfig();
            }
        } else if (level == LocationDetailLevel.LOCAL_EXCLUDING_SECRET && mgmt != null && !config.containsKey(LocationConfigKeys.DISPLAY_NAME.getName()) && (ll = (Location)mgmt.getLocationRegistry().resolve(l, Boolean.valueOf(false), null).orNull()) != null && (configExtra = ((LocationInternal)ll).config().getBag().getAllConfig()).containsKey(LocationConfigKeys.DISPLAY_NAME.getName())) {
            ConfigBag configNew = ConfigBag.newInstance((Map)config);
            configNew.configure(LocationConfigKeys.DISPLAY_NAME, (Object)((String)configExtra.get(LocationConfigKeys.DISPLAY_NAME.getName())));
            config = configNew.getAllConfig();
        }
        return new LocationSummary(l.getId(), l.getName(), l.getSpec(), null, LocationTransformer.copyConfig(config, level), (Map)ImmutableMap.of((Object)"self", (Object)URI.create("/v1/locations/" + l.getId())));
    }

    private static Map<String, ?> copyConfig(Map<String, ?> entries, LocationDetailLevel level) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (level != LocationDetailLevel.NONE) {
            for (Map.Entry<String, ?> entry : entries.entrySet()) {
                if (level != LocationDetailLevel.FULL_INCLUDING_SECRET && Sanitizer.IS_SECRET_PREDICATE.apply((Object)entry.getKey())) continue;
                builder.put((Object)entry.getKey(), WebResourceUtils.getValueForDisplay(entry.getValue(), true, false));
            }
        }
        return builder.build();
    }

    public static LocationSummary newInstance(ManagementContext mgmt, Location l, LocationDetailLevel level) {
        Map configExtra;
        Location ll;
        String spec = null;
        String specId = null;
        for (Location lp = l; lp != null && (spec == null || specId == null); lp = lp.getParent()) {
            Maybe originalSpec;
            if (spec == null && (originalSpec = ((LocationInternal)lp).config().getRaw(LocationInternal.ORIGINAL_SPEC)).isPresent()) {
                spec = Strings.toString((Object)originalSpec.get());
            }
            if (specId != null) continue;
            LocationDefinition ld = null;
            if (spec != null) {
                ld = mgmt.getLocationRegistry().getDefinedLocationByName(spec);
            }
            if (ld == null && spec != null && spec.startsWith("named:")) {
                ld = mgmt.getLocationRegistry().getDefinedLocationByName(Strings.removeFromStart((String)spec, (String)"named:"));
            }
            if (ld == null) {
                ld = mgmt.getLocationRegistry().getDefinedLocationById(lp.getId());
            }
            if (ld == null) continue;
            if (spec == null) {
                spec = ld.getSpec();
            }
            specId = ld.getId();
        }
        if (specId == null && spec != null && (ll = (Location)mgmt.getLocationRegistry().resolve(spec, Boolean.valueOf(false), null).orNull()) != null) {
            specId = ll.getId();
        }
        MutableMap configOrig = level == LocationDetailLevel.LOCAL_EXCLUDING_SECRET ? MutableMap.copyOf((Map)((LocationInternal)l).config().getLocalBag().getAllConfig()) : MutableMap.copyOf((Map)((LocationInternal)l).config().getBag().getAllConfig());
        if (level == LocationDetailLevel.LOCAL_EXCLUDING_SECRET && !configOrig.containsKey(LocationConfigKeys.DISPLAY_NAME.getName()) && (configExtra = ((LocationInternal)l).config().getBag().getAllConfig()).containsKey(LocationConfigKeys.DISPLAY_NAME.getName())) {
            configOrig.put(LocationConfigKeys.DISPLAY_NAME.getName(), configExtra.get(LocationConfigKeys.DISPLAY_NAME.getName()));
        }
        Map<String, ?> config = level != LocationDetailLevel.NONE ? null : LocationTransformer.copyConfig(configOrig, level);
        return new LocationSummary(l.getId(), l.getDisplayName(), spec, l.getClass().getName(), config, MutableMap.of((Object)"self", (Object)URI.create("/v1/locations/" + l.getId())).addIfNotNull((Object)"parent", l.getParent() != null ? URI.create("/v1/locations/" + l.getParent().getId()) : null).addIfNotNull((Object)"spec", specId != null ? URI.create("/v1/locations/" + specId) : null).asUnmodifiable());
    }

    public static enum LocationDetailLevel {
        NONE,
        LOCAL_EXCLUDING_SECRET,
        FULL_EXCLUDING_SECRET,
        FULL_INCLUDING_SECRET;

    }
}

