/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.transform;

import brooklyn.catalog.CatalogConfig;
import brooklyn.config.ConfigKey;
import brooklyn.config.render.RendererHints;
import brooklyn.entity.Application;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.rest.domain.EntityConfigSummary;
import brooklyn.rest.domain.EntitySummary;
import brooklyn.rest.transform.SensorTransformer;
import brooklyn.rest.util.WebResourceUtils;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.net.URLParamEncoder;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.List;
import java.util.Map;

public class EntityTransformer {
    public static final Function<? super Entity, EntitySummary> FROM_ENTITY = new Function<Entity, EntitySummary>(){

        public EntitySummary apply(Entity entity) {
            return EntityTransformer.entitySummary(entity);
        }
    };

    public static EntitySummary entitySummary(Entity entity) {
        String applicationUri = "/v1/applications/" + entity.getApplicationId();
        String entityUri = applicationUri + "/entities/" + entity.getId();
        ImmutableMap.Builder lb = ImmutableMap.builder().put((Object)"self", (Object)URI.create(entityUri));
        if (entity.getParent() != null) {
            lb.put((Object)"parent", (Object)URI.create(applicationUri + "/entities/" + entity.getParent().getId()));
        }
        String type = entity.getEntityType().getName();
        lb.put((Object)"application", (Object)URI.create(applicationUri)).put((Object)"children", (Object)URI.create(entityUri + "/children")).put((Object)"config", (Object)URI.create(entityUri + "/config")).put((Object)"sensors", (Object)URI.create(entityUri + "/sensors")).put((Object)"effectors", (Object)URI.create(entityUri + "/effectors")).put((Object)"policies", (Object)URI.create(entityUri + "/policies")).put((Object)"activities", (Object)URI.create(entityUri + "/activities")).put((Object)"locations", (Object)URI.create(entityUri + "/locations")).put((Object)"tags", (Object)URI.create(entityUri + "/tags")).put((Object)"expunge", (Object)URI.create(entityUri + "/expunge")).put((Object)"rename", (Object)URI.create(entityUri + "/name")).put((Object)"spec", (Object)URI.create(entityUri + "/spec"));
        if (entity.getCatalogItemId() != null) {
            lb.put((Object)"catalog", (Object)URI.create("/v1/catalog/entities/" + WebResourceUtils.getPathFromVersionedId(entity.getCatalogItemId())));
        }
        if (entity.getIconUrl() != null) {
            lb.put((Object)"iconUrl", (Object)URI.create(entityUri + "/icon"));
        }
        return new EntitySummary(entity.getId(), entity.getDisplayName(), type, entity.getCatalogItemId(), (Map)lb.build());
    }

    public static List<EntitySummary> entitySummaries(Iterable<? extends Entity> entities) {
        return Lists.newArrayList((Iterable)Iterables.transform(entities, (Function)new Function<Entity, EntitySummary>(){

            public EntitySummary apply(Entity entity) {
                return EntityTransformer.entitySummary(entity);
            }
        }));
    }

    protected static EntityConfigSummary entityConfigSummary(ConfigKey<?> config, String label, Double priority, Map<String, URI> links) {
        ImmutableMap mapOfLinks = links == null ? null : ImmutableMap.copyOf(links);
        return new EntityConfigSummary(config, label, priority, (Map)mapOfLinks);
    }

    public static EntityConfigSummary entityConfigSummary(EntityLocal entity, ConfigKey<?> config) {
        String label = null;
        Double priority = null;
        String applicationUri = "/v1/applications/" + entity.getApplicationId();
        String entityUri = applicationUri + "/entities/" + entity.getId();
        String selfUri = entityUri + "/config/" + URLParamEncoder.encode((String)config.getName());
        MutableMap.Builder lb = MutableMap.builder().put((Object)"self", (Object)URI.create(selfUri)).put((Object)"application", (Object)URI.create(applicationUri)).put((Object)"entity", (Object)URI.create(entityUri)).put((Object)"action:json", (Object)URI.create(selfUri));
        Iterable hints = Iterables.filter((Iterable)RendererHints.getHintsFor(config), RendererHints.NamedAction.class);
        for (RendererHints.NamedAction na : hints) {
            SensorTransformer.addNamedAction((MutableMap.Builder<String, URI>)lb, na, entity.getConfig(config), config, (Entity)entity);
        }
        return EntityTransformer.entityConfigSummary(config, label, priority, (Map<String, URI>)lb.build());
    }

    public static String applicationUri(Application entity) {
        return "/v1/applications/" + entity.getApplicationId();
    }

    public static String entityUri(Entity entity) {
        return EntityTransformer.applicationUri(entity.getApplication()) + "/entities/" + entity.getId();
    }

    public static EntityConfigSummary entityConfigSummary(ConfigKey<?> config, Field configKeyField) {
        CatalogConfig catalogConfig = configKeyField != null ? configKeyField.getAnnotation(CatalogConfig.class) : null;
        String label = catalogConfig == null ? null : catalogConfig.label();
        Double priority = catalogConfig == null ? null : Double.valueOf(catalogConfig.priority());
        return EntityTransformer.entityConfigSummary(config, label, priority, null);
    }
}

