/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.resources;

import brooklyn.BrooklynVersion;
import brooklyn.config.ConfigKey;
import brooklyn.entity.Application;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.StartableApplication;
import brooklyn.entity.rebind.persister.BrooklynPersistenceUtils;
import brooklyn.entity.rebind.persister.FileBasedObjectStore;
import brooklyn.entity.rebind.persister.PersistenceObjectStore;
import brooklyn.management.ManagementContext;
import brooklyn.management.Task;
import brooklyn.management.entitlement.EntitlementClass;
import brooklyn.management.entitlement.EntitlementContext;
import brooklyn.management.entitlement.EntitlementManager;
import brooklyn.management.entitlement.Entitlements;
import brooklyn.management.ha.HighAvailabilityManager;
import brooklyn.management.ha.HighAvailabilityMode;
import brooklyn.management.ha.ManagementNodeState;
import brooklyn.management.ha.ManagementPlaneSyncRecord;
import brooklyn.management.ha.MementoCopyMode;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.rest.api.ServerApi;
import brooklyn.rest.domain.HighAvailabilitySummary;
import brooklyn.rest.domain.VersionSummary;
import brooklyn.rest.resources.AbstractBrooklynRestResource;
import brooklyn.rest.transform.BrooklynFeatureTransformer;
import brooklyn.rest.transform.HighAvailabilityTransformer;
import brooklyn.rest.util.WebResourceUtils;
import brooklyn.util.ResourceUtils;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.file.ArchiveBuilder;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.os.Os;
import brooklyn.util.text.Identifiers;
import brooklyn.util.text.Strings;
import brooklyn.util.time.CountdownTimer;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerResource
extends AbstractBrooklynRestResource
implements ServerApi {
    private static final int SHUTDOWN_TIMEOUT_CHECK_INTERVAL = 200;
    private static final Logger log = LoggerFactory.getLogger(ServerResource.class);
    private static final String BUILD_SHA_1_PROPERTY = "git-sha-1";
    private static final String BUILD_BRANCH_PROPERTY = "git-branch-name";

    public void reloadBrooklynProperties() {
        this.brooklyn().reloadBrooklynProperties();
    }

    private boolean isMaster() {
        return ManagementNodeState.MASTER.equals((Object)this.mgmt().getHighAvailabilityManager().getNodeState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(final boolean stopAppsFirst, final boolean forceShutdownOnError, String shutdownTimeoutRaw, String requestTimeoutRaw, String delayForHttpReturnRaw, Long delayMillis) {
        Duration delayForHttpReturn;
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ALL_SERVER_INFO, null)) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized for this operation", Entitlements.getEntitlementContext().user());
        }
        log.info("REST call to shutdown server, stopAppsFirst=" + stopAppsFirst + ", delayForHttpReturn=" + shutdownTimeoutRaw);
        if (stopAppsFirst && !this.isMaster()) {
            log.warn("REST call to shutdown non-master server while stopping apps is disallowed");
            throw WebResourceUtils.forbidden("Not allowed to stop all apps when server is not master", new Object[0]);
        }
        final Duration shutdownTimeout = this.parseDuration(shutdownTimeoutRaw, Duration.of((long)20L, (TimeUnit)TimeUnit.SECONDS));
        Duration requestTimeout = this.parseDuration(requestTimeoutRaw, Duration.of((long)20L, (TimeUnit)TimeUnit.SECONDS));
        if (delayMillis == null) {
            delayForHttpReturn = this.parseDuration(delayForHttpReturnRaw, Duration.FIVE_SECONDS);
        } else {
            log.warn("'delayMillis' is deprecated, use 'delayForHttpReturn' instead.");
            delayForHttpReturn = Duration.of((long)delayMillis, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        Preconditions.checkState((boolean)delayForHttpReturn.isPositive(), (Object)"Only positive delay allowed for delayForHttpReturn");
        boolean isSingleTimeout = shutdownTimeout.equals((Object)requestTimeout);
        final AtomicBoolean completed = new AtomicBoolean();
        final AtomicBoolean hasAppErrorsOrTimeout = new AtomicBoolean();
        new Thread("shutdown"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean terminateTried = false;
                try {
                    if (stopAppsFirst) {
                        CountdownTimer shutdownTimeoutTimer = null;
                        if (!shutdownTimeout.equals((Object)Duration.ZERO)) {
                            shutdownTimeoutTimer = shutdownTimeout.countdownTimer();
                        }
                        ArrayList<Task> stoppers = new ArrayList<Task>();
                        for (Application app : ServerResource.this.mgmt().getApplications()) {
                            if (!(app instanceof StartableApplication)) continue;
                            stoppers.add(Entities.invokeEffector((EntityLocal)((EntityLocal)app), (Entity)app, (Effector)StartableApplication.STOP));
                        }
                        for (Task t : stoppers) {
                            if (this.waitAppShutdown(shutdownTimeoutTimer, t)) continue;
                            hasAppErrorsOrTimeout.set(true);
                        }
                    }
                    terminateTried = true;
                    ((ManagementContextInternal)ServerResource.this.mgmt()).terminate();
                }
                catch (Throwable e) {
                    Throwable interesting = Exceptions.getFirstInteresting((Throwable)e);
                    if (interesting instanceof TimeoutException) {
                        log.warn("Timeout shutting down: " + Exceptions.collapseText((Throwable)e));
                        log.debug("Timeout shutting down: " + e, e);
                        hasAppErrorsOrTimeout.set(true);
                    } else {
                        log.error("Unexpected error shutting down: " + Exceptions.collapseText((Throwable)e), e);
                    }
                    hasAppErrorsOrTimeout.set(true);
                    if (!terminateTried) {
                        ((ManagementContextInternal)ServerResource.this.mgmt()).terminate();
                    }
                }
                finally {
                    this.complete();
                    if (!hasAppErrorsOrTimeout.get() || forceShutdownOnError) {
                        Time.sleep((Duration)delayForHttpReturn);
                        System.exit(0);
                    } else {
                        log.warn("Abandoning shutdown because there were errors and shutdown was not forced.");
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void complete() {
                AtomicBoolean atomicBoolean = completed;
                synchronized (atomicBoolean) {
                    completed.set(true);
                    completed.notifyAll();
                }
            }

            private boolean waitAppShutdown(CountdownTimer shutdownTimeoutTimer, Task<?> t) throws TimeoutException {
                Duration waitInterval = null;
                if (shutdownTimeoutTimer != null) {
                    waitInterval = Duration.of((long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
                }
                while (!t.blockUntilEnded(waitInterval)) {
                    if (!shutdownTimeoutTimer.isExpired()) continue;
                    log.warn("Timeout while waiting for applications to stop at " + t + ".\n" + t.getStatusDetail(true));
                    throw new TimeoutException();
                }
                if (t.isError()) {
                    log.warn("Error stopping application " + t + " during shutdown (ignoring)\n" + t.getStatusDetail(true));
                    return false;
                }
                return true;
            }
        }.start();
        AtomicBoolean atomicBoolean = completed;
        synchronized (atomicBoolean) {
            if (!completed.get()) {
                try {
                    long waitTimeout = 0L;
                    if (!isSingleTimeout) {
                        waitTimeout = requestTimeout.toMilliseconds();
                    }
                    completed.wait(waitTimeout);
                }
                catch (InterruptedException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        }
        if (hasAppErrorsOrTimeout.get()) {
            WebResourceUtils.badRequest("Error or timeout while stopping applications. See log for details.", new Object[0]);
        }
    }

    private Duration parseDuration(String str, Duration defaultValue) {
        if (Strings.isEmpty((CharSequence)str)) {
            return defaultValue;
        }
        return Duration.parse((String)str);
    }

    public VersionSummary getVersion() {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SERVER_STATUS, null)) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized for this operation", Entitlements.getEntitlementContext().user());
        }
        InputStream input = ResourceUtils.create().getResourceFromUrl("classpath://build-metadata.properties");
        Properties properties = new Properties();
        String gitSha1 = null;
        String gitBranch = null;
        try {
            properties.load(input);
            gitSha1 = properties.getProperty(BUILD_SHA_1_PROPERTY);
            gitBranch = properties.getProperty(BUILD_BRANCH_PROPERTY);
        }
        catch (IOException e) {
            log.error("Failed to load build-metadata.properties", (Throwable)e);
        }
        gitSha1 = BrooklynVersion.INSTANCE.getSha1FromOsgiManifest();
        FluentIterable features = FluentIterable.from((Iterable)BrooklynVersion.getFeatures((ManagementContext)this.mgmt())).transform(BrooklynFeatureTransformer.FROM_FEATURE);
        return new VersionSummary(BrooklynVersion.get(), gitSha1, gitBranch, (List)features.toList());
    }

    public boolean isUp() {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SERVER_STATUS, null)) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized for this operation", Entitlements.getEntitlementContext().user());
        }
        Maybe<ManagementContext> mm = this.mgmtMaybe();
        return !mm.isAbsent() && ((ManagementContext)mm.get()).isStartupComplete() && ((ManagementContext)mm.get()).isRunning();
    }

    public boolean isShuttingDown() {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SERVER_STATUS, null)) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized for this operation", Entitlements.getEntitlementContext().user());
        }
        Maybe<ManagementContext> mm = this.mgmtMaybe();
        return !mm.isAbsent() && ((ManagementContext)mm.get()).isStartupComplete() && !((ManagementContext)mm.get()).isRunning();
    }

    public boolean isHealthy() {
        return this.isUp() && ((ManagementContextInternal)this.mgmt()).errors().isEmpty();
    }

    public Map<String, Object> getUpExtended() {
        return MutableMap.of((Object)"up", (Object)this.isUp(), (Object)"shuttingDown", (Object)this.isShuttingDown(), (Object)"healthy", (Object)this.isHealthy(), (Object)"ha", (Object)this.getHighAvailabilityPlaneStates());
    }

    @Deprecated
    public String getStatus() {
        return this.getHighAvailabilityNodeState().toString();
    }

    public String getConfig(String configKey) {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ALL_SERVER_INFO, null)) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized for this operation", Entitlements.getEntitlementContext().user());
        }
        ConfigKey config = ConfigKeys.newStringConfigKey((String)configKey);
        return (String)this.mgmt().getConfig().getConfig(config);
    }

    @Deprecated
    public HighAvailabilitySummary getHighAvailability() {
        return this.getHighAvailabilityPlaneStates();
    }

    public ManagementNodeState getHighAvailabilityNodeState() {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SERVER_STATUS, null)) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized for this operation", Entitlements.getEntitlementContext().user());
        }
        Maybe<ManagementContext> mm = this.mgmtMaybe();
        if (mm.isAbsent()) {
            return ManagementNodeState.INITIALIZING;
        }
        return ((ManagementContext)mm.get()).getHighAvailabilityManager().getNodeState();
    }

    public ManagementNodeState setHighAvailabilityNodeState(HighAvailabilityMode mode) {
        if (mode == null) {
            throw new IllegalStateException("Missing parameter: mode");
        }
        HighAvailabilityManager haMgr = this.mgmt().getHighAvailabilityManager();
        ManagementNodeState existingState = haMgr.getNodeState();
        haMgr.changeMode(mode);
        return existingState;
    }

    public Map<String, Object> getHighAvailabilityMetrics() {
        return this.mgmt().getHighAvailabilityManager().getMetrics();
    }

    public long getHighAvailabitlityPriority() {
        return this.mgmt().getHighAvailabilityManager().getPriority();
    }

    public long setHighAvailabilityPriority(long priority) {
        HighAvailabilityManager haMgr = this.mgmt().getHighAvailabilityManager();
        long oldPrio = haMgr.getPriority();
        haMgr.setPriority(priority);
        return oldPrio;
    }

    public HighAvailabilitySummary getHighAvailabilityPlaneStates() {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SERVER_STATUS, null)) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized for this operation", Entitlements.getEntitlementContext().user());
        }
        ManagementPlaneSyncRecord memento = this.mgmt().getHighAvailabilityManager().getLastManagementPlaneSyncRecord();
        if (memento == null) {
            memento = this.mgmt().getHighAvailabilityManager().loadManagementPlaneSyncRecord(true);
        }
        if (memento == null) {
            return null;
        }
        return HighAvailabilityTransformer.highAvailabilitySummary(this.mgmt().getManagementNodeId(), memento);
    }

    public Response clearHighAvailabilityPlaneStates() {
        this.mgmt().getHighAvailabilityManager().publishClearNonMaster();
        return Response.ok().build();
    }

    public String getUser() {
        EntitlementContext entitlementContext = Entitlements.getEntitlementContext();
        if (entitlementContext != null && entitlementContext.user() != null) {
            return entitlementContext.user();
        }
        return null;
    }

    public Response exportPersistenceData(String preferredOrigin) {
        return this.exportPersistenceData((MementoCopyMode)TypeCoercions.coerce((Object)preferredOrigin, MementoCopyMode.class));
    }

    protected Response exportPersistenceData(MementoCopyMode preferredOrigin) {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ALL_SERVER_INFO, null)) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized for this operation", Entitlements.getEntitlementContext().user());
        }
        File dir = null;
        try {
            String label = this.mgmt().getManagementNodeId() + "-" + Time.makeDateSimpleStampString();
            PersistenceObjectStore targetStore = BrooklynPersistenceUtils.newPersistenceObjectStore((ManagementContext)this.mgmt(), null, (String)("tmp/web-persistence-" + label + "-" + Identifiers.makeRandomId((int)4)));
            dir = ((FileBasedObjectStore)targetStore).getBaseDir();
            Os.deleteOnExitEmptyParentsUpTo((File)dir.getParentFile(), (File)dir.getParentFile());
            BrooklynPersistenceUtils.writeMemento((ManagementContext)this.mgmt(), (PersistenceObjectStore)targetStore, (MementoCopyMode)preferredOrigin);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ArchiveBuilder.zip().addDirContentsAt(((FileBasedObjectStore)targetStore).getBaseDir(), ((FileBasedObjectStore)targetStore).getBaseDir().getName()).stream((OutputStream)baos);
            Os.deleteRecursively((File)dir);
            String filename = "brooklyn-state-" + label + ".zip";
            return Response.ok((Object)baos.toByteArray(), (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE).header("Content-Disposition", (Object)("attachment; filename = " + filename)).build();
        }
        catch (Exception e) {
            log.warn("Unable to serve persistence data (rethrowing): " + e, (Throwable)e);
            if (dir != null) {
                try {
                    Os.deleteRecursively(dir);
                }
                catch (Exception e2) {
                    log.warn("Ignoring error deleting '" + dir + "' after another error, throwing original error (" + e + "); ignored error deleting is: " + e2);
                }
            }
            throw Exceptions.propagate((Throwable)e);
        }
    }
}

