/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.resources;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.policy.Policy;
import brooklyn.policy.PolicySpec;
import brooklyn.policy.basic.Policies;
import brooklyn.rest.api.PolicyApi;
import brooklyn.rest.domain.PolicySummary;
import brooklyn.rest.domain.Status;
import brooklyn.rest.domain.SummaryComparators;
import brooklyn.rest.filter.HaHotStateRequired;
import brooklyn.rest.resources.AbstractBrooklynRestResource;
import brooklyn.rest.transform.ApplicationTransformer;
import brooklyn.rest.transform.PolicyTransformer;
import brooklyn.rest.util.WebResourceUtils;
import brooklyn.util.exceptions.Exceptions;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HaHotStateRequired
public class PolicyResource
extends AbstractBrooklynRestResource
implements PolicyApi {
    private static final Logger log = LoggerFactory.getLogger(PolicyResource.class);

    public List<PolicySummary> list(String application, String entityToken) {
        EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        return FluentIterable.from((Iterable)entity.getPolicies()).transform((Function)new Function<Policy, PolicySummary>((Entity)entity){
            final /* synthetic */ Entity val$entity;
            {
                this.val$entity = entity;
            }

            public PolicySummary apply(Policy policy) {
                return PolicyTransformer.policySummary(this.val$entity, policy);
            }
        }).toSortedList(SummaryComparators.nameComparator());
    }

    public Map<String, Boolean> batchConfigRead(String application, String entityToken) {
        EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Policy p : entity.getPolicies()) {
            result.put(p.getId(), !p.isSuspended());
        }
        return result;
    }

    public PolicySummary addPolicy(String application, String entityToken, String policyTypeName, Map<String, String> config) {
        Class<?> policyType;
        EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        try {
            policyType = Class.forName(policyTypeName);
        }
        catch (ClassNotFoundException e) {
            throw WebResourceUtils.badRequest("No policy with type %s found", policyTypeName);
        }
        catch (ClassCastException e) {
            throw WebResourceUtils.badRequest("No policy with type %s found", policyTypeName);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
        Policy policy = entity.addPolicy(PolicySpec.create(policyType).configure(config));
        log.debug("REST API added policy " + policy + " to " + entity);
        return PolicyTransformer.policySummary((Entity)entity, policy);
    }

    public Status getStatus(String application, String entityToken, String policyId) {
        Policy policy = this.brooklyn().getPolicy(application, entityToken, policyId);
        return ApplicationTransformer.statusFromLifecycle(Policies.getPolicyStatus((Policy)policy));
    }

    public Response start(String application, String entityToken, String policyId) {
        Policy policy = this.brooklyn().getPolicy(application, entityToken, policyId);
        policy.resume();
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response stop(String application, String entityToken, String policyId) {
        Policy policy = this.brooklyn().getPolicy(application, entityToken, policyId);
        policy.suspend();
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response destroy(String application, String entityToken, String policyToken) {
        EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        Policy policy = this.brooklyn().getPolicy((Entity)entity, policyToken);
        policy.suspend();
        entity.removePolicy(policy);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

