/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.resources;

import brooklyn.basic.BrooklynObjectInternal;
import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.management.entitlement.EntitlementClass;
import brooklyn.management.entitlement.EntitlementManager;
import brooklyn.management.entitlement.Entitlements;
import brooklyn.policy.Policy;
import brooklyn.rest.api.PolicyConfigApi;
import brooklyn.rest.domain.PolicyConfigSummary;
import brooklyn.rest.filter.HaHotStateRequired;
import brooklyn.rest.resources.AbstractBrooklynRestResource;
import brooklyn.rest.transform.PolicyTransformer;
import brooklyn.rest.util.BrooklynRestResourceUtils;
import brooklyn.rest.util.WebResourceUtils;
import brooklyn.util.flags.TypeCoercions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;

@HaHotStateRequired
public class PolicyConfigResource
extends AbstractBrooklynRestResource
implements PolicyConfigApi {
    public List<PolicyConfigSummary> list(String application, String entityToken, String policyToken) {
        EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        Policy policy = this.brooklyn().getPolicy((Entity)entity, policyToken);
        ArrayList result = Lists.newArrayList();
        for (ConfigKey key : policy.getPolicyType().getConfigKeys()) {
            result.add(PolicyTransformer.policyConfigSummary(this.brooklyn(), entity, policy, key));
        }
        return result;
    }

    public Map<String, Object> batchConfigRead(String application, String entityToken, String policyToken) {
        Policy policy = this.brooklyn().getPolicy(application, entityToken, policyToken);
        Map source = ((BrooklynObjectInternal)policy).config().getBag().getAllConfig();
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry ek : source.entrySet()) {
            result.put(ek.getKey(), PolicyConfigResource.getStringValueForDisplay(this.brooklyn(), policy, ek.getValue()));
        }
        return result;
    }

    public String get(String application, String entityToken, String policyToken, String configKeyName) {
        Policy policy = this.brooklyn().getPolicy(application, entityToken, policyToken);
        ConfigKey ck = policy.getPolicyType().getConfigKey(configKeyName);
        if (ck == null) {
            throw WebResourceUtils.notFound("Cannot find config key '%s' in policy '%s' of entity '%s'", configKeyName, policy, entityToken);
        }
        return PolicyConfigResource.getStringValueForDisplay(this.brooklyn(), policy, policy.getConfig(ck));
    }

    @Deprecated
    public Response set(String application, String entityToken, String policyToken, String configKeyName, String value) {
        return this.set(application, entityToken, policyToken, configKeyName, (Object)value);
    }

    public Response set(String application, String entityToken, String policyToken, String configKeyName, Object value) {
        EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_ENTITY, (Object)entity)) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized to modify entity '%s'", Entitlements.getEntitlementContext().user(), entity);
        }
        Policy policy = this.brooklyn().getPolicy(application, entityToken, policyToken);
        ConfigKey ck = policy.getPolicyType().getConfigKey(configKeyName);
        if (ck == null) {
            throw WebResourceUtils.notFound("Cannot find config key '%s' in policy '%s' of entity '%s'", configKeyName, policy, entityToken);
        }
        policy.config().set(ck, TypeCoercions.coerce((Object)value, (TypeToken)ck.getTypeToken()));
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    public static String getStringValueForDisplay(BrooklynRestResourceUtils utils, Policy policy, Object value) {
        return utils.getStringValueForDisplay(value);
    }
}

