/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.resources;

import brooklyn.catalog.CatalogItem;
import brooklyn.catalog.internal.CatalogUtils;
import brooklyn.location.Location;
import brooklyn.location.LocationDefinition;
import brooklyn.location.basic.LocationConfigKeys;
import brooklyn.management.ManagementContext;
import brooklyn.rest.api.LocationApi;
import brooklyn.rest.domain.LocationSpec;
import brooklyn.rest.domain.LocationSummary;
import brooklyn.rest.filter.HaHotStateRequired;
import brooklyn.rest.resources.AbstractBrooklynRestResource;
import brooklyn.rest.transform.LocationTransformer;
import brooklyn.rest.util.EntityLocationUtils;
import brooklyn.rest.util.WebResourceUtils;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.text.NaturalOrderComparator;
import brooklyn.util.text.Strings;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HaHotStateRequired
public class LocationResource
extends AbstractBrooklynRestResource
implements LocationApi {
    private static final Logger log = LoggerFactory.getLogger(LocationResource.class);
    private final Set<String> specsWarnedOnException = Sets.newConcurrentHashSet();
    private static NaturalOrderComparator COMPARATOR = new NaturalOrderComparator();

    public List<LocationSummary> list() {
        Function<LocationDefinition, LocationSummary> transformer = new Function<LocationDefinition, LocationSummary>(){

            public LocationSummary apply(LocationDefinition l) {
                try {
                    return LocationTransformer.newInstance(LocationResource.this.mgmt(), l, LocationTransformer.LocationDetailLevel.LOCAL_EXCLUDING_SECRET);
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    String spec = l.getSpec();
                    if (spec == null || LocationResource.this.specsWarnedOnException.add(spec)) {
                        log.warn("Unable to find details of location {} in REST call to list (ignoring location): {}", (Object)l, (Object)e);
                        if (log.isDebugEnabled()) {
                            log.debug("Error details for location " + l, (Throwable)e);
                        }
                    } else if (log.isTraceEnabled()) {
                        log.trace("Unable again to find details of location {} in REST call to list (ignoring location): {}", (Object)l, (Object)e);
                    }
                    return null;
                }
            }
        };
        return FluentIterable.from(this.brooklyn().getLocationRegistry().getDefinedLocations().values()).transform((Function)transformer).filter(LocationSummary.class).toSortedList(LocationResource.nameOrSpecComparator());
    }

    private static Comparator<LocationSummary> nameOrSpecComparator() {
        return new Comparator<LocationSummary>(){

            @Override
            public int compare(LocationSummary o1, LocationSummary o2) {
                return COMPARATOR.compare(LocationResource.getNameOrSpec(o1).toLowerCase(), LocationResource.getNameOrSpec(o2).toLowerCase());
            }
        };
    }

    private static String getNameOrSpec(LocationSummary o) {
        if (Strings.isNonBlank((CharSequence)o.getName())) {
            return o.getName();
        }
        if (Strings.isNonBlank((CharSequence)o.getSpec())) {
            return o.getSpec();
        }
        return o.getId();
    }

    public Map<String, Map<String, Object>> getLocatedLocations() {
        LinkedHashMap<String, Map<String, Object>> result = new LinkedHashMap<String, Map<String, Object>>();
        Map<Location, Integer> counts = new EntityLocationUtils(this.mgmt()).countLeafEntitiesByLocatedLocations();
        for (Map.Entry<Location, Integer> count : counts.entrySet()) {
            Location l = count.getKey();
            MutableMap m = MutableMap.of((Object)"id", (Object)l.getId(), (Object)"name", (Object)l.getDisplayName(), (Object)"leafEntityCount", (Object)count.getValue(), (Object)"latitude", (Object)l.getConfig(LocationConfigKeys.LATITUDE), (Object)"longitude", (Object)l.getConfig(LocationConfigKeys.LONGITUDE));
            result.put(l.getId(), (Map<String, Object>)m);
        }
        return result;
    }

    public LocationSummary get(String locationId) {
        return this.get(locationId, false);
    }

    public LocationSummary get(String locationId, String fullConfig) {
        return this.get(locationId, Boolean.valueOf(fullConfig));
    }

    public LocationSummary get(String locationId, boolean fullConfig) {
        LocationTransformer.LocationDetailLevel configLevel = fullConfig ? LocationTransformer.LocationDetailLevel.FULL_EXCLUDING_SECRET : LocationTransformer.LocationDetailLevel.LOCAL_EXCLUDING_SECRET;
        Location l1 = this.mgmt().getLocationManager().getLocation(locationId);
        if (l1 != null) {
            return LocationTransformer.newInstance(this.mgmt(), l1, configLevel);
        }
        LocationDefinition l2 = this.brooklyn().getLocationRegistry().getDefinedLocationById(locationId);
        if (l2 == null) {
            throw WebResourceUtils.notFound("No location matching %s", locationId);
        }
        return LocationTransformer.newInstance(this.mgmt(), l2, configLevel);
    }

    public Response create(LocationSpec locationSpec) {
        String name = locationSpec.getName();
        ImmutableList.Builder yaml = ImmutableList.builder().add((Object[])new String[]{"brooklyn.catalog:", "  symbolicName: " + name, "", "brooklyn.locations:", "- type: " + locationSpec.getSpec()});
        if (locationSpec.getConfig().size() > 0) {
            yaml.add((Object)"  brooklyn.config:");
            for (Map.Entry entry : locationSpec.getConfig().entrySet()) {
                yaml.add((Object)("    " + (String)entry.getKey() + ": " + entry.getValue()));
            }
        }
        this.brooklyn().getCatalog().addItems(Joiner.on((String)"\n").join((Iterable)yaml.build()));
        LocationDefinition l = this.brooklyn().getLocationRegistry().getDefinedLocationByName(name);
        return Response.created((URI)URI.create(name)).entity((Object)LocationTransformer.newInstance(this.mgmt(), l, LocationTransformer.LocationDetailLevel.LOCAL_EXCLUDING_SECRET)).build();
    }

    @Deprecated
    public void delete(String locationId) {
        if (this.deleteAllVersions(locationId) > 0) {
            return;
        }
        throw WebResourceUtils.notFound("No catalog item location matching %s; only catalog item locations can be deleted", locationId);
    }

    private int deleteAllVersions(String locationId) {
        CatalogItem item = CatalogUtils.getCatalogItemOptionalVersion((ManagementContext)this.mgmt(), (String)locationId);
        if (item == null) {
            return 0;
        }
        this.brooklyn().getCatalog().deleteCatalogItem(item.getSymbolicName(), item.getVersion());
        return 1 + this.deleteAllVersions(locationId);
    }
}

