/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.resources;

import brooklyn.catalog.CatalogItem;
import brooklyn.catalog.CatalogPredicates;
import brooklyn.catalog.internal.BasicBrooklynCatalog;
import brooklyn.catalog.internal.CatalogDto;
import brooklyn.catalog.internal.CatalogItemComparator;
import brooklyn.catalog.internal.CatalogUtils;
import brooklyn.entity.Entity;
import brooklyn.location.Location;
import brooklyn.management.ManagementContext;
import brooklyn.management.entitlement.EntitlementClass;
import brooklyn.management.entitlement.EntitlementManager;
import brooklyn.management.entitlement.Entitlements;
import brooklyn.policy.Policy;
import brooklyn.rest.api.CatalogApi;
import brooklyn.rest.domain.ApiError;
import brooklyn.rest.domain.CatalogEntitySummary;
import brooklyn.rest.domain.CatalogItemSummary;
import brooklyn.rest.domain.CatalogLocationSummary;
import brooklyn.rest.domain.CatalogPolicySummary;
import brooklyn.rest.filter.HaHotStateRequired;
import brooklyn.rest.resources.AbstractBrooklynRestResource;
import brooklyn.rest.transform.CatalogTransformer;
import brooklyn.rest.util.WebResourceUtils;
import brooklyn.util.ResourceUtils;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.stream.Streams;
import brooklyn.util.text.StringPredicates;
import brooklyn.util.text.Strings;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.sun.jersey.core.header.FormDataContentDisposition;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HaHotStateRequired
public class CatalogResource
extends AbstractBrooklynRestResource
implements CatalogApi {
    private static final Logger log = LoggerFactory.getLogger(CatalogResource.class);
    private final Function<CatalogItem, CatalogItemSummary> TO_CATALOG_ITEM_SUMMARY = new Function<CatalogItem, CatalogItemSummary>(){

        public CatalogItemSummary apply(@Nullable CatalogItem input) {
            return CatalogTransformer.catalogItemSummary(CatalogResource.this.brooklyn(), input);
        }
    };
    static Set<String> missingIcons = MutableSet.of();

    @Consumes(value={"multipart/form-data"})
    public Response createFromMultipart(InputStream uploadedInputStream, FormDataContentDisposition fileDetail) {
        return this.create(Streams.readFullyString((InputStream)uploadedInputStream));
    }

    public Response create(String yaml) {
        Iterable items;
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.ADD_CATALOG_ITEM, (Object)yaml)) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized to add catalog item", Entitlements.getEntitlementContext().user());
        }
        try {
            items = this.brooklyn().getCatalog().addItems(yaml);
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/json").entity((Object)ApiError.of((Throwable)e)).build();
        }
        log.info("REST created catalog items: " + items);
        MutableMap result = MutableMap.of();
        for (CatalogItem item : items) {
            result.put(item.getId(), CatalogTransformer.catalogItemSummary(this.brooklyn(), item));
        }
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)result).build();
    }

    public Response resetXml(String xml, boolean ignoreErrors) {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_CATALOG_ITEM, null) || !Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.ADD_CATALOG_ITEM, null)) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized to modify catalog", Entitlements.getEntitlementContext().user());
        }
        ((BasicBrooklynCatalog)this.mgmt().getCatalog()).reset(CatalogDto.newDtoFromXmlContents((String)xml, (String)"REST reset"), !ignoreErrors);
        return Response.ok().build();
    }

    @Deprecated
    public void deleteEntity(String entityId) throws Exception {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_CATALOG_ITEM, (Object)Entitlements.StringAndArgument.of((String)entityId, (Object)"delete"))) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized to modify catalog", Entitlements.getEntitlementContext().user());
        }
        try {
            CatalogItem item = CatalogUtils.getCatalogItemOptionalVersion((ManagementContext)this.mgmt(), (String)entityId);
            if (item == null) {
                throw WebResourceUtils.notFound("Entity with id '%s' not found", entityId);
            }
            if (item.getCatalogItemType() != CatalogItem.CatalogItemType.ENTITY && item.getCatalogItemType() != CatalogItem.CatalogItemType.TEMPLATE) {
                throw WebResourceUtils.preconditionFailed("Item with id '%s' not an entity", entityId);
            }
            this.brooklyn().getCatalog().deleteCatalogItem(item.getSymbolicName(), item.getVersion());
        }
        catch (NoSuchElementException e) {
            throw WebResourceUtils.notFound("Entity with id '%s' not found", entityId);
        }
    }

    public void deleteApplication(String applicationId, String version) throws Exception {
        this.deleteEntity(applicationId, version);
    }

    public void deleteEntity(String entityId, String version) throws Exception {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_CATALOG_ITEM, (Object)Entitlements.StringAndArgument.of((String)(entityId + (Strings.isBlank((CharSequence)version) ? "" : ":" + version)), (Object)"delete"))) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized to modify catalog", Entitlements.getEntitlementContext().user());
        }
        CatalogItem item = this.mgmt().getCatalog().getCatalogItem(entityId, version);
        if (item == null) {
            throw WebResourceUtils.notFound("Entity with id '%s:%s' not found", entityId, version);
        }
        if (item.getCatalogItemType() != CatalogItem.CatalogItemType.ENTITY && item.getCatalogItemType() != CatalogItem.CatalogItemType.TEMPLATE) {
            throw WebResourceUtils.preconditionFailed("Item with id '%s:%s' not an entity", entityId, version);
        }
        this.brooklyn().getCatalog().deleteCatalogItem(item.getSymbolicName(), item.getVersion());
    }

    public void deletePolicy(String policyId, String version) throws Exception {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_CATALOG_ITEM, (Object)Entitlements.StringAndArgument.of((String)(policyId + (Strings.isBlank((CharSequence)version) ? "" : ":" + version)), (Object)"delete"))) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized to modify catalog", Entitlements.getEntitlementContext().user());
        }
        CatalogItem item = this.mgmt().getCatalog().getCatalogItem(policyId, version);
        if (item == null) {
            throw WebResourceUtils.notFound("Policy with id '%s:%s' not found", policyId, version);
        }
        if (item.getCatalogItemType() != CatalogItem.CatalogItemType.POLICY) {
            throw WebResourceUtils.preconditionFailed("Item with id '%s:%s' not a policy", policyId, version);
        }
        this.brooklyn().getCatalog().deleteCatalogItem(item.getSymbolicName(), item.getVersion());
    }

    public void deleteLocation(String locationId, String version) throws Exception {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_CATALOG_ITEM, (Object)Entitlements.StringAndArgument.of((String)(locationId + (Strings.isBlank((CharSequence)version) ? "" : ":" + version)), (Object)"delete"))) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized to modify catalog", Entitlements.getEntitlementContext().user());
        }
        CatalogItem item = this.mgmt().getCatalog().getCatalogItem(locationId, version);
        if (item == null) {
            throw WebResourceUtils.notFound("Location with id '%s:%s' not found", locationId, version);
        }
        if (item.getCatalogItemType() != CatalogItem.CatalogItemType.LOCATION) {
            throw WebResourceUtils.preconditionFailed("Item with id '%s:%s' not a location", locationId, version);
        }
        this.brooklyn().getCatalog().deleteCatalogItem(item.getSymbolicName(), item.getVersion());
    }

    public List<CatalogEntitySummary> listEntities(String regex, String fragment, boolean allVersions) {
        List<CatalogItemSummary> result = this.getCatalogItemSummariesMatchingRegexFragment(CatalogPredicates.IS_ENTITY, regex, fragment, allVersions);
        return CatalogResource.castList(result, CatalogEntitySummary.class);
    }

    public List<CatalogItemSummary> listApplications(String regex, String fragment, boolean allVersions) {
        Predicate filter = Predicates.and((Predicate)CatalogPredicates.deprecated((boolean)false), (Predicate)CatalogPredicates.IS_TEMPLATE);
        return this.getCatalogItemSummariesMatchingRegexFragment(filter, regex, fragment, allVersions);
    }

    @Deprecated
    public CatalogEntitySummary getEntity(String entityId) {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_CATALOG_ITEM, (Object)entityId)) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized to see catalog entry", Entitlements.getEntitlementContext().user());
        }
        CatalogItem result = CatalogUtils.getCatalogItemOptionalVersion((ManagementContext)this.mgmt(), Entity.class, (String)entityId);
        if (result == null) {
            throw WebResourceUtils.notFound("Entity with id '%s' not found", entityId);
        }
        return CatalogTransformer.catalogEntitySummary(this.brooklyn(), result);
    }

    public CatalogEntitySummary getEntity(String entityId, String version) {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_CATALOG_ITEM, (Object)(entityId + (Strings.isBlank((CharSequence)version) ? "" : ":" + version)))) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized to see catalog entry", Entitlements.getEntitlementContext().user());
        }
        CatalogItem result = this.brooklyn().getCatalog().getCatalogItem(entityId, version);
        if (result == null) {
            throw WebResourceUtils.notFound("Entity with id '%s:%s' not found", entityId, version);
        }
        return CatalogTransformer.catalogEntitySummary(this.brooklyn(), result);
    }

    @Deprecated
    public CatalogEntitySummary getApplication(String entityId) throws Exception {
        return this.getEntity(entityId);
    }

    public CatalogEntitySummary getApplication(String applicationId, String version) {
        return this.getEntity(applicationId, version);
    }

    public List<CatalogPolicySummary> listPolicies(String regex, String fragment, boolean allVersions) {
        List<CatalogItemSummary> result = this.getCatalogItemSummariesMatchingRegexFragment(CatalogPredicates.IS_POLICY, regex, fragment, allVersions);
        return CatalogResource.castList(result, CatalogPolicySummary.class);
    }

    @Deprecated
    public CatalogPolicySummary getPolicy(String policyId) {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_CATALOG_ITEM, (Object)policyId)) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized to see catalog entry", Entitlements.getEntitlementContext().user());
        }
        CatalogItem result = CatalogUtils.getCatalogItemOptionalVersion((ManagementContext)this.mgmt(), Policy.class, (String)policyId);
        if (result == null) {
            throw WebResourceUtils.notFound("Policy with id '%s' not found", policyId);
        }
        return CatalogTransformer.catalogPolicySummary(this.brooklyn(), result);
    }

    public CatalogPolicySummary getPolicy(String policyId, String version) throws Exception {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_CATALOG_ITEM, (Object)(policyId + (Strings.isBlank((CharSequence)version) ? "" : ":" + version)))) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized to see catalog entry", Entitlements.getEntitlementContext().user());
        }
        CatalogItem result = this.brooklyn().getCatalog().getCatalogItem(policyId, version);
        if (result == null) {
            throw WebResourceUtils.notFound("Policy with id '%s:%s' not found", policyId, version);
        }
        return CatalogTransformer.catalogPolicySummary(this.brooklyn(), result);
    }

    public List<CatalogLocationSummary> listLocations(String regex, String fragment, boolean allVersions) {
        List<CatalogItemSummary> result = this.getCatalogItemSummariesMatchingRegexFragment(CatalogPredicates.IS_LOCATION, regex, fragment, allVersions);
        return CatalogResource.castList(result, CatalogLocationSummary.class);
    }

    @Deprecated
    public CatalogLocationSummary getLocation(String locationId) {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_CATALOG_ITEM, (Object)locationId)) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized to see catalog entry", Entitlements.getEntitlementContext().user());
        }
        CatalogItem result = CatalogUtils.getCatalogItemOptionalVersion((ManagementContext)this.mgmt(), Location.class, (String)locationId);
        if (result == null) {
            throw WebResourceUtils.notFound("Location with id '%s' not found", locationId);
        }
        return CatalogTransformer.catalogLocationSummary(this.brooklyn(), result);
    }

    public CatalogLocationSummary getLocation(String locationId, String version) throws Exception {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_CATALOG_ITEM, (Object)(locationId + (Strings.isBlank((CharSequence)version) ? "" : ":" + version)))) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized to see catalog entry", Entitlements.getEntitlementContext().user());
        }
        CatalogItem result = this.brooklyn().getCatalog().getCatalogItem(locationId, version);
        if (result == null) {
            throw WebResourceUtils.notFound("Location with id '%s:%s' not found", locationId, version);
        }
        return CatalogTransformer.catalogLocationSummary(this.brooklyn(), result);
    }

    private <T, SpecT> List<CatalogItemSummary> getCatalogItemSummariesMatchingRegexFragment(Predicate<CatalogItem<T, SpecT>> type, String regex, String fragment, boolean allVersions) {
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(type);
        if (Strings.isNonEmpty((CharSequence)regex)) {
            filters.add(CatalogPredicates.xml((Predicate)StringPredicates.containsRegex((String)regex)));
        }
        if (Strings.isNonEmpty((CharSequence)fragment)) {
            filters.add(CatalogPredicates.xml((Predicate)StringPredicates.containsLiteralIgnoreCase((String)fragment)));
        }
        if (!allVersions) {
            filters.add(CatalogPredicates.isBestVersion((ManagementContext)this.mgmt()));
        }
        filters.add(CatalogPredicates.entitledToSee((ManagementContext)this.mgmt()));
        ImmutableList sortedItems = FluentIterable.from((Iterable)this.brooklyn().getCatalog().getCatalogItems()).filter(Predicates.and(filters)).toSortedList((Comparator)CatalogItemComparator.getInstance());
        return Lists.transform((List)sortedItems, this.TO_CATALOG_ITEM_SUMMARY);
    }

    @Deprecated
    public Response getIcon(String itemId) {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_CATALOG_ITEM, (Object)itemId)) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized to see catalog entry", Entitlements.getEntitlementContext().user());
        }
        CatalogItem result = CatalogUtils.getCatalogItemOptionalVersion((ManagementContext)this.mgmt(), (String)itemId);
        return this.getCatalogItemIcon(result);
    }

    public Response getIcon(String itemId, String version) {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_CATALOG_ITEM, (Object)(itemId + (Strings.isBlank((CharSequence)version) ? "" : ":" + version)))) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized to see catalog entry", Entitlements.getEntitlementContext().user());
        }
        CatalogItem result = this.brooklyn().getCatalog().getCatalogItem(itemId, version);
        return this.getCatalogItemIcon(result);
    }

    public void setDeprecated(String itemId, boolean deprecated) {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_CATALOG_ITEM, (Object)Entitlements.StringAndArgument.of((String)itemId, (Object)"deprecated"))) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized to modify catalog", Entitlements.getEntitlementContext().user());
        }
        CatalogItem item = CatalogUtils.getCatalogItemOptionalVersion((ManagementContext)this.mgmt(), (String)itemId);
        if (item == null) {
            throw WebResourceUtils.notFound("Catalog item with id '%s' not found", itemId);
        }
        item.setDeprecated(deprecated);
        this.mgmt().getCatalog().persist(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response getCatalogItemIcon(CatalogItem<?, ?> result) {
        String url = result.getIconUrl();
        if (url == null) {
            log.debug("No icon available for " + result + "; returning " + Response.Status.NO_CONTENT);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        if (this.brooklyn().isUrlServerSideAndSafe(url)) {
            log.debug("Loading and returning " + url + " as icon for " + result);
            MediaType mime = WebResourceUtils.getImageMediaTypeFromExtension(Files.getFileExtension((String)url));
            try {
                InputStream content = ResourceUtils.create((Object)CatalogUtils.newClassLoadingContext((ManagementContext)this.mgmt(), result)).getResourceFromUrl(url);
                return Response.ok((Object)content, (MediaType)mime).build();
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                Set<String> set = missingIcons;
                synchronized (set) {
                    if (missingIcons.add(url)) {
                        log.warn("Missing icon data for " + result.getId() + ", expected at: " + url + " (subsequent messages will log debug only)");
                        log.debug("Trace for missing icon data at " + url + ": " + e, (Throwable)e);
                    } else {
                        log.debug("Missing icon data for " + result.getId() + ", expected at: " + url + " (already logged WARN and error details)");
                    }
                }
                throw WebResourceUtils.notFound("Icon unavailable for %s", result.getId());
            }
        }
        log.debug("Returning redirect to " + url + " as icon for " + result);
        return Response.temporaryRedirect((URI)URI.create(url)).build();
    }

    private static <T> List<T> castList(List<? super T> list, Class<T> elementType) {
        ArrayList result = Lists.newArrayList();
        Iterator<T> li = list.iterator();
        while (li.hasNext()) {
            try {
                result.add(li.next());
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof NoClassDefFoundError)) {
                    Exceptions.propagateIfFatal((Throwable)throwable);
                }
                log.debug("Ignoring invalid catalog item: " + throwable);
            }
        }
        return result;
    }
}

