/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.resources;

import brooklyn.catalog.internal.CatalogUtils;
import brooklyn.entity.Application;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.basic.AbstractGroup;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.EntityPredicates;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.trait.Startable;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.Sensors;
import brooklyn.location.Location;
import brooklyn.management.ManagementContext;
import brooklyn.management.Task;
import brooklyn.management.entitlement.EntitlementClass;
import brooklyn.management.entitlement.EntitlementManager;
import brooklyn.management.entitlement.EntitlementPredicates;
import brooklyn.management.entitlement.Entitlements;
import brooklyn.management.internal.EntityManagementUtils;
import brooklyn.rest.api.ApplicationApi;
import brooklyn.rest.domain.ApplicationSpec;
import brooklyn.rest.domain.ApplicationSummary;
import brooklyn.rest.domain.EntitySpec;
import brooklyn.rest.domain.EntitySummary;
import brooklyn.rest.domain.TaskSummary;
import brooklyn.rest.filter.HaHotStateRequired;
import brooklyn.rest.resources.AbstractBrooklynRestResource;
import brooklyn.rest.transform.ApplicationTransformer;
import brooklyn.rest.transform.EntityTransformer;
import brooklyn.rest.transform.TaskTransformer;
import brooklyn.rest.util.BrooklynRestResourceUtils;
import brooklyn.rest.util.WebResourceUtils;
import brooklyn.util.ResourceUtils;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.text.Strings;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import io.brooklyn.camp.spi.AssemblyTemplate;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HaHotStateRequired
public class ApplicationResource
extends AbstractBrooklynRestResource
implements ApplicationApi {
    private static final Logger log = LoggerFactory.getLogger(ApplicationResource.class);
    @Context
    private UriInfo uriInfo;

    @Deprecated
    public JsonNode applicationTree() {
        ArrayNode apps = this.mapper().createArrayNode();
        for (Application application : this.mgmt().getApplications()) {
            apps.add(this.recursiveTreeFromEntity((Entity)application));
        }
        return apps;
    }

    private ObjectNode entityBase(Entity entity) {
        String iconUrl;
        Lifecycle serviceState;
        ObjectNode aRoot = this.mapper().createObjectNode();
        aRoot.put("name", entity.getDisplayName());
        aRoot.put("id", entity.getId());
        aRoot.put("type", entity.getEntityType().getName());
        Boolean serviceUp = (Boolean)entity.getAttribute(Attributes.SERVICE_UP);
        if (serviceUp != null) {
            aRoot.put("serviceUp", serviceUp);
        }
        if ((serviceState = (Lifecycle)entity.getAttribute(Attributes.SERVICE_STATE_ACTUAL)) != null) {
            aRoot.put("serviceState", serviceState.toString());
        }
        if ((iconUrl = entity.getIconUrl()) != null) {
            if (this.brooklyn().isUrlServerSideAndSafe(iconUrl)) {
                iconUrl = EntityTransformer.entityUri(entity) + "/icon";
            }
            aRoot.put("iconUrl", iconUrl);
        }
        return aRoot;
    }

    private JsonNode recursiveTreeFromEntity(Entity entity) {
        ObjectNode aRoot = this.entityBase(entity);
        if (!entity.getChildren().isEmpty()) {
            aRoot.put("children", (JsonNode)this.childEntitiesRecursiveAsArray(entity));
        }
        return aRoot;
    }

    private JsonNode fromEntity(Entity entity) {
        Collection members;
        ObjectNode aRoot = this.entityBase(entity);
        aRoot.put("applicationId", entity.getApplicationId());
        if (entity.getParent() != null) {
            aRoot.put("parentId", entity.getParent().getId());
        }
        if (!entity.getGroups().isEmpty()) {
            aRoot.put("groupIds", (JsonNode)this.entitiesIdAsArray(entity.getGroups()));
        }
        if (!entity.getChildren().isEmpty()) {
            aRoot.put("children", (JsonNode)this.entitiesIdAndNameAsArray(entity.getChildren()));
        }
        if (entity instanceof Group && (members = (Collection)entity.getAttribute(AbstractGroup.GROUP_MEMBERS)) != null && !members.isEmpty()) {
            aRoot.put("members", (JsonNode)this.entitiesIdAndNameAsArray(members));
        }
        return aRoot;
    }

    private ArrayNode childEntitiesRecursiveAsArray(Entity entity) {
        ArrayNode node = this.mapper().createArrayNode();
        for (Entity e : entity.getChildren()) {
            if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)entity)) continue;
            node.add(this.recursiveTreeFromEntity(e));
        }
        return node;
    }

    private ArrayNode entitiesIdAndNameAsArray(Collection<? extends Entity> entities) {
        ArrayNode node = this.mapper().createArrayNode();
        for (Entity entity : entities) {
            if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)entity)) continue;
            ObjectNode holder = this.mapper().createObjectNode();
            holder.put("id", entity.getId());
            holder.put("name", entity.getDisplayName());
            node.add((JsonNode)holder);
        }
        return node;
    }

    private ArrayNode entitiesIdAsArray(Collection<? extends Entity> entities) {
        ArrayNode node = this.mapper().createArrayNode();
        for (Entity entity : entities) {
            if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)entity)) continue;
            node.add(entity.getId());
        }
        return node;
    }

    public JsonNode fetch(String entityIds) {
        MutableMap jsonEntitiesById = MutableMap.of();
        for (Application application : this.mgmt().getApplications()) {
            jsonEntitiesById.put(application.getId(), this.fromEntity((Entity)application));
        }
        if (entityIds != null) {
            for (String entityId : entityIds.split(",")) {
                for (Entity entity = this.mgmt().getEntityManager().getEntity(entityId.trim()); entity != null && entity.getParent() != null; entity = entity.getParent()) {
                    if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)entity)) continue;
                    jsonEntitiesById.put(entity.getId(), this.fromEntity(entity));
                }
            }
        }
        ArrayNode result = this.mapper().createArrayNode();
        for (JsonNode n : jsonEntitiesById.values()) {
            result.add(n);
        }
        return result;
    }

    public List<ApplicationSummary> list(String typeRegex) {
        if (Strings.isBlank((CharSequence)typeRegex)) {
            typeRegex = ".*";
        }
        return FluentIterable.from((Iterable)this.mgmt().getApplications()).filter(EntitlementPredicates.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY)).filter(EntityPredicates.hasInterfaceMatching((String)typeRegex)).transform(ApplicationTransformer.FROM_APPLICATION).toList();
    }

    public ApplicationSummary get(String application) {
        return ApplicationTransformer.summaryFromApplication(this.brooklyn().getApplication(application));
    }

    public Response create(ApplicationSpec applicationSpec) {
        return this.createFromAppSpec(applicationSpec);
    }

    @Deprecated
    protected Response createFromAppSpec(ApplicationSpec applicationSpec) {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.DEPLOY_APPLICATION, (Object)applicationSpec)) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized to start application %s", Entitlements.getEntitlementContext().user(), applicationSpec);
        }
        this.checkApplicationTypesAreValid(applicationSpec);
        this.checkLocationsAreValid(applicationSpec);
        List<Location> locations = this.brooklyn().getLocations(applicationSpec);
        Application app = this.brooklyn().create(applicationSpec);
        Task<?> t = this.brooklyn().start(app, locations);
        TaskSummary ts = (TaskSummary)TaskTransformer.FROM_TASK.apply(t);
        URI ref = this.uriInfo.getBaseUriBuilder().path(ApplicationApi.class).path(ApplicationApi.class, "get").build(new Object[]{app.getApplicationId()});
        return Response.created((URI)ref).entity((Object)ts).build();
    }

    public Response createFromYaml(String yaml) {
        URI uri;
        try {
            uri = new URI(yaml);
        }
        catch (URISyntaxException e) {
            uri = null;
        }
        if (uri != null) {
            log.debug("Create app called with URI; retrieving contents: {}", (Object)uri);
            yaml = ResourceUtils.create((Object)this.mgmt()).getResourceAsString(uri.toString());
        }
        log.debug("Creating app from yaml:\n{}", (Object)yaml);
        AssemblyTemplate at = this.camp().pdp().registerDeploymentPlan((Reader)new StringReader(yaml));
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.DEPLOY_APPLICATION, (Object)at)) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized to start application %s", Entitlements.getEntitlementContext().user(), yaml);
        }
        return this.launch(at);
    }

    private Response launch(AssemblyTemplate at) {
        try {
            EntityManagementUtils.CreationResult result = EntityManagementUtils.createStarting((ManagementContext)this.mgmt(), (AssemblyTemplate)at);
            Application app = (Application)result.get();
            if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.INVOKE_EFFECTOR, (Object)Entitlements.EntityAndItem.of((Entity)app, (Object)Entitlements.StringAndArgument.of((String)Startable.START.getName(), null)))) {
                throw WebResourceUtils.unauthorized("User '%s' is not authorized to start application %s", Entitlements.getEntitlementContext().user(), at.getType());
            }
            log.info("Launched from YAML: " + at + " -> " + app + " (" + result.task() + ")");
            URI ref = URI.create(app.getApplicationId());
            Response.ResponseBuilder response = Response.created((URI)ref);
            if (result.task() != null) {
                response.entity(TaskTransformer.FROM_TASK.apply((Object)result.task()));
            }
            return response.build();
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public Response createPoly(byte[] inputToAutodetectType) {
        log.debug("Creating app from autodetecting input");
        boolean looksLikeLegacy = false;
        Exception legacyFormatException = null;
        try {
            ApplicationSpec appSpec = (ApplicationSpec)this.mapper().readValue(inputToAutodetectType, ApplicationSpec.class);
            return this.createFromAppSpec(appSpec);
        }
        catch (Exception e) {
            boolean looksLikeYaml;
            block11: {
                Exceptions.propagateIfFatal((Throwable)e);
                legacyFormatException = e;
                log.debug("Input is not legacy ApplicationSpec JSON (will try others): " + e, (Throwable)e);
                AssemblyTemplate template = null;
                looksLikeYaml = false;
                try {
                    template = this.camp().pdp().registerDeploymentPlan((Reader)new StringReader(new String(inputToAutodetectType)));
                    if (!template.getPlatformComponentTemplates().isEmpty() || !template.getApplicationComponentTemplates().isEmpty()) {
                        looksLikeYaml = true;
                    } else if (template.getCustomAttributes().containsKey("type") || template.getCustomAttributes().containsKey("entities")) {
                        looksLikeLegacy = true;
                    }
                }
                catch (Exception e2) {
                    Exceptions.propagateIfFatal((Throwable)e2);
                    log.debug("Input is not valid YAML: " + e2);
                }
                if (template != null) {
                    try {
                        return this.launch(template);
                    }
                    catch (Exception e3) {
                        Exceptions.propagateIfFatal((Throwable)e3);
                        if (!looksLikeYaml) break block11;
                        throw Exceptions.propagate((Throwable)e3);
                    }
                }
            }
            if ((looksLikeLegacy || !looksLikeYaml) && legacyFormatException != null) {
                throw Throwables.propagate((Throwable)legacyFormatException);
            }
            return Response.serverError().entity((Object)"Unsupported format; not able to autodetect.").build();
        }
    }

    public Response createFromForm(String contents) {
        log.debug("Creating app from form");
        return this.createPoly(contents.getBytes());
    }

    public Response delete(String application) {
        Application app = this.brooklyn().getApplication(application);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.INVOKE_EFFECTOR, (Object)Entitlements.EntityAndItem.of((Entity)app, (Object)Entitlements.StringAndArgument.of((String)"delete", null)))) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized to delete application %s", Entitlements.getEntitlementContext().user(), app);
        }
        Task<?> t = this.brooklyn().destroy(app);
        TaskSummary ts = (TaskSummary)TaskTransformer.FROM_TASK.apply(t);
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)ts).build();
    }

    private void checkApplicationTypesAreValid(ApplicationSpec applicationSpec) {
        String appType = applicationSpec.getType();
        if (appType != null) {
            this.checkEntityTypeIsValid(appType);
            if (applicationSpec.getEntities() != null) {
                throw WebResourceUtils.preconditionFailed("Application given explicit type '%s' must not define entities", appType);
            }
            return;
        }
        for (EntitySpec entitySpec : applicationSpec.getEntities()) {
            String entityType = entitySpec.getType();
            this.checkEntityTypeIsValid((String)Preconditions.checkNotNull((Object)entityType, (Object)"entityType"));
        }
    }

    private void checkEntityTypeIsValid(String type) {
        if (CatalogUtils.getCatalogItemOptionalVersion((ManagementContext)this.mgmt(), (String)type) == null) {
            try {
                this.brooklyn().getCatalogClassLoader().loadClass(type);
            }
            catch (ClassNotFoundException e) {
                log.debug("Class not found for type '" + type + "'; reporting 404", (Throwable)e);
                throw WebResourceUtils.notFound("Undefined type '%s'", type);
            }
            log.info("Entity type '{}' not defined in catalog but is on classpath; continuing", (Object)type);
        }
    }

    private void checkLocationsAreValid(ApplicationSpec applicationSpec) {
        for (String locationId : applicationSpec.getLocations()) {
            locationId = BrooklynRestResourceUtils.fixLocation(locationId);
            if (this.brooklyn().getLocationRegistry().canMaybeResolve(locationId) || this.brooklyn().getLocationRegistry().getDefinedLocationById(locationId) != null) continue;
            throw WebResourceUtils.notFound("Undefined location '%s'", locationId);
        }
    }

    public List<EntitySummary> getDescendants(String application, String typeRegex) {
        return EntityTransformer.entitySummaries(this.brooklyn().descendantsOfType(application, application, typeRegex));
    }

    public Map<String, Object> getDescendantsSensor(String application, String sensor, String typeRegex) {
        Iterable<Entity> descs = this.brooklyn().descendantsOfType(application, application, typeRegex);
        return ApplicationResource.getSensorMap(sensor, descs);
    }

    public static Map<String, Object> getSensorMap(String sensor, Iterable<Entity> descs) {
        Entity potentialSource;
        if (Iterables.isEmpty(descs)) {
            return Collections.emptyMap();
        }
        MutableMap result = MutableMap.of();
        Iterator<Entity> di = descs.iterator();
        AttributeSensor s = null;
        while (di.hasNext() && (s = (potentialSource = di.next()).getEntityType().getSensor(sensor)) == null) {
        }
        if (s == null) {
            s = Sensors.newSensor(Object.class, (String)sensor);
        }
        if (!(s instanceof AttributeSensor)) {
            log.warn("Cannot retrieve non-attribute sensor " + s + " for entities; returning empty map");
            return result;
        }
        for (Entity e : descs) {
            Object v = null;
            try {
                v = e.getAttribute(s);
            }
            catch (Exception exc) {
                Exceptions.propagateIfFatal((Throwable)exc);
                log.warn("Error retrieving sensor " + s + " for " + e + " (ignoring): " + exc);
            }
            if (v == null) continue;
            result.put(e.getId(), v);
        }
        return result;
    }
}

